/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.upgrade.v1_4_1;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v1_4_1.util.KaleoActionTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v1_4_1.util.KaleoConditionTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v1_4_1.util.KaleoDefinitionTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v1_4_1.util.KaleoInstanceTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v1_4_1.util.KaleoInstanceTokenTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v1_4_1.util.KaleoLogTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v1_4_1.util.KaleoNodeTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v1_4_1.util.KaleoNotificationRecipientTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v1_4_1.util.KaleoNotificationTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v1_4_1.util.KaleoTaskAssignmentInstanceTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v1_4_1.util.KaleoTaskAssignmentTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v1_4_1.util.KaleoTaskFormInstanceTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v1_4_1.util.KaleoTaskFormTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v1_4_1.util.KaleoTaskInstanceTokenTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v1_4_1.util.KaleoTaskTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v1_4_1.util.KaleoTimerInstanceTokenTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v1_4_1.util.KaleoTimerTable;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v1_4_1.util.KaleoTransitionTable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;

public class UpgradeKaleoDefinitionVersion
extends UpgradeProcess {
    private static final String[] _TABLE_NAMES = new String[]{"KaleoAction", "KaleoCondition", "KaleoInstance", "KaleoInstanceToken", "KaleoLog", "KaleoNode", "KaleoNotification", "KaleoNotificationRecipient", "KaleoTask", "KaleoTaskAssignment", "KaleoTaskAssignmentInstance", "KaleoTaskForm", "KaleoTaskFormInstance", "KaleoTaskInstanceToken", "KaleoTimer", "KaleoTimerInstanceToken", "KaleoTransition"};

    protected void addBatch(PreparedStatement ps, long kaleoDefinitionId, long kaleoDefinitionVersionId) throws SQLException {
        ps.setLong(1, kaleoDefinitionVersionId);
        ps.setLong(2, kaleoDefinitionId);
        ps.addBatch();
    }

    protected void doUpgrade() throws Exception {
        this.upgradeKaleoDefinitionVersion();
        this.removeDuplicateKaleoDefinitions();
        this.removeKaleoDefinitionId();
        this.removeStartKaleoNodeId();
    }

    protected String getVersion(int version) {
        return version + "." + 0;
    }

    protected void removeDuplicateKaleoDefinitions() throws IOException, SQLException {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps1 = this.connection.prepareStatement("select name, MAX(version) as version from KaleoDefinition group by name");
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"delete from KaleoDefinition where name = ? and version < ?");
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                String name = rs.getString("name");
                int version = rs.getInt("version");
                ps2.setString(1, name);
                ps2.setInt(2, version);
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }

    protected void removeKaleoDefinitionId() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            if (this.hasColumn("KaleoAction", "kaleoDefinitionId")) {
                this.alter(KaleoActionTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableDropColumn((UpgradeProcess)this, "kaleoDefinitionId")});
            }
            if (this.hasColumn("KaleoCondition", "kaleoDefinitionId")) {
                this.alter(KaleoConditionTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableDropColumn((UpgradeProcess)this, "kaleoDefinitionId")});
            }
            if (this.hasColumn("KaleoInstance", "kaleoDefinitionId")) {
                this.alter(KaleoInstanceTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableDropColumn((UpgradeProcess)this, "kaleoDefinitionId")});
            }
            if (this.hasColumn("KaleoInstanceToken", "kaleoDefinitionId")) {
                this.alter(KaleoInstanceTokenTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableDropColumn((UpgradeProcess)this, "kaleoDefinitionId")});
            }
            if (this.hasColumn("KaleoLog", "kaleoDefinitionId")) {
                this.alter(KaleoLogTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableDropColumn((UpgradeProcess)this, "kaleoDefinitionId")});
            }
            if (this.hasColumn("KaleoNode", "kaleoDefinitionId")) {
                this.alter(KaleoNodeTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableDropColumn((UpgradeProcess)this, "kaleoDefinitionId")});
            }
            if (this.hasColumn("KaleoNotification", "kaleoDefinitionId")) {
                this.alter(KaleoNotificationTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableDropColumn((UpgradeProcess)this, "kaleoDefinitionId")});
            }
            if (this.hasColumn("KaleoNotificationRecipient", "kaleoDefinitionId")) {
                this.alter(KaleoNotificationRecipientTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableDropColumn((UpgradeProcess)this, "kaleoDefinitionId")});
            }
            if (this.hasColumn("KaleoTask", "kaleoDefinitionId")) {
                this.alter(KaleoTaskTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableDropColumn((UpgradeProcess)this, "kaleoDefinitionId")});
            }
            if (this.hasColumn("KaleoTaskAssignment", "kaleoDefinitionId")) {
                this.alter(KaleoTaskAssignmentTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableDropColumn((UpgradeProcess)this, "kaleoDefinitionId")});
            }
            if (this.hasColumn("KaleoTaskAssignmentInstance", "kaleoDefinitionId")) {
                this.alter(KaleoTaskAssignmentInstanceTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableDropColumn((UpgradeProcess)this, "kaleoDefinitionId")});
            }
            if (this.hasColumn("KaleoTaskForm", "kaleoDefinitionId")) {
                this.alter(KaleoTaskFormTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableDropColumn((UpgradeProcess)this, "kaleoDefinitionId")});
            }
            if (this.hasColumn("KaleoTaskFormInstance", "kaleoDefinitionId")) {
                this.alter(KaleoTaskFormInstanceTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableDropColumn((UpgradeProcess)this, "kaleoDefinitionId")});
            }
            if (this.hasColumn("KaleoTaskInstanceToken", "kaleoDefinitionId")) {
                this.alter(KaleoTaskInstanceTokenTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableDropColumn((UpgradeProcess)this, "kaleoDefinitionId")});
            }
            if (this.hasColumn("KaleoTimer", "kaleoDefinitionId")) {
                this.alter(KaleoTimerTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableDropColumn((UpgradeProcess)this, "kaleoDefinitionId")});
            }
            if (this.hasColumn("KaleoTimerInstanceToken", "kaleoDefinitionId")) {
                this.alter(KaleoTimerInstanceTokenTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableDropColumn((UpgradeProcess)this, "kaleoDefinitionId")});
            }
            if (this.hasColumn("KaleoTransition", "kaleoDefinitionId")) {
                this.alter(KaleoTransitionTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableDropColumn((UpgradeProcess)this, "kaleoDefinitionId")});
            }
        }
    }

    protected void removeStartKaleoNodeId() throws Exception {
        if (this.hasColumn("KaleoDefinition", "startKaleoNodeId")) {
            this.alter(KaleoDefinitionTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableDropColumn((UpgradeProcess)this, "startKaleoNodeId")});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void upgradeKaleoDefinitionVersion() throws Exception {
        StringBundler sb1 = new StringBundler(3);
        sb1.append("select * from KaleoDefinition kd where not exists ");
        sb1.append("(select 1 from KaleoDefinitionVersion kdv where kdv.name ");
        sb1.append("= kd.name and kdv.companyId = kd.companyId)");
        StringBundler sb2 = new StringBundler(6);
        sb2.append("insert into KaleoDefinitionVersion ");
        sb2.append("(kaleoDefinitionVersionId, groupId, companyId, userId, ");
        sb2.append("userName, statusByUserId, statusByUserName, statusDate, ");
        sb2.append("createDate, modifiedDate, name, title, description, ");
        sb2.append("content, version, startKaleoNodeId, status) values (?, ");
        sb2.append("?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )");
        ArrayList<PreparedStatement> preparedStatements = new ArrayList<PreparedStatement>(17);
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps1 = this.connection.prepareStatement(sb1.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)sb2.toString());
             ResultSet rs = ps1.executeQuery();){
            for (String tableName : _TABLE_NAMES) {
                if (!this.hasColumn(tableName, "kaleoDefinitionId")) continue;
                StringBundler sb3 = new StringBundler(4);
                sb3.append("update ");
                sb3.append(tableName);
                sb3.append(" set kaleoDefinitionVersionId = ? where ");
                sb3.append("kaleoDefinitionId = ? ");
                preparedStatements.add(AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)sb3.toString()));
            }
            while (rs.next()) {
                long kaleoDefinitionId = rs.getLong("kaleoDefinitionId");
                long groupId = rs.getLong("groupId");
                long companyId = rs.getLong("companyId");
                long userId = rs.getLong("userId");
                String userName = rs.getString("userName");
                Timestamp createDate = rs.getTimestamp("createDate");
                Timestamp modifiedDate = rs.getTimestamp("modifiedDate");
                String name = rs.getString("name");
                String title = rs.getString("title");
                String description = rs.getString("description");
                String content = rs.getString("content");
                int version = rs.getInt("version");
                long startKaleoNodeId = rs.getLong("startKaleoNodeId");
                long kaleoDefinitionVersionId = this.increment();
                ps2.setLong(1, kaleoDefinitionVersionId);
                ps2.setLong(2, groupId);
                ps2.setLong(3, companyId);
                ps2.setLong(4, userId);
                ps2.setString(5, userName);
                ps2.setLong(6, userId);
                ps2.setString(7, userName);
                ps2.setTimestamp(8, modifiedDate);
                ps2.setTimestamp(9, createDate);
                ps2.setTimestamp(10, modifiedDate);
                ps2.setString(11, name);
                ps2.setString(12, title);
                ps2.setString(13, description);
                ps2.setString(14, content);
                ps2.setString(15, this.getVersion(version));
                ps2.setLong(16, startKaleoNodeId);
                ps2.setInt(17, 0);
                ps2.addBatch();
                for (PreparedStatement preparedStatement : preparedStatements) {
                    this.addBatch(preparedStatement, kaleoDefinitionId, kaleoDefinitionVersionId);
                }
            }
            ps2.executeBatch();
            for (PreparedStatement preparedStatement : preparedStatements) {
                preparedStatement.executeBatch();
            }
        }
        finally {
            for (PreparedStatement preparedStatement : preparedStatements) {
                DataAccess.cleanUp((Statement)preparedStatement);
            }
        }
    }
}

