/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.upgrade.v1_3_0;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.runtime.util.WorkflowContextUtil;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;

public abstract class BaseUpgradeClassNames
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.updateClassName("KaleoInstance", "className");
        this.updateClassName("KaleoInstanceToken", "className");
        this.updateClassName("KaleoLog", "currentAssigneeClassName");
        this.updateClassName("KaleoLog", "previousAssigneeClassName");
        this.updateClassName("KaleoNotificationRecipient", "recipientClassName");
        this.updateClassName("KaleoTaskAssignment", "assigneeClassName");
        this.updateClassName("KaleoTaskAssignmentInstance", "assigneeClassName");
        this.updateClassName("KaleoTaskInstanceToken", "className");
        this.updateWorkflowContextEntryClassName("KaleoInstance", "kaleoInstanceId");
        this.updateWorkflowContextEntryClassName("KaleoLog", "kaleoLogId");
        this.updateWorkflowContextEntryClassName("KaleoTaskInstanceToken", "kaleoTaskInstanceTokenId");
        this.updateWorkflowContextEntryClassName("KaleoTimerInstanceToken", "kaleoTimerInstanceTokenId");
    }

    protected abstract void updateClassName(String var1, String var2);

    protected abstract Map<String, Serializable> updateWorkflowContext(String var1);

    protected void updateWorkflowContext(String tableName, String primaryKeyName, long primaryKeyValue, String workflowContext) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"update ", tableName, " set workflowContext = ? where ", primaryKeyName, " = ?"}));){
            ps.setString(1, workflowContext);
            ps.setLong(2, primaryKeyValue);
            ps.executeUpdate();
        }
    }

    protected void updateWorkflowContextEntryClassName(String tableName, String primaryKeyName) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer(tableName);
             PreparedStatement ps = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select ", primaryKeyName, ", workflowContext from ", tableName, " where workflowContext is not null"}));
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                Map<String, Serializable> workflowContext;
                long primaryKeyValue = rs.getLong(primaryKeyName);
                String workflowContextJSON = rs.getString("workflowContext");
                if (Validator.isNull((String)workflowContextJSON) || (workflowContext = this.updateWorkflowContext(workflowContextJSON)) == null) continue;
                this.updateWorkflowContext(tableName, primaryKeyName, primaryKeyValue, WorkflowContextUtil.convert(workflowContext));
            }
        }
    }
}

