/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.scripting.internal.condition;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.resource.ResourceRetriever;
import com.liferay.portal.kernel.resource.StringResourceRetriever;
import com.liferay.portal.rules.engine.Query;
import com.liferay.portal.rules.engine.RulesEngine;
import com.liferay.portal.rules.engine.RulesResourceRetriever;
import com.liferay.portal.workflow.kaleo.model.KaleoCondition;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.condition.ConditionEvaluator;
import com.liferay.portal.workflow.kaleo.runtime.util.RulesContextBuilder;
import com.liferay.portal.workflow.kaleo.runtime.util.WorkflowContextUtil;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"scripting.language=drl"}, service={ConditionEvaluator.class})
public class DRLConditionEvaluator
implements ConditionEvaluator {
    private static final String _RETURN_VALUE = "returnValue";
    @Reference
    private RulesContextBuilder _rulesContextBuilder;
    @Reference
    private RulesEngine _rulesEngine;

    public String evaluate(KaleoCondition kaleoCondition, ExecutionContext executionContext) throws PortalException {
        List facts = this._rulesContextBuilder.buildRulesContext(executionContext);
        RulesResourceRetriever rulesResourceRetriever = new RulesResourceRetriever((ResourceRetriever)new StringResourceRetriever(kaleoCondition.getScript()));
        Query query = Query.createStandardQuery();
        Map results = this._rulesEngine.execute(rulesResourceRetriever, facts, query);
        String returnValue = (String)results.get(_RETURN_VALUE);
        Map resultsWorkflowContext = (Map)results.get("workflowContext");
        WorkflowContextUtil.mergeWorkflowContexts((ExecutionContext)executionContext, (Map)resultsWorkflowContext);
        if (returnValue != null) {
            return returnValue;
        }
        throw new IllegalStateException("Conditional did not return value for script " + kaleoCondition.getScript());
    }
}

