/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.scripting.internal.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.workflow.kaleo.KaleoWorkflowModelConverter;
import com.liferay.portal.workflow.kaleo.model.KaleoInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoTask;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.util.ScriptingContextBuilder;
import com.liferay.portal.workflow.kaleo.runtime.util.WorkflowContextUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ScriptingContextBuilder.class})
public class ScriptingContextBuilderImpl
implements ScriptingContextBuilder {
    @Reference
    private KaleoWorkflowModelConverter _kaleoWorkflowModelConverter;

    public Map<String, Object> buildScriptingContext(ExecutionContext executionContext) throws PortalException {
        Map workflowContext = executionContext.getWorkflowContext();
        if (workflowContext == null) {
            KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
            KaleoInstance kaleoInstance = kaleoInstanceToken.getKaleoInstance();
            workflowContext = WorkflowContextUtil.convert((String)kaleoInstance.getWorkflowContext());
        }
        HashMap<String, Object> inputObjects = new HashMap<String, Object>();
        inputObjects.putAll(workflowContext);
        inputObjects.put("kaleoInstanceToken", executionContext.getKaleoInstanceToken());
        inputObjects.put("workflowContext", workflowContext);
        KaleoTaskInstanceToken kaleoTaskInstanceToken = executionContext.getKaleoTaskInstanceToken();
        if (kaleoTaskInstanceToken != null) {
            inputObjects.put("kaleoTaskInstanceToken", kaleoTaskInstanceToken);
            KaleoTask kaleoTask = kaleoTaskInstanceToken.getKaleoTask();
            inputObjects.put("taskName", kaleoTask.getName());
            if (kaleoTaskInstanceToken.getCompletionUserId() != 0L) {
                inputObjects.put("userId", kaleoTaskInstanceToken.getCompletionUserId());
            } else {
                inputObjects.put("userId", kaleoTaskInstanceToken.getUserId());
            }
            List workflowTaskAssignees = this._kaleoWorkflowModelConverter.getWorkflowTaskAssignees(kaleoTaskInstanceToken);
            inputObjects.put("workflowTaskAssignees", workflowTaskAssignees);
        } else {
            KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
            inputObjects.put("userId", kaleoInstanceToken.getUserId());
        }
        if (executionContext.getKaleoTimerInstanceToken() != null) {
            inputObjects.put("kaleoTimerInstanceToken", executionContext.getKaleoTimerInstanceToken());
        }
        return inputObjects;
    }
}

