/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.integration.internal.security.permission.resource;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.workflow.configuration.WorkflowDefinitionConfiguration;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.portal.workflow.configuration.WorkflowDefinitionConfiguration"}, property={"resource.name=com.liferay.portal.workflow"}, service={PortletResourcePermission.class})
public class WorkflowPortletResourcePermission
implements PortletResourcePermission {
    private volatile boolean _companyAdministratorCanPublish;

    public void check(PermissionChecker permissionChecker, Group group, String actionId) throws PrincipalException {
        this.check(permissionChecker, group.getGroupId(), actionId);
    }

    public void check(PermissionChecker permissionChecker, long groupId, String actionId) throws PrincipalException {
        if (!this.contains(permissionChecker, groupId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, new String[]{"com.liferay.portal.workflow", actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, Group group, String actionId) {
        return this.contains(permissionChecker, group.getGroupId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long groupId, String actionId) {
        return permissionChecker.isOmniadmin() || this._companyAdministratorCanPublish && permissionChecker.isCompanyAdmin();
    }

    public String getResourceName() {
        return "com.liferay.portal.workflow";
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        WorkflowDefinitionConfiguration workflowDefinitionConfiguration = (WorkflowDefinitionConfiguration)ConfigurableUtil.createConfigurable(WorkflowDefinitionConfiguration.class, properties);
        this._companyAdministratorCanPublish = workflowDefinitionConfiguration.companyAdministratorCanPublish();
    }
}

