/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.integration.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lock.DuplicateLockException;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.lock.LockManager;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupGroupRole;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserGroupGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.kernel.workflow.WorkflowTask;
import com.liferay.portal.kernel.workflow.WorkflowTaskManager;
import com.liferay.portal.workflow.kaleo.KaleoWorkflowModelConverter;
import com.liferay.portal.workflow.kaleo.model.KaleoInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.model.KaleoTask;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignment;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoTransition;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.KaleoSignaler;
import com.liferay.portal.workflow.kaleo.runtime.TaskManager;
import com.liferay.portal.workflow.kaleo.runtime.assignment.TaskAssignmentSelector;
import com.liferay.portal.workflow.kaleo.runtime.assignment.TaskAssignmentSelectorRegistry;
import com.liferay.portal.workflow.kaleo.runtime.util.WorkflowContextUtil;
import com.liferay.portal.workflow.kaleo.runtime.util.comparator.KaleoTaskInstanceTokenOrderByComparator;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskAssignmentLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskInstanceTokenLocalService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"proxy.bean=false"}, service={WorkflowTaskManager.class})
public class WorkflowTaskManagerImpl
implements WorkflowTaskManager {
    @Reference
    protected LockManager lockManager;
    @Reference
    private KaleoSignaler _kaleoSignaler;
    @Reference
    private KaleoTaskAssignmentLocalService _kaleoTaskAssignmentLocalService;
    @Reference
    private KaleoTaskInstanceTokenLocalService _kaleoTaskInstanceTokenLocalService;
    @Reference
    private KaleoWorkflowModelConverter _kaleoWorkflowModelConverter;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private TaskAssignmentSelectorRegistry _taskAssignmentSelectorRegistry;
    @Reference
    private TaskManager _taskManager;
    @Reference
    private UserGroupGroupRoleLocalService _userGroupGroupRoleLocalService;
    @Reference
    private UserGroupRoleLocalService _userGroupRoleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public WorkflowTask assignWorkflowTaskToRole(long companyId, long userId, long workflowTaskInstanceId, long roleId, String comment, Date dueDate, Map<String, Serializable> workflowContext) throws WorkflowException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(companyId);
        serviceContext.setUserId(userId);
        return this._taskManager.assignWorkflowTaskToRole(workflowTaskInstanceId, roleId, comment, dueDate, workflowContext, serviceContext);
    }

    public WorkflowTask assignWorkflowTaskToUser(long companyId, long userId, long workflowTaskInstanceId, long assigneeUserId, String comment, Date dueDate, Map<String, Serializable> workflowContext) throws WorkflowException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(companyId);
        serviceContext.setUserId(userId);
        return this._taskManager.assignWorkflowTaskToUser(workflowTaskInstanceId, assigneeUserId, comment, dueDate, workflowContext, serviceContext);
    }

    public WorkflowTask completeWorkflowTask(long companyId, long userId, long workflowTaskInstanceId, String transitionName, String comment, Map<String, Serializable> workflowContext) throws WorkflowException {
        Lock lock = null;
        try {
            lock = this.lockManager.lock(userId, WorkflowTask.class.getName(), workflowTaskInstanceId, String.valueOf(userId), false, 1000L);
        }
        catch (PortalException portalException) {
            if (portalException instanceof DuplicateLockException) {
                throw new WorkflowException(StringBundler.concat((Object[])new Object[]{"Workflow task ", workflowTaskInstanceId, " is locked by user ", userId}), (Throwable)portalException);
            }
            throw new WorkflowException("Unable to lock workflow task " + workflowTaskInstanceId, (Throwable)portalException);
        }
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setUserId(userId);
            WorkflowTask workflowTask = this._taskManager.completeWorkflowTask(workflowTaskInstanceId, transitionName, comment, workflowContext, serviceContext);
            KaleoTaskInstanceToken kaleoTaskInstanceToken = this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceToken(workflowTask.getWorkflowTaskId());
            KaleoInstanceToken kaleoInstanceToken = kaleoTaskInstanceToken.getKaleoInstanceToken();
            if (workflowContext == null) {
                KaleoInstance kaleoInstance = kaleoInstanceToken.getKaleoInstance();
                workflowContext = WorkflowContextUtil.convert((String)kaleoInstance.getWorkflowContext());
            }
            workflowContext.put((String)"taskComments", (Serializable)((Object)comment));
            workflowContext.put("transitionName", transitionName);
            ExecutionContext executionContext = new ExecutionContext(kaleoInstanceToken, kaleoTaskInstanceToken, workflowContext, serviceContext);
            this._kaleoSignaler.signalExit(transitionName, executionContext);
            WorkflowTask workflowTask2 = workflowTask;
            return workflowTask2;
        }
        catch (Exception exception) {
            throw new WorkflowException("Unable to complete task", (Throwable)exception);
        }
        finally {
            this.lockManager.unlock(lock.getClassName(), lock.getKey());
        }
    }

    public WorkflowTask fetchWorkflowTask(long companyId, long workflowTaskInstanceId) throws WorkflowException {
        KaleoTaskInstanceToken kaleoTaskInstanceToken = this._kaleoTaskInstanceTokenLocalService.fetchKaleoTaskInstanceToken(workflowTaskInstanceId);
        if (kaleoTaskInstanceToken == null) {
            return null;
        }
        try {
            return this._kaleoWorkflowModelConverter.toWorkflowTask(kaleoTaskInstanceToken, WorkflowContextUtil.convert((String)kaleoTaskInstanceToken.getWorkflowContext()));
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<String> getNextTransitionNames(long companyId, long userId, long workflowTaskInstanceId) throws WorkflowException {
        try {
            KaleoTaskInstanceToken kaleoTaskInstanceToken = this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceToken(workflowTaskInstanceId);
            if (kaleoTaskInstanceToken.isCompleted()) {
                return Collections.emptyList();
            }
            KaleoTask kaleoTask = kaleoTaskInstanceToken.getKaleoTask();
            KaleoNode kaleoNode = kaleoTask.getKaleoNode();
            List kaleoTransitions = kaleoNode.getKaleoTransitions();
            ArrayList<String> transitionNames = new ArrayList<String>(kaleoTransitions.size());
            for (KaleoTransition kaleoTransition : kaleoTransitions) {
                transitionNames.add(kaleoTransition.getName());
            }
            return transitionNames;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public long[] getPooledActorsIds(long companyId, long workflowTaskInstanceId) throws WorkflowException {
        try {
            KaleoTaskInstanceToken kaleoTaskInstanceToken = this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceToken(workflowTaskInstanceId);
            List<KaleoTaskAssignment> calculatedKaleoTaskAssignments = this.getCalculatedKaleoTaskAssignments(kaleoTaskInstanceToken);
            HashSet<User> users = new HashSet<User>();
            for (KaleoTaskAssignment calculatedKaleoTaskAssignment : calculatedKaleoTaskAssignments) {
                this.populateUsers(calculatedKaleoTaskAssignment, kaleoTaskInstanceToken, users);
            }
            TreeMap<String, Long> pooledActors = new TreeMap<String, Long>((Comparator<String>)new NaturalOrderStringComparator());
            for (User user : users) {
                pooledActors.put(user.getScreenName(), user.getUserId());
            }
            return ArrayUtil.toLongArray(pooledActors.values());
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public WorkflowTask getWorkflowTask(long companyId, long workflowTaskInstanceId) throws WorkflowException {
        try {
            KaleoTaskInstanceToken kaleoTaskInstanceToken = this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceToken(workflowTaskInstanceId);
            return this._kaleoWorkflowModelConverter.toWorkflowTask(kaleoTaskInstanceToken, WorkflowContextUtil.convert((String)kaleoTaskInstanceToken.getWorkflowContext()));
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public int getWorkflowTaskCount(long companyId, Boolean completed) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            return this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceTokensCount(completed, serviceContext);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public int getWorkflowTaskCountByRole(long companyId, long roleId, Boolean completed) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            return this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceTokensCount(Role.class.getName(), roleId, completed, serviceContext);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public int getWorkflowTaskCountBySubmittingUser(long companyId, long userId, Boolean completed) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            return this._kaleoTaskInstanceTokenLocalService.getSubmittingUserKaleoTaskInstanceTokensCount(userId, completed, serviceContext);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public int getWorkflowTaskCountByUser(long companyId, long userId, Boolean completed) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setUserId(userId);
            return this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceTokensCount(User.class.getName(), serviceContext.getUserId(), completed, serviceContext);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public int getWorkflowTaskCountByUserRoles(long companyId, long userId, Boolean completed) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setUserId(userId);
            return this._kaleoTaskInstanceTokenLocalService.searchCount(null, completed, Boolean.TRUE, serviceContext);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public int getWorkflowTaskCountByUserRoles(long companyId, long userId, long workflowInstanceId, Boolean completed) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setUserId(userId);
            return this._kaleoTaskInstanceTokenLocalService.searchCount(workflowInstanceId, completed, Boolean.TRUE, serviceContext);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public int getWorkflowTaskCountByWorkflowInstance(long companyId, Long userId, long workflowInstanceId, Boolean completed) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            if (userId != null) {
                serviceContext.setUserId(userId.longValue());
            }
            return this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceTokensCount(workflowInstanceId, completed, serviceContext);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<WorkflowTask> getWorkflowTasks(long companyId, Boolean completed, int start, int end, OrderByComparator<WorkflowTask> orderByComparator) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            List kaleoTaskInstanceTokens = this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceTokens(completed, start, end, KaleoTaskInstanceTokenOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter), serviceContext);
            return this.toWorkflowTasks(kaleoTaskInstanceTokens);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<WorkflowTask> getWorkflowTasksByRole(long companyId, long roleId, Boolean completed, int start, int end, OrderByComparator<WorkflowTask> orderByComparator) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            List kaleoTaskInstanceTokens = this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceTokens(Role.class.getName(), roleId, completed, start, end, KaleoTaskInstanceTokenOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter), serviceContext);
            return this.toWorkflowTasks(kaleoTaskInstanceTokens);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<WorkflowTask> getWorkflowTasksBySubmittingUser(long companyId, long userId, Boolean completed, int start, int end, OrderByComparator<WorkflowTask> orderByComparator) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            List kaleoTaskInstanceTokens = this._kaleoTaskInstanceTokenLocalService.getSubmittingUserKaleoTaskInstanceTokens(userId, completed, start, end, KaleoTaskInstanceTokenOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter), serviceContext);
            return this.toWorkflowTasks(kaleoTaskInstanceTokens);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<WorkflowTask> getWorkflowTasksByUser(long companyId, long userId, Boolean completed, int start, int end, OrderByComparator<WorkflowTask> orderByComparator) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            List kaleoTaskInstanceTokens = this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceTokens(User.class.getName(), userId, completed, start, end, KaleoTaskInstanceTokenOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter), serviceContext);
            return this.toWorkflowTasks(kaleoTaskInstanceTokens);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<WorkflowTask> getWorkflowTasksByUserRoles(long companyId, long userId, Boolean completed, int start, int end, OrderByComparator<WorkflowTask> orderByComparator) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setUserId(userId);
            List kaleoTaskInstanceTokens = this._kaleoTaskInstanceTokenLocalService.search(null, completed, Boolean.TRUE, start, end, KaleoTaskInstanceTokenOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter), serviceContext);
            return this.toWorkflowTasks(kaleoTaskInstanceTokens);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<WorkflowTask> getWorkflowTasksByWorkflowInstance(long companyId, Long userId, long workflowInstanceId, Boolean completed, int start, int end, OrderByComparator<WorkflowTask> orderByComparator) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            if (userId != null) {
                serviceContext.setUserId(userId.longValue());
            }
            List kaleoTaskInstanceTokens = this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceTokens(workflowInstanceId, completed, start, end, KaleoTaskInstanceTokenOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter), serviceContext);
            return this.toWorkflowTasks(kaleoTaskInstanceTokens);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public boolean hasOtherAssignees(long workflowTaskInstanceId, long userId) throws WorkflowException {
        try {
            KaleoTaskInstanceToken kaleoTaskInstanceToken = this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceToken(workflowTaskInstanceId);
            ExecutionContext executionContext = this.createExecutionContext(kaleoTaskInstanceToken);
            List configuredKaleoTaskAssignments = this._kaleoTaskAssignmentLocalService.getKaleoTaskAssignments(kaleoTaskInstanceToken.getKaleoTaskId());
            for (KaleoTaskAssignment configuredKaleoTaskAssignment : configuredKaleoTaskAssignments) {
                Collection<KaleoTaskAssignment> calculatedKaleoTaskAssignments = this.getKaleoTaskAssignments(configuredKaleoTaskAssignment, executionContext);
                for (KaleoTaskAssignment calculatedKaleoTaskAssignment : calculatedKaleoTaskAssignments) {
                    if (!this.hasOtherPooledActors(calculatedKaleoTaskAssignment, kaleoTaskInstanceToken, userId)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<WorkflowTask> search(long companyId, long userId, String keywords, Boolean completed, Boolean searchByUserRoles, int start, int end, OrderByComparator<WorkflowTask> orderByComparator) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setUserId(userId);
            List kaleoTaskInstanceTokens = this._kaleoTaskInstanceTokenLocalService.search(keywords, completed, searchByUserRoles, start, end, KaleoTaskInstanceTokenOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter), serviceContext);
            return this.toWorkflowTasks(kaleoTaskInstanceTokens);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<WorkflowTask> search(long companyId, long userId, String taskName, String assetType, Long[] assetPrimaryKey, Date dueDateGT, Date dueDateLT, Boolean completed, Boolean searchByUserRoles, boolean andOperator, int start, int end, OrderByComparator<WorkflowTask> orderByComparator) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setUserId(userId);
            List kaleoTaskInstanceTokens = this._kaleoTaskInstanceTokenLocalService.search(taskName, assetType, assetPrimaryKey, dueDateGT, dueDateLT, completed, searchByUserRoles, andOperator, start, end, KaleoTaskInstanceTokenOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter), serviceContext);
            return this.toWorkflowTasks(kaleoTaskInstanceTokens);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<WorkflowTask> search(long companyId, long userId, String keywords, String[] assetTypes, Boolean completed, Boolean searchByUserRoles, int start, int end, OrderByComparator<WorkflowTask> orderByComparator) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setUserId(userId);
            List kaleoTaskInstanceTokens = this._kaleoTaskInstanceTokenLocalService.search(keywords, assetTypes, completed, searchByUserRoles, start, end, KaleoTaskInstanceTokenOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter), serviceContext);
            return this.toWorkflowTasks(kaleoTaskInstanceTokens);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public int searchCount(long companyId, long userId, String keywords, Boolean completed, Boolean searchByUserRoles) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setUserId(userId);
            return this._kaleoTaskInstanceTokenLocalService.searchCount(keywords, completed, searchByUserRoles, serviceContext);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public int searchCount(long companyId, long userId, String taskName, String assetType, Long[] assetPrimaryKey, Date dueDateGT, Date dueDateLT, Boolean completed, Boolean searchByUserRoles, boolean andOperator) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setUserId(userId);
            return this._kaleoTaskInstanceTokenLocalService.searchCount(taskName, assetType, assetPrimaryKey, dueDateGT, dueDateLT, completed, searchByUserRoles, andOperator, serviceContext);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public int searchCount(long companyId, long userId, String keywords, String[] assetTypes, Boolean completed, Boolean searchByUserRoles) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setUserId(userId);
            return this._kaleoTaskInstanceTokenLocalService.searchCount(keywords, assetTypes, completed, searchByUserRoles, serviceContext);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public WorkflowTask updateDueDate(long companyId, long userId, long workflowTaskInstanceId, String comment, Date dueDate) throws WorkflowException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(companyId);
        serviceContext.setUserId(userId);
        return this._taskManager.updateDueDate(workflowTaskInstanceId, comment, dueDate, serviceContext);
    }

    protected ExecutionContext createExecutionContext(KaleoTaskInstanceToken kaleoTaskInstanceToken) throws PortalException {
        KaleoInstanceToken kaleoInstanceToken = kaleoTaskInstanceToken.getKaleoInstanceToken();
        Map workflowContext = WorkflowContextUtil.convert((String)kaleoTaskInstanceToken.getWorkflowContext());
        ServiceContext workflowContextServiceContext = (ServiceContext)workflowContext.get("serviceContext");
        return new ExecutionContext(kaleoInstanceToken, workflowContext, workflowContextServiceContext);
    }

    protected List<KaleoTaskAssignment> getCalculatedKaleoTaskAssignments(KaleoTaskInstanceToken kaleoTaskInstanceToken) throws PortalException {
        ArrayList<KaleoTaskAssignment> calculatedKaleoTaskAssignments = new ArrayList<KaleoTaskAssignment>();
        ExecutionContext executionContext = this.createExecutionContext(kaleoTaskInstanceToken);
        List configuredKaleoTaskAssignments = this._kaleoTaskAssignmentLocalService.getKaleoTaskAssignments(kaleoTaskInstanceToken.getKaleoTaskId());
        for (KaleoTaskAssignment configuredKaleoTaskAssignment : configuredKaleoTaskAssignments) {
            calculatedKaleoTaskAssignments.addAll(this.getKaleoTaskAssignments(configuredKaleoTaskAssignment, executionContext));
        }
        return calculatedKaleoTaskAssignments;
    }

    protected Collection<KaleoTaskAssignment> getKaleoTaskAssignments(KaleoTaskAssignment kaleoTaskAssignment, ExecutionContext executionContext) throws PortalException {
        TaskAssignmentSelector taskAssignmentSelector = this._taskAssignmentSelectorRegistry.getTaskAssignmentSelector(kaleoTaskAssignment.getAssigneeClassName());
        return taskAssignmentSelector.calculateTaskAssignments(kaleoTaskAssignment, executionContext);
    }

    protected boolean hasOtherPooledActors(KaleoTaskAssignment kaleoTaskAssignment, KaleoTaskInstanceToken kaleoTaskInstanceToken, long userId) throws PortalException {
        String assigneeClassName = kaleoTaskAssignment.getAssigneeClassName();
        long assigneeClassPK = kaleoTaskAssignment.getAssigneeClassPK();
        if (assigneeClassName.equals(User.class.getName())) {
            if (userId == assigneeClassPK) {
                return false;
            }
            User user = this._userLocalService.fetchUser(assigneeClassPK);
            return user != null && user.isActive();
        }
        Role role = this._roleLocalService.getRole(assigneeClassPK);
        if (role.getType() == 2 || role.getType() == 3) {
            if (Objects.equals(role.getName(), "Site Member")) {
                long[] userGroupUserIds = this._userLocalService.getGroupUserIds(kaleoTaskInstanceToken.getGroupId());
                return ArrayUtil.contains((long[])userGroupUserIds, (long)userId);
            }
            List userGroupRoles = this._userGroupRoleLocalService.getUserGroupRolesByGroupAndRole(kaleoTaskInstanceToken.getGroupId(), assigneeClassPK);
            for (Object userGroupRole : userGroupRoles) {
                User user = userGroupRole.getUser();
                if (user == null || !user.isActive() || user.getUserId() == userId) continue;
                return true;
            }
            List userGroupGroupRoles = this._userGroupGroupRoleLocalService.getUserGroupGroupRolesByGroupAndRole(kaleoTaskInstanceToken.getGroupId(), assigneeClassPK);
            for (UserGroupGroupRole userGroupGroupRole : userGroupGroupRoles) {
                List userGroupUsers = this._userLocalService.getUserGroupUsers(userGroupGroupRole.getUserGroupId());
                for (User user : userGroupUsers) {
                    if (!user.isActive() || user.getUserId() == userId) continue;
                    return true;
                }
            }
        } else {
            List inheritedRoleUsers = this._userLocalService.getInheritedRoleUsers(assigneeClassPK, -1, -1, null);
            for (User user : inheritedRoleUsers) {
                if (!user.isActive() || user.getUserId() == userId) continue;
                return true;
            }
        }
        return false;
    }

    protected void populateUsers(KaleoTaskAssignment kaleoTaskAssignment, KaleoTaskInstanceToken kaleoTaskInstanceToken, Set<User> users) throws PortalException {
        String assigneeClassName = kaleoTaskAssignment.getAssigneeClassName();
        long assigneeClassPK = kaleoTaskAssignment.getAssigneeClassPK();
        if (assigneeClassName.equals(User.class.getName())) {
            User user = this._userLocalService.fetchUser(assigneeClassPK);
            if (user != null && user.isActive()) {
                users.add(user);
            }
            return;
        }
        Role role = this._roleLocalService.getRole(assigneeClassPK);
        if (role.getType() == 2 || role.getType() == 3) {
            if (Objects.equals(role.getName(), "Site Member")) {
                List userGroupUsers = this._userLocalService.getGroupUsers(kaleoTaskInstanceToken.getGroupId());
                for (User user : userGroupUsers) {
                    if (!user.isActive()) continue;
                    users.add(user);
                }
                return;
            }
            List userGroupRoles = this._userGroupRoleLocalService.getUserGroupRolesByGroupAndRole(kaleoTaskInstanceToken.getGroupId(), assigneeClassPK);
            for (Object userGroupRole : userGroupRoles) {
                User user = userGroupRole.getUser();
                if (!user.isActive()) continue;
                users.add(user);
            }
            List userGroupGroupRoles = this._userGroupGroupRoleLocalService.getUserGroupGroupRolesByGroupAndRole(kaleoTaskInstanceToken.getGroupId(), assigneeClassPK);
            for (UserGroupGroupRole userGroupGroupRole : userGroupGroupRoles) {
                List userGroupUsers = this._userLocalService.getUserGroupUsers(userGroupGroupRole.getUserGroupId());
                for (User user : userGroupUsers) {
                    if (!user.isActive()) continue;
                    users.add(user);
                }
            }
        } else {
            List inheritedRoleUsers = this._userLocalService.getInheritedRoleUsers(assigneeClassPK, -1, -1, null);
            for (User user : inheritedRoleUsers) {
                if (!user.isActive()) continue;
                users.add(user);
            }
        }
    }

    protected List<WorkflowTask> toWorkflowTasks(List<KaleoTaskInstanceToken> kaleoTaskInstanceTokens) throws PortalException {
        ArrayList<WorkflowTask> workflowTasks = new ArrayList<WorkflowTask>(kaleoTaskInstanceTokens.size());
        for (KaleoTaskInstanceToken kaleoTaskInstanceToken : kaleoTaskInstanceTokens) {
            WorkflowTask workflowTask = this._kaleoWorkflowModelConverter.toWorkflowTask(kaleoTaskInstanceToken, WorkflowContextUtil.convert((String)kaleoTaskInstanceToken.getWorkflowContext()));
            workflowTasks.add(workflowTask);
        }
        return workflowTasks;
    }
}

