/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.integration.impl.internal;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.DefaultWorkflowDefinition;
import com.liferay.portal.kernel.workflow.DefaultWorkflowInstance;
import com.liferay.portal.kernel.workflow.DefaultWorkflowLog;
import com.liferay.portal.kernel.workflow.DefaultWorkflowTask;
import com.liferay.portal.kernel.workflow.WorkflowDefinition;
import com.liferay.portal.kernel.workflow.WorkflowInstance;
import com.liferay.portal.kernel.workflow.WorkflowLog;
import com.liferay.portal.kernel.workflow.WorkflowTask;
import com.liferay.portal.kernel.workflow.WorkflowTaskAssignee;
import com.liferay.portal.workflow.kaleo.KaleoWorkflowModelConverter;
import com.liferay.portal.workflow.kaleo.definition.export.DefinitionExporter;
import com.liferay.portal.workflow.kaleo.definition.util.KaleoLogUtil;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinition;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinitionVersion;
import com.liferay.portal.workflow.kaleo.model.KaleoInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoLog;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.model.KaleoTask;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.runtime.integration.impl.internal.util.LazyWorkflowTaskAssigneeList;
import com.liferay.portal.workflow.kaleo.runtime.integration.impl.internal.util.WorkflowTaskAssigneesSupplier;
import com.liferay.portal.workflow.kaleo.runtime.util.WorkflowContextUtil;
import com.liferay.portal.workflow.kaleo.service.KaleoDefinitionLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoDefinitionVersionLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskAssignmentInstanceLocalService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={KaleoWorkflowModelConverter.class})
public class KaleoWorkflowModelConverterImpl
implements KaleoWorkflowModelConverter {
    private static final Log _log = LogFactoryUtil.getLog(KaleoWorkflowModelConverterImpl.class);
    @Reference
    private DefinitionExporter _definitionExporter;
    @Reference
    private KaleoDefinitionLocalService _kaleoDefinitionLocalService;
    @Reference
    private KaleoDefinitionVersionLocalService _kaleoDefinitionVersionLocalService;
    @Reference
    private KaleoTaskAssignmentInstanceLocalService _kaleoTaskAssignmentInstanceLocalService;

    public List<WorkflowTaskAssignee> getWorkflowTaskAssignees(KaleoTaskInstanceToken kaleoTaskInstanceToken) {
        WorkflowTaskAssigneesSupplier workflowTaskAssigneesSupplier = new WorkflowTaskAssigneesSupplier(kaleoTaskInstanceToken);
        return workflowTaskAssigneesSupplier.get();
    }

    public WorkflowDefinition toWorkflowDefinition(KaleoDefinition kaleoDefinition) {
        String content;
        DefaultWorkflowDefinition defaultWorkflowDefinition;
        block3: {
            defaultWorkflowDefinition = new DefaultWorkflowDefinition();
            defaultWorkflowDefinition.setActive(kaleoDefinition.isActive());
            content = kaleoDefinition.getContent();
            if (Validator.isNull((String)content)) {
                try {
                    content = this._definitionExporter.export(kaleoDefinition.getKaleoDefinitionId());
                    kaleoDefinition.setContent(content);
                    this._kaleoDefinitionLocalService.updateKaleoDefinition(kaleoDefinition);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Object)"Unable to export definition to string", (Throwable)e);
                }
            }
        }
        defaultWorkflowDefinition.setContent(content);
        defaultWorkflowDefinition.setDescription(kaleoDefinition.getDescription());
        defaultWorkflowDefinition.setModifiedDate(kaleoDefinition.getModifiedDate());
        defaultWorkflowDefinition.setName(kaleoDefinition.getName());
        defaultWorkflowDefinition.setTitle(kaleoDefinition.getTitle());
        defaultWorkflowDefinition.setUserId(kaleoDefinition.getUserId());
        defaultWorkflowDefinition.setVersion(kaleoDefinition.getVersion());
        return defaultWorkflowDefinition;
    }

    public WorkflowDefinition toWorkflowDefinition(KaleoDefinitionVersion kaleoDefinitionVersion) throws PortalException {
        String content;
        DefaultWorkflowDefinition defaultWorkflowDefinition;
        block5: {
            defaultWorkflowDefinition = new DefaultWorkflowDefinition();
            try {
                KaleoDefinition kaleoDefinition = kaleoDefinitionVersion.getKaleoDefinition();
                defaultWorkflowDefinition.setActive(kaleoDefinition.isActive());
            }
            catch (Exception e) {
                defaultWorkflowDefinition.setActive(false);
            }
            content = kaleoDefinitionVersion.getContent();
            if (Validator.isNull((String)content)) {
                try {
                    content = this._definitionExporter.export(kaleoDefinitionVersion.getKaleoDefinitionVersionId());
                    kaleoDefinitionVersion.setContent(content);
                    this._kaleoDefinitionVersionLocalService.updateKaleoDefinitionVersion(kaleoDefinitionVersion);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block5;
                    _log.warn((Object)"Unable to export definition to string", (Throwable)e);
                }
            }
        }
        defaultWorkflowDefinition.setContent(content);
        defaultWorkflowDefinition.setDescription(kaleoDefinitionVersion.getDescription());
        defaultWorkflowDefinition.setModifiedDate(kaleoDefinitionVersion.getModifiedDate());
        defaultWorkflowDefinition.setName(kaleoDefinitionVersion.getName());
        defaultWorkflowDefinition.setTitle(kaleoDefinitionVersion.getTitle());
        defaultWorkflowDefinition.setUserId(kaleoDefinitionVersion.getUserId());
        defaultWorkflowDefinition.setVersion(this.getVersion(kaleoDefinitionVersion.getVersion()));
        return defaultWorkflowDefinition;
    }

    public WorkflowInstance toWorkflowInstance(KaleoInstance kaleoInstance, KaleoInstanceToken kaleoInstanceToken) throws PortalException {
        return this.toWorkflowInstance(kaleoInstance, kaleoInstanceToken, null);
    }

    public WorkflowInstance toWorkflowInstance(KaleoInstance kaleoInstance, KaleoInstanceToken kaleoInstanceToken, Map<String, Serializable> workflowContext) throws PortalException {
        DefaultWorkflowInstance defaultWorkflowInstance = new DefaultWorkflowInstance();
        defaultWorkflowInstance.setEndDate(kaleoInstance.getCompletionDate());
        defaultWorkflowInstance.setStartDate(kaleoInstance.getCreateDate());
        KaleoNode currentKaleoNode = kaleoInstanceToken.getCurrentKaleoNode();
        defaultWorkflowInstance.setState(currentKaleoNode.getName());
        if (workflowContext != null) {
            defaultWorkflowInstance.setWorkflowContext(workflowContext);
        } else {
            defaultWorkflowInstance.setWorkflowContext(WorkflowContextUtil.convert((String)kaleoInstance.getWorkflowContext()));
        }
        defaultWorkflowInstance.setWorkflowDefinitionName(kaleoInstance.getKaleoDefinitionName());
        defaultWorkflowInstance.setWorkflowDefinitionVersion(kaleoInstance.getKaleoDefinitionVersion());
        defaultWorkflowInstance.setWorkflowInstanceId(kaleoInstance.getKaleoInstanceId());
        return defaultWorkflowInstance;
    }

    public WorkflowLog toWorkflowLog(KaleoLog kaleoLog) {
        long currentAssigneeClassPK;
        DefaultWorkflowLog defaultWorkflowLog = new DefaultWorkflowLog();
        defaultWorkflowLog.setAuditUserId(kaleoLog.getUserId());
        defaultWorkflowLog.setComment(kaleoLog.getComment());
        defaultWorkflowLog.setCreateDate(kaleoLog.getCreateDate());
        defaultWorkflowLog.setPreviousState(kaleoLog.getPreviousKaleoNodeName());
        long previousAssigneeClassPK = kaleoLog.getPreviousAssigneeClassPK();
        if (previousAssigneeClassPK > 0L) {
            String previousAssigneeClassName = kaleoLog.getPreviousAssigneeClassName();
            if (previousAssigneeClassName.equals(Role.class.getName())) {
                defaultWorkflowLog.setPreviousRoleId(previousAssigneeClassPK);
            } else {
                defaultWorkflowLog.setPreviousUserId(previousAssigneeClassPK);
            }
        }
        if ((currentAssigneeClassPK = kaleoLog.getCurrentAssigneeClassPK()) > 0L) {
            String currentAssigneeClassName = kaleoLog.getCurrentAssigneeClassName();
            if (currentAssigneeClassName.equals(Role.class.getName())) {
                defaultWorkflowLog.setRoleId(currentAssigneeClassPK);
            } else {
                defaultWorkflowLog.setUserId(currentAssigneeClassPK);
            }
        }
        defaultWorkflowLog.setState(kaleoLog.getKaleoNodeName());
        defaultWorkflowLog.setType(KaleoLogUtil.convert((String)kaleoLog.getType()));
        defaultWorkflowLog.setWorkflowLogId(kaleoLog.getKaleoLogId());
        defaultWorkflowLog.setWorkflowTaskId(kaleoLog.getKaleoTaskInstanceTokenId());
        return defaultWorkflowLog;
    }

    public WorkflowTask toWorkflowTask(KaleoTaskInstanceToken kaleoTaskInstanceToken, Map<String, Serializable> workflowContext) throws PortalException {
        DefaultWorkflowTask defaultWorkflowTask = new DefaultWorkflowTask();
        defaultWorkflowTask.setCreateDate(kaleoTaskInstanceToken.getCreateDate());
        defaultWorkflowTask.setCompletionDate(kaleoTaskInstanceToken.getCompletionDate());
        KaleoTask kaleoTask = kaleoTaskInstanceToken.getKaleoTask();
        defaultWorkflowTask.setDescription(kaleoTask.getDescription());
        defaultWorkflowTask.setDueDate(kaleoTaskInstanceToken.getDueDate());
        defaultWorkflowTask.setName(kaleoTask.getName());
        if (workflowContext != null) {
            defaultWorkflowTask.setOptionalAttributes(workflowContext);
        } else {
            defaultWorkflowTask.setOptionalAttributes(WorkflowContextUtil.convert((String)kaleoTaskInstanceToken.getWorkflowContext()));
        }
        KaleoInstanceToken kaleoInstanceToken = kaleoTaskInstanceToken.getKaleoInstanceToken();
        KaleoInstance kaleoInstance = kaleoInstanceToken.getKaleoInstance();
        defaultWorkflowTask.setWorkflowDefinitionId(kaleoInstance.getKaleoDefinitionVersionId());
        defaultWorkflowTask.setWorkflowDefinitionName(kaleoInstance.getKaleoDefinitionName());
        defaultWorkflowTask.setWorkflowDefinitionVersion(kaleoInstance.getKaleoDefinitionVersion());
        defaultWorkflowTask.setWorkflowInstanceId(kaleoInstance.getKaleoInstanceId());
        LazyWorkflowTaskAssigneeList workflowTaskAssignees = new LazyWorkflowTaskAssigneeList(kaleoTaskInstanceToken, this._kaleoTaskAssignmentInstanceLocalService);
        defaultWorkflowTask.setWorkflowTaskAssignees((Collection)workflowTaskAssignees);
        defaultWorkflowTask.setWorkflowTaskId(kaleoTaskInstanceToken.getKaleoTaskInstanceTokenId());
        return defaultWorkflowTask;
    }

    protected int getVersion(String version) {
        int[] versionParts = StringUtil.split((String)version, (String)".", (int)0);
        return versionParts[0];
    }
}

