/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.node;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.model.KaleoTransition;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.graph.PathElement;
import com.liferay.portal.workflow.kaleo.runtime.node.BaseNodeExecutor;
import com.liferay.portal.workflow.kaleo.runtime.node.NodeExecutor;
import com.liferay.portal.workflow.kaleo.service.KaleoInstanceLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoInstanceTokenLocalService;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"node.type=STATE"}, service={NodeExecutor.class})
public class StateNodeExecutor
extends BaseNodeExecutor {
    @Reference
    private KaleoInstanceLocalService _kaleoInstanceLocalService;
    @Reference
    private KaleoInstanceTokenLocalService _kaleoInstanceTokenLocalService;

    protected boolean doEnter(KaleoNode currentKaleoNode, ExecutionContext executionContext) {
        return true;
    }

    protected void doExecute(KaleoNode currentKaleoNode, ExecutionContext executionContext, List<PathElement> remainingPathElements) throws PortalException {
        KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
        if (!currentKaleoNode.hasKaleoTransition()) {
            if ((kaleoInstanceToken = this._kaleoInstanceTokenLocalService.completeKaleoInstanceToken(kaleoInstanceToken.getKaleoInstanceTokenId())).getParentKaleoInstanceTokenId() == 0L) {
                this._kaleoInstanceLocalService.completeKaleoInstance(kaleoInstanceToken.getKaleoInstanceId());
            }
            return;
        }
        String transitionName = executionContext.getTransitionName();
        KaleoTransition kaleoTransition = null;
        kaleoTransition = Validator.isNull((String)transitionName) ? currentKaleoNode.getDefaultKaleoTransition() : currentKaleoNode.getKaleoTransition(transitionName);
        ExecutionContext newExecutionContext = new ExecutionContext(kaleoInstanceToken, executionContext.getWorkflowContext(), executionContext.getServiceContext());
        PathElement pathElement = new PathElement(currentKaleoNode, kaleoTransition.getTargetKaleoNode(), newExecutionContext);
        remainingPathElements.add(pathElement);
    }

    protected void doExit(KaleoNode currentKaleoNode, ExecutionContext executionContext, List<PathElement> remainingPathElements) {
    }
}

