/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.helper;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.definition.ExecutionType;
import com.liferay.portal.workflow.kaleo.model.KaleoNotification;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.internal.notification.NotificationMessageGeneratorFactory;
import com.liferay.portal.workflow.kaleo.runtime.internal.notification.NotificationSenderFactory;
import com.liferay.portal.workflow.kaleo.runtime.notification.NotificationHelper;
import com.liferay.portal.workflow.kaleo.runtime.notification.NotificationMessageGenerator;
import com.liferay.portal.workflow.kaleo.runtime.notification.NotificationSender;
import com.liferay.portal.workflow.kaleo.service.KaleoNotificationLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoNotificationRecipientLocalService;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={NotificationHelper.class})
public class NotificationHelperImpl
implements NotificationHelper {
    @Reference
    private KaleoNotificationLocalService _kaleoNotificationLocalService;
    @Reference
    private KaleoNotificationRecipientLocalService _kaleoNotificationRecipientLocalService;
    @Reference
    private NotificationMessageGeneratorFactory _notificationMessageGeneratorFactory;
    @Reference
    private NotificationSenderFactory _notificationSenderFactory;

    public void sendKaleoNotifications(String kaleoClassName, long kaleoClassPK, ExecutionType executionType, ExecutionContext executionContext) throws PortalException {
        List kaleoNotifications = this._kaleoNotificationLocalService.getKaleoNotifications(kaleoClassName, kaleoClassPK, executionType.getValue());
        for (KaleoNotification kaleoNotification : kaleoNotifications) {
            this._sendKaleoNotification(kaleoNotification, executionContext);
        }
    }

    private void _sendKaleoNotification(KaleoNotification kaleoNotification, ExecutionContext executionContext) throws PortalException {
        NotificationMessageGenerator notificationMessageGenerator = this._notificationMessageGeneratorFactory.getNotificationMessageGenerator(kaleoNotification.getTemplateLanguage());
        String notificationMessage = notificationMessageGenerator.generateMessage(kaleoNotification.getKaleoClassName(), kaleoNotification.getKaleoClassPK(), kaleoNotification.getName(), kaleoNotification.getTemplateLanguage(), kaleoNotification.getTemplate(), executionContext);
        String notificationSubject = "";
        if (Validator.isNotNull((String)kaleoNotification.getDescription())) {
            notificationSubject = notificationMessageGenerator.generateMessage(kaleoNotification.getKaleoClassName(), kaleoNotification.getKaleoClassPK(), kaleoNotification.getName(), kaleoNotification.getTemplateLanguage(), kaleoNotification.getDescription(), executionContext);
        }
        String[] notificationTypes = StringUtil.split((String)kaleoNotification.getNotificationTypes());
        List kaleoNotificationRecipient = this._kaleoNotificationRecipientLocalService.getKaleoNotificationRecipients(kaleoNotification.getKaleoNotificationId());
        for (String notificationType : notificationTypes) {
            NotificationSender notificationSender = this._notificationSenderFactory.getNotificationSender(notificationType);
            notificationSender.sendNotification(kaleoNotificationRecipient, notificationSubject, notificationMessage, executionContext);
        }
    }
}

