/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.transaction.Isolation;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUID;
import com.liferay.portal.kernel.workflow.WorkflowDefinition;
import com.liferay.portal.kernel.workflow.WorkflowDefinitionFileException;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.kernel.workflow.WorkflowInstance;
import com.liferay.portal.kernel.workflow.search.WorkflowModelSearchResult;
import com.liferay.portal.workflow.kaleo.KaleoWorkflowModelConverter;
import com.liferay.portal.workflow.kaleo.definition.Definition;
import com.liferay.portal.workflow.kaleo.definition.deployment.WorkflowDeployer;
import com.liferay.portal.workflow.kaleo.definition.parser.WorkflowModelParser;
import com.liferay.portal.workflow.kaleo.definition.parser.WorkflowValidator;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinition;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinitionVersion;
import com.liferay.portal.workflow.kaleo.model.KaleoInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.model.KaleoTimerInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoTransition;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.KaleoSignaler;
import com.liferay.portal.workflow.kaleo.runtime.WorkflowEngine;
import com.liferay.portal.workflow.kaleo.runtime.internal.BaseKaleoBean;
import com.liferay.portal.workflow.kaleo.runtime.internal.node.TaskNodeExecutor;
import com.liferay.portal.workflow.kaleo.runtime.util.WorkflowContextUtil;
import com.liferay.portal.workflow.kaleo.runtime.util.comparator.KaleoInstanceOrderByComparator;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@CTAware
@Transactional(isolation=Isolation.PORTAL, propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
@Component(service={AopService.class})
public class DefaultWorkflowEngineImpl
extends BaseKaleoBean
implements AopService,
WorkflowEngine {
    @Reference
    protected PortalUUID portalUUID;
    private static final Log _log = LogFactoryUtil.getLog(DefaultWorkflowEngineImpl.class);
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private KaleoSignaler _kaleoSignaler;
    @Reference
    private KaleoWorkflowModelConverter _kaleoWorkflowModelConverter;
    @Reference
    private TaskNodeExecutor _taskNodeExecutor;
    @Reference
    private WorkflowDeployer _workflowDeployer;
    @Reference
    private WorkflowModelParser _workflowModelParser;
    @Reference
    private WorkflowValidator _workflowValidator;

    public void deleteWorkflowDefinition(String name, int version, ServiceContext serviceContext) throws WorkflowException {
        try {
            KaleoDefinition kaleoDefinition = this.kaleoDefinitionLocalService.fetchKaleoDefinition(name, serviceContext);
            if (kaleoDefinition != null) {
                this.kaleoDefinitionLocalService.deleteKaleoDefinition(name, serviceContext);
            } else {
                this.kaleoDefinitionVersionLocalService.deleteKaleoDefinitionVersions(serviceContext.getCompanyId(), name);
            }
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public void deleteWorkflowInstance(long workflowInstanceId, ServiceContext serviceContext) throws WorkflowException {
        try {
            this.kaleoInstanceLocalService.deleteKaleoInstance(workflowInstanceId);
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public WorkflowDefinition deployWorkflowDefinition(String title, String name, String scope, InputStream inputStream, ServiceContext serviceContext) throws WorkflowException {
        try {
            Definition definition = this._workflowModelParser.parse(inputStream);
            if (this._workflowValidator != null) {
                this._workflowValidator.validate(definition);
            }
            String definitionName = this._getDefinitionName(definition, name);
            KaleoDefinition kaleoDefinition = this.kaleoDefinitionLocalService.fetchKaleoDefinition(definitionName, serviceContext);
            WorkflowDefinition workflowDefinition = this._workflowDeployer.deploy(title, definitionName, scope, definition, serviceContext);
            if (kaleoDefinition != null) {
                List workflowDefinitionLinks = this.workflowDefinitionLinkLocalService.getWorkflowDefinitionLinks(serviceContext.getCompanyId(), kaleoDefinition.getName(), kaleoDefinition.getVersion());
                for (WorkflowDefinitionLink workflowDefinitionLink : workflowDefinitionLinks) {
                    workflowDefinitionLink.setWorkflowDefinitionVersion(workflowDefinition.getVersion());
                    this.workflowDefinitionLinkLocalService.updateWorkflowDefinitionLink(workflowDefinitionLink);
                }
            }
            return workflowDefinition;
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (PortalException portalException) {
            throw new WorkflowException((Throwable)portalException);
        }
    }

    public ExecutionContext executeTimerWorkflowInstance(long kaleoTimerInstanceTokenId, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws WorkflowException {
        try {
            KaleoTimerInstanceToken kaleoTimerInstanceToken = this.kaleoTimerInstanceTokenLocalService.getKaleoTimerInstanceToken(kaleoTimerInstanceTokenId);
            KaleoInstanceToken kaleoInstanceToken = kaleoTimerInstanceToken.getKaleoInstanceToken();
            ExecutionContext executionContext = new ExecutionContext(kaleoInstanceToken, kaleoTimerInstanceToken, workflowContext, serviceContext);
            executionContext.setKaleoTaskInstanceToken(kaleoTimerInstanceToken.getKaleoTaskInstanceToken());
            this._taskNodeExecutor.executeTimer(executionContext);
            kaleoTimerInstanceToken = this.kaleoTimerInstanceTokenLocalService.getKaleoTimerInstanceToken(kaleoTimerInstanceTokenId);
            if (!kaleoTimerInstanceToken.isCompleted()) {
                kaleoTimerInstanceToken.setWorkflowContext(WorkflowContextUtil.convert((Map)executionContext.getWorkflowContext()));
                this.kaleoTimerInstanceTokenLocalService.updateKaleoTimerInstanceToken(kaleoTimerInstanceToken);
            }
            TransactionCommitCallbackUtil.registerCallback(() -> {
                this._kaleoSignaler.signalExecute(kaleoInstanceToken.getCurrentKaleoNode(), executionContext);
                return null;
            });
            return executionContext;
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<String> getNextTransitionNames(long workflowInstanceId, ServiceContext serviceContext) throws WorkflowException {
        try {
            KaleoInstance kaleoInstance = this.kaleoInstanceLocalService.getKaleoInstance(workflowInstanceId);
            KaleoInstanceToken rootKaleoInstanceToken = kaleoInstance.getRootKaleoInstanceToken(null, serviceContext);
            ArrayList<String> transitionNames = new ArrayList<String>();
            this.getNextTransitionNames(rootKaleoInstanceToken, transitionNames);
            return transitionNames;
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public WorkflowInstance getWorkflowInstance(long workflowInstanceId, ServiceContext serviceContext) throws WorkflowException {
        try {
            KaleoInstance kaleoInstance = null;
            kaleoInstance = serviceContext.getUserId() > 0L ? this.kaleoInstanceLocalService.fetchKaleoInstance(workflowInstanceId, serviceContext.getCompanyId(), serviceContext.getUserId()) : this.kaleoInstanceLocalService.getKaleoInstance(workflowInstanceId);
            if (kaleoInstance != null) {
                return this._kaleoWorkflowModelConverter.toWorkflowInstance(kaleoInstance, kaleoInstance.getRootKaleoInstanceToken(serviceContext));
            }
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
        return null;
    }

    public int getWorkflowInstanceCount(Long userId, String assetClassName, Long assetClassPK, Boolean completed, ServiceContext serviceContext) throws WorkflowException {
        try {
            return this.kaleoInstanceLocalService.getKaleoInstancesCount(userId, assetClassName, assetClassPK, completed, serviceContext);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public int getWorkflowInstanceCount(Long userId, String[] assetClassNames, Boolean completed, ServiceContext serviceContext) throws WorkflowException {
        try {
            return this.kaleoInstanceLocalService.getKaleoInstancesCount(userId, assetClassNames, completed, serviceContext);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public int getWorkflowInstanceCount(String workflowDefinitionName, int workflowDefinitionVersion, boolean completed, ServiceContext serviceContext) throws WorkflowException {
        try {
            return this.kaleoInstanceLocalService.getKaleoInstancesCount(workflowDefinitionName, workflowDefinitionVersion, completed, serviceContext);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<WorkflowInstance> getWorkflowInstances(Long userId, String assetClassName, Long assetClassPK, Boolean completed, int start, int end, OrderByComparator<WorkflowInstance> orderByComparator, ServiceContext serviceContext) throws WorkflowException {
        try {
            return this._toWorkflowInstances(this.kaleoInstanceLocalService.getKaleoInstances(userId, assetClassName, assetClassPK, completed, start, end, KaleoInstanceOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter, (ServiceContext)serviceContext), serviceContext), serviceContext);
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<WorkflowInstance> getWorkflowInstances(Long userId, String[] assetClassNames, Boolean completed, int start, int end, OrderByComparator<WorkflowInstance> orderByComparator, ServiceContext serviceContext) throws WorkflowException {
        try {
            return this._toWorkflowInstances(this.kaleoInstanceLocalService.getKaleoInstances(userId, assetClassNames, completed, start, end, KaleoInstanceOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter, (ServiceContext)serviceContext), serviceContext), serviceContext);
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<WorkflowInstance> getWorkflowInstances(String workflowDefinitionName, int workflowDefinitionVersion, boolean completed, int start, int end, OrderByComparator<WorkflowInstance> orderByComparator, ServiceContext serviceContext) throws WorkflowException {
        try {
            return this._toWorkflowInstances(this.kaleoInstanceLocalService.getKaleoInstances(workflowDefinitionName, workflowDefinitionVersion, completed, start, end, KaleoInstanceOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter, (ServiceContext)serviceContext), serviceContext), serviceContext);
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public WorkflowDefinition saveWorkflowDefinition(String title, String name, String scope, byte[] bytes, ServiceContext serviceContext) throws WorkflowException {
        try {
            Definition definition = this._getDefinition(bytes);
            return this._workflowDeployer.save(title, this._getDefinitionName(definition, name, serviceContext), scope, definition, serviceContext);
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public List<WorkflowInstance> search(Long userId, Boolean active, String assetClassName, String assetTitle, String assetDescription, String nodeName, String kaleoDefinitionName, Boolean completed, int start, int end, OrderByComparator<WorkflowInstance> orderByComparator, ServiceContext serviceContext) throws WorkflowException {
        try {
            WorkflowModelSearchResult<WorkflowInstance> workflowModelSearchResult = this.searchWorkflowInstances(userId, active, assetClassName, assetTitle, assetDescription, nodeName, kaleoDefinitionName, completed, false, start, end, orderByComparator, serviceContext);
            return workflowModelSearchResult.getWorkflowModels();
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public int searchCount(Long userId, Boolean active, String assetClassName, String assetTitle, String assetDescription, String nodeName, String kaleoDefinitionName, Boolean completed, ServiceContext serviceContext) throws WorkflowException {
        try {
            return this.kaleoInstanceLocalService.searchCount(userId, active, assetClassName, assetTitle, assetDescription, nodeName, kaleoDefinitionName, completed, serviceContext);
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public WorkflowModelSearchResult<WorkflowInstance> searchWorkflowInstances(Long userId, Boolean active, String assetClassName, String assetTitle, String assetDescription, String nodeName, String kaleoDefinitionName, Boolean completed, boolean searchByActiveWorkflowHandlers, int start, int end, OrderByComparator<WorkflowInstance> orderByComparator, ServiceContext serviceContext) throws WorkflowException {
        try {
            BaseModelSearchResult baseModelSearchResult = this.kaleoInstanceLocalService.searchKaleoInstances(userId, active, assetClassName, assetTitle, assetDescription, nodeName, kaleoDefinitionName, completed, searchByActiveWorkflowHandlers, start, end, KaleoInstanceOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter, (ServiceContext)serviceContext), serviceContext);
            return new WorkflowModelSearchResult(this._toWorkflowInstances(baseModelSearchResult.getBaseModels(), serviceContext), baseModelSearchResult.getLength());
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public WorkflowInstance signalWorkflowInstance(long workflowInstanceId, String transitionName, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws WorkflowException {
        return this.signalWorkflowInstance(workflowInstanceId, transitionName, workflowContext, serviceContext, false);
    }

    public WorkflowInstance signalWorkflowInstance(long workflowInstanceId, String transitionName, Map<String, Serializable> workflowContext, ServiceContext serviceContext, boolean waitForCompletion) throws WorkflowException {
        try {
            KaleoInstance kaleoInstance = this._updateContext(workflowInstanceId, workflowContext, serviceContext);
            KaleoInstanceToken kaleoInstanceToken = kaleoInstance.getRootKaleoInstanceToken(serviceContext);
            if (Validator.isNotNull((String)transitionName)) {
                KaleoNode currentKaleoNode = kaleoInstanceToken.getCurrentKaleoNode();
                currentKaleoNode.getKaleoTransition(transitionName);
            }
            serviceContext.setScopeGroupId(kaleoInstanceToken.getGroupId());
            ExecutionContext executionContext = new ExecutionContext(kaleoInstanceToken, workflowContext, serviceContext);
            TransactionCommitCallbackUtil.registerCallback(() -> {
                try {
                    this._kaleoSignaler.signalExit(transitionName, executionContext, waitForCompletion);
                }
                catch (Exception exception) {
                    throw new WorkflowException("Unable to signal next transition", (Throwable)exception);
                }
                return null;
            });
            return this._kaleoWorkflowModelConverter.toWorkflowInstance(kaleoInstance, kaleoInstanceToken, workflowContext);
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public WorkflowInstance startWorkflowInstance(String workflowDefinitionName, Integer workflowDefinitionVersion, String transitionName, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws WorkflowException {
        return this.startWorkflowInstance(workflowDefinitionName, workflowDefinitionVersion, transitionName, workflowContext, serviceContext, false);
    }

    public WorkflowInstance startWorkflowInstance(String workflowDefinitionName, Integer workflowDefinitionVersion, String transitionName, Map<String, Serializable> workflowContext, ServiceContext serviceContext, boolean waitForCompletion) throws WorkflowException {
        try {
            Group group;
            long scopeGroupId;
            KaleoDefinition kaleoDefinition = this.kaleoDefinitionLocalService.getKaleoDefinition(workflowDefinitionName, serviceContext);
            if (!kaleoDefinition.isActive()) {
                throw new WorkflowException(StringBundler.concat((Object[])new Object[]{"Inactive workflow definition with name ", workflowDefinitionName, " and version ", workflowDefinitionVersion}));
            }
            KaleoDefinitionVersion kaleoDefinitionVersion = this.kaleoDefinitionVersionLocalService.getKaleoDefinitionVersion(serviceContext.getCompanyId(), workflowDefinitionName, this._getVersion(workflowDefinitionVersion));
            KaleoNode kaleoStartNode = kaleoDefinitionVersion.getKaleoStartNode();
            if (Validator.isNotNull((String)transitionName)) {
                kaleoStartNode.getKaleoTransition(transitionName);
            }
            if ((scopeGroupId = serviceContext.getScopeGroupId()) != 0L && (group = this._groupLocalService.getGroup(scopeGroupId)).isLayout()) {
                group = this._groupLocalService.getGroup(group.getParentGroupId());
                serviceContext.setScopeGroupId(group.getGroupId());
            }
            KaleoInstance kaleoInstance = this.kaleoInstanceLocalService.addKaleoInstance(kaleoDefinition.getKaleoDefinitionId(), kaleoDefinitionVersion.getKaleoDefinitionVersionId(), kaleoDefinitionVersion.getName(), this._getVersion(kaleoDefinitionVersion.getVersion()), workflowContext, serviceContext);
            KaleoInstanceToken rootKaleoInstanceToken = kaleoInstance.getRootKaleoInstanceToken(workflowContext, serviceContext);
            rootKaleoInstanceToken.setCurrentKaleoNode(kaleoStartNode);
            this.kaleoLogLocalService.addWorkflowInstanceStartKaleoLog(rootKaleoInstanceToken, serviceContext);
            ExecutionContext executionContext = new ExecutionContext(rootKaleoInstanceToken, workflowContext, serviceContext);
            TransactionCommitCallbackUtil.registerCallback(() -> {
                try {
                    this._kaleoSignaler.signalEntry(transitionName, executionContext, waitForCompletion);
                }
                catch (Exception exception) {
                    throw new WorkflowException("Unable to start workflow", (Throwable)exception);
                }
                return null;
            });
            return this._kaleoWorkflowModelConverter.toWorkflowInstance(kaleoInstance, rootKaleoInstanceToken, workflowContext);
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public WorkflowInstance updateContext(long workflowInstanceId, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws WorkflowException {
        try {
            KaleoInstance kaleoInstance = this._updateContext(workflowInstanceId, workflowContext, serviceContext);
            return this._kaleoWorkflowModelConverter.toWorkflowInstance(kaleoInstance, kaleoInstance.getRootKaleoInstanceToken(serviceContext));
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    public WorkflowInstance updateWorkflowInstanceActive(long userId, long companyId, long workflowInstanceId, boolean active) throws WorkflowException {
        try {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            serviceContext.setUserId(userId);
            KaleoInstance kaleoInstance = this.kaleoInstanceLocalService.updateActive(userId, workflowInstanceId, active);
            return this._kaleoWorkflowModelConverter.toWorkflowInstance(kaleoInstance, kaleoInstance.getRootKaleoInstanceToken(serviceContext));
        }
        catch (PortalException portalException) {
            throw new WorkflowException((Throwable)portalException);
        }
    }

    public void validateWorkflowDefinition(InputStream inputStream) throws WorkflowException {
        try {
            if (this._workflowValidator != null) {
                Definition definition = this._workflowModelParser.parse(inputStream);
                this._workflowValidator.validate(definition);
            }
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        catch (Exception exception) {
            throw new WorkflowException((Throwable)exception);
        }
    }

    protected void getNextTransitionNames(KaleoInstanceToken kaleoInstanceToken, List<String> transitionNames) throws Exception {
        if (kaleoInstanceToken.hasIncompleteChildrenKaleoInstanceToken()) {
            List incompleteChildrenKaleoInstanceTokens = kaleoInstanceToken.getIncompleteChildrenKaleoInstanceTokens();
            for (KaleoInstanceToken incompleteChildrenKaleoInstanceToken : incompleteChildrenKaleoInstanceTokens) {
                this.getNextTransitionNames(incompleteChildrenKaleoInstanceToken, transitionNames);
            }
        } else {
            KaleoNode kaleoNode = kaleoInstanceToken.getCurrentKaleoNode();
            List kaleoTransitions = kaleoNode.getKaleoTransitions();
            for (KaleoTransition kaleoTransition : kaleoTransitions) {
                transitionNames.add(kaleoTransition.getName());
            }
        }
    }

    private Definition _getDefinition(byte[] bytes) throws WorkflowException {
        try {
            this._workflowModelParser.setValidate(false);
            Definition definition = this._workflowModelParser.parse((InputStream)new UnsyncByteArrayInputStream(bytes));
            return definition;
        }
        catch (WorkflowDefinitionFileException workflowDefinitionFileException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)workflowDefinitionFileException);
            }
            try {
                Definition definition = new Definition("", "", new String(bytes, "UTF-8"), 0);
                return definition;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new WorkflowException((Throwable)unsupportedEncodingException);
            }
        }
        catch (WorkflowException workflowException) {
            throw workflowException;
        }
        finally {
            this._workflowModelParser.setValidate(true);
        }
    }

    private String _getDefinitionName(Definition definition, String name) {
        if (Validator.isNotNull((String)name)) {
            return name;
        }
        if (Validator.isNotNull((String)definition.getName())) {
            return definition.getName();
        }
        return this.portalUUID.generate();
    }

    private String _getDefinitionName(Definition definition, String name, ServiceContext serviceContext) {
        if (Validator.isNotNull((String)name)) {
            return name;
        }
        if (Validator.isNotNull((String)definition.getName())) {
            KaleoDefinition kaleoDefinition = this.kaleoDefinitionLocalService.fetchKaleoDefinition(definition.getName(), serviceContext);
            if (kaleoDefinition != null && kaleoDefinition.isActive()) {
                return this.portalUUID.generate();
            }
            return definition.getName();
        }
        return this.portalUUID.generate();
    }

    private String _getVersion(int version) {
        return version + "." + 0;
    }

    private int _getVersion(String version) {
        int[] versionParts = StringUtil.split((String)version, (String)".", (int)0);
        return versionParts[0];
    }

    private List<WorkflowInstance> _toWorkflowInstances(List<KaleoInstance> kaleoInstances, ServiceContext serviceContext) throws PortalException {
        ArrayList<WorkflowInstance> workflowInstances = new ArrayList<WorkflowInstance>(kaleoInstances.size());
        for (KaleoInstance kaleoInstance : kaleoInstances) {
            workflowInstances.add(this._kaleoWorkflowModelConverter.toWorkflowInstance(kaleoInstance, kaleoInstance.getRootKaleoInstanceToken(serviceContext)));
        }
        return workflowInstances;
    }

    private KaleoInstance _updateContext(long workflowInstanceId, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws Exception {
        return this.kaleoInstanceLocalService.updateKaleoInstance(workflowInstanceId, workflowContext, serviceContext);
    }
}

