/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.notification.recipient;

import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.workflow.kaleo.definition.NotificationReceptionType;
import com.liferay.portal.workflow.kaleo.model.KaleoInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoNotificationRecipient;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignmentInstance;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.notification.NotificationRecipient;
import com.liferay.portal.workflow.kaleo.runtime.notification.recipient.NotificationRecipientBuilder;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"recipient.type=USER"}, service={NotificationRecipientBuilder.class})
public class UserNotificationRecipientBuilder
implements NotificationRecipientBuilder {
    @Reference
    private UserLocalService _userLocalService;

    public void processKaleoNotificationRecipient(Set<NotificationRecipient> notificationRecipients, KaleoNotificationRecipient kaleoNotificationRecipient, NotificationReceptionType notificationReceptionType, ExecutionContext executionContext) throws Exception {
        this.addUserNotificationRecipient(notificationRecipients, kaleoNotificationRecipient.getRecipientClassPK(), notificationReceptionType, executionContext);
    }

    public void processKaleoTaskAssignmentInstance(Set<NotificationRecipient> notificationRecipients, KaleoTaskAssignmentInstance kaleoTaskAssignmentInstance, NotificationReceptionType notificationReceptionType, ExecutionContext executionContext) throws Exception {
        this.addUserNotificationRecipient(notificationRecipients, kaleoTaskAssignmentInstance.getAssigneeClassPK(), notificationReceptionType, executionContext);
    }

    protected void addUserNotificationRecipient(Set<NotificationRecipient> notificationRecipients, long userId, NotificationReceptionType notificationReceptionType, ExecutionContext executionContext) throws Exception {
        User user;
        if (userId <= 0L) {
            KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
            KaleoInstance kaleoInstance = kaleoInstanceToken.getKaleoInstance();
            userId = kaleoInstance.getUserId();
        }
        if ((user = this._userLocalService.fetchUser(userId)) != null && user.isActive()) {
            NotificationRecipient notificationRecipient = new NotificationRecipient(user, notificationReceptionType);
            notificationRecipients.add(notificationRecipient);
        }
    }
}

