/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.node;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.definition.DelayDuration;
import com.liferay.portal.workflow.kaleo.definition.DurationScale;
import com.liferay.portal.workflow.kaleo.definition.ExecutionType;
import com.liferay.portal.workflow.kaleo.definition.exception.KaleoDefinitionValidationException;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.model.KaleoTask;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignment;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoTimer;
import com.liferay.portal.workflow.kaleo.model.KaleoTransition;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.assignment.TaskAssignmentSelector;
import com.liferay.portal.workflow.kaleo.runtime.assignment.TaskAssignmentSelectorRegistry;
import com.liferay.portal.workflow.kaleo.runtime.calendar.DueDateCalculator;
import com.liferay.portal.workflow.kaleo.runtime.graph.PathElement;
import com.liferay.portal.workflow.kaleo.runtime.internal.assignment.TaskAssignerHelper;
import com.liferay.portal.workflow.kaleo.runtime.node.BaseNodeExecutor;
import com.liferay.portal.workflow.kaleo.runtime.node.NodeExecutor;
import com.liferay.portal.workflow.kaleo.service.KaleoLogLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskInstanceTokenLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskLocalService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"node.type=TASK"}, service={NodeExecutor.class})
public class TaskNodeExecutor
extends BaseNodeExecutor {
    @Reference
    private DueDateCalculator _dueDateCalculator;
    @Reference
    private KaleoLogLocalService _kaleoLogLocalService;
    @Reference
    private KaleoTaskInstanceTokenLocalService _kaleoTaskInstanceTokenLocalService;
    @Reference
    private KaleoTaskLocalService _kaleoTaskLocalService;
    @Reference
    private TaskAssignerHelper _taskAssignerHelper;
    @Reference
    private TaskAssignmentSelectorRegistry _taskAssignmentSelectorRegistry;

    protected Date calculateDueDate(KaleoTask kaleoTask) throws KaleoDefinitionValidationException {
        List kaleoTimers = this.kaleoTimerLocalService.getKaleoTimers(KaleoNode.class.getName(), kaleoTask.getKaleoNodeId());
        if (kaleoTimers.isEmpty()) {
            return null;
        }
        TreeSet<Date> sortedDueDates = new TreeSet<Date>();
        for (KaleoTimer kaleoTimer : kaleoTimers) {
            DelayDuration delayDuration = new DelayDuration(kaleoTimer.getDuration(), DurationScale.parse((String)kaleoTimer.getScale()));
            Date dueDate = this._dueDateCalculator.getDueDate(new Date(), delayDuration);
            sortedDueDates.add(dueDate);
        }
        return (Date)sortedDueDates.first();
    }

    protected KaleoTaskInstanceToken createTaskInstanceToken(ExecutionContext executionContext, Map<String, Serializable> workflowContext, ServiceContext serviceContext, KaleoInstanceToken kaleoInstanceToken, KaleoTask kaleoTask, Date dueDate) throws PortalException {
        List configuredKaleoTaskAssignments = kaleoTask.getKaleoTaskAssignments();
        ArrayList kaleoTaskAssignments = new ArrayList();
        for (KaleoTaskAssignment configuredKaleoTaskAssignment : configuredKaleoTaskAssignments) {
            TaskAssignmentSelector taskAssignmentSelector = this._taskAssignmentSelectorRegistry.getTaskAssignmentSelector(configuredKaleoTaskAssignment.getAssigneeClassName());
            Collection calculatedKaleoTaskAssignments = taskAssignmentSelector.calculateTaskAssignments(configuredKaleoTaskAssignment, executionContext);
            kaleoTaskAssignments.addAll(calculatedKaleoTaskAssignments);
        }
        return this._kaleoTaskInstanceTokenLocalService.addKaleoTaskInstanceToken(kaleoInstanceToken.getKaleoInstanceTokenId(), kaleoTask.getKaleoTaskId(), kaleoTask.getName(), kaleoTaskAssignments, dueDate, workflowContext, serviceContext);
    }

    protected boolean doEnter(KaleoNode currentKaleoNode, ExecutionContext executionContext) throws PortalException {
        Map workflowContext = executionContext.getWorkflowContext();
        ServiceContext serviceContext = executionContext.getServiceContext();
        KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
        KaleoTask kaleoTask = this._kaleoTaskLocalService.getKaleoNodeKaleoTask(currentKaleoNode.getKaleoNodeId());
        Date dueDate = this.calculateDueDate(kaleoTask);
        KaleoTaskInstanceToken kaleoTaskInstanceToken = this.createTaskInstanceToken(executionContext, workflowContext, serviceContext, kaleoInstanceToken, kaleoTask, dueDate);
        executionContext.setKaleoTaskInstanceToken(kaleoTaskInstanceToken);
        this.kaleoActionExecutor.executeKaleoActions(KaleoNode.class.getName(), currentKaleoNode.getKaleoNodeId(), ExecutionType.ON_ASSIGNMENT, executionContext);
        this.notificationHelper.sendKaleoNotifications(KaleoNode.class.getName(), currentKaleoNode.getKaleoNodeId(), ExecutionType.ON_ASSIGNMENT, executionContext);
        this._kaleoLogLocalService.addTaskAssignmentKaleoLog(null, kaleoTaskInstanceToken, "assigned-initial-task", workflowContext, serviceContext);
        return true;
    }

    protected void doExecute(KaleoNode currentKaleoNode, ExecutionContext executionContext, List<PathElement> remainingPathElements) {
    }

    protected void doExecuteTimer(KaleoNode currentKaleoNode, KaleoTimer kaleoTimer, ExecutionContext executionContext) throws PortalException {
        List kaleoTaskReassignments = kaleoTimer.getKaleoTaskReassignments();
        if (kaleoTaskReassignments.isEmpty()) {
            return;
        }
        this._taskAssignerHelper.reassignKaleoTask(kaleoTaskReassignments, executionContext);
    }

    protected void doExit(KaleoNode currentKaleoNode, ExecutionContext executionContext, List<PathElement> remainingPathElements) throws PortalException {
        String transitionName = executionContext.getTransitionName();
        KaleoTransition kaleoTransition = null;
        kaleoTransition = Validator.isNull((String)transitionName) ? currentKaleoNode.getDefaultKaleoTransition() : currentKaleoNode.getKaleoTransition(transitionName);
        ExecutionContext newExecutionContext = new ExecutionContext(executionContext.getKaleoInstanceToken(), executionContext.getKaleoTaskInstanceToken(), executionContext.getWorkflowContext(), executionContext.getServiceContext());
        PathElement pathElement = new PathElement(null, kaleoTransition.getTargetKaleoNode(), newExecutionContext);
        remainingPathElements.add(pathElement);
    }
}

