/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationEventListener;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.proxy.ProxyMessageListener;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerEventMessageListenerWrapper;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.workflow.WorkflowDefinitionManager;
import com.liferay.portal.kernel.workflow.WorkflowEngineManager;
import com.liferay.portal.kernel.workflow.WorkflowInstanceManager;
import com.liferay.portal.kernel.workflow.WorkflowLogManager;
import com.liferay.portal.kernel.workflow.WorkflowTaskManager;
import com.liferay.portal.kernel.workflow.comparator.WorkflowComparatorFactory;
import com.liferay.portal.kernel.workflow.messaging.DefaultWorkflowDestinationEventListener;
import com.liferay.portal.workflow.kaleo.runtime.internal.timer.messaging.TimerMessageListener;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={KaleoWorkflowMessagingConfigurator.class})
public class KaleoWorkflowMessagingConfigurator {
    private static final int _MAXIMUM_QUEUE_SIZE = 200;
    private static final Log _log = LogFactoryUtil.getLog(KaleoWorkflowMessagingConfigurator.class);
    private BundleContext _bundleContext;
    private DefaultWorkflowDestinationEventListener _defaultWorkflowDestinationEventListener;
    @Reference
    private DestinationFactory _destinationFactory;
    @Reference
    private MessageBus _messageBus;
    private final Map<String, MessageListener> _proxyMessageListeners = new HashMap<String, MessageListener>();
    private ServiceRegistration<MessageListener> _schedulerEventMessageListenerServiceRegistration;
    private final Map<String, ServiceRegistration<Destination>> _serviceRegistrations = new HashMap<String, ServiceRegistration<Destination>>();
    @Reference
    private TimerMessageListener _timerMessageListener;
    @Reference(target="(proxy.bean=false)")
    private WorkflowComparatorFactory _workflowComparatorFactory;
    @Reference(target="(proxy.bean=false)")
    private WorkflowDefinitionManager _workflowDefinitionManager;
    @Reference(target="(destination.name=liferay/workflow_engine)")
    private Destination _workflowEngineDestination;
    @Reference(target="(proxy.bean=false)")
    private WorkflowEngineManager _workflowEngineManager;
    @Reference(target="(proxy.bean=false)")
    private WorkflowInstanceManager _workflowInstanceManager;
    @Reference(target="(proxy.bean=false)")
    private WorkflowLogManager _workflowLogManager;
    @Reference(target="(proxy.bean=false)")
    private WorkflowTaskManager _workflowTaskManager;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this.registerKaleoGraphWalkerDestination();
        this.registerWorkflowDefinitionLinkDestination();
        this.registerWorkflowMessageListeners();
        this.registerWorkflowTimerDestination();
        this.registerSchedulerEventMessageListener();
    }

    @Deactivate
    protected void deactivate() {
        this.unregisterKaleoWorkflowDestinations();
        this.unregisterWorkflowEngineDestinationListener();
        this.unregisterWorkflowMessageListeners();
        this.unregisterSchedulerEventMessageListener();
        this._bundleContext = null;
    }

    protected void registerDestination(DestinationConfiguration kaleoGraphWalkerDestinationConfiguration) {
        Destination destination = this._destinationFactory.createDestination(kaleoGraphWalkerDestinationConfiguration);
        HashMapDictionary properties = new HashMapDictionary();
        properties.put("destination.name", destination.getName());
        ServiceRegistration serviceRegistration = this._bundleContext.registerService(Destination.class, (Object)destination, (Dictionary)properties);
        this._serviceRegistrations.put(destination.getName(), (ServiceRegistration<Destination>)serviceRegistration);
    }

    protected void registerKaleoGraphWalkerDestination() {
        DestinationConfiguration destinationConfiguration = new DestinationConfiguration("parallel", "liferay/kaleo_graph_walker");
        destinationConfiguration.setMaximumQueueSize(200);
        ThreadPoolExecutor.CallerRunsPolicy rejectedExecutionHandler = new ThreadPoolExecutor.CallerRunsPolicy(){

            @Override
            public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"The current thread will handle the request because the graph walker's task queue is at its maximum capacity");
                }
                super.rejectedExecution(runnable, threadPoolExecutor);
            }
        };
        destinationConfiguration.setRejectedExecutionHandler((RejectedExecutionHandler)rejectedExecutionHandler);
        this.registerDestination(destinationConfiguration);
    }

    protected MessageListener registerProxyMessageListener(Object manager, String destinationName) {
        ProxyMessageListener proxyMessageListener = new ProxyMessageListener();
        proxyMessageListener.setManager(manager);
        proxyMessageListener.setMessageBus(this._messageBus);
        this._messageBus.registerMessageListener(destinationName, (MessageListener)proxyMessageListener);
        this._proxyMessageListeners.put(destinationName, (MessageListener)proxyMessageListener);
        return proxyMessageListener;
    }

    protected void registerSchedulerEventMessageListener() {
        SchedulerEventMessageListenerWrapper schedulerEventMessageListenerWrapper = new SchedulerEventMessageListenerWrapper();
        schedulerEventMessageListenerWrapper.setMessageListener((MessageListener)this._timerMessageListener);
        HashMapDictionary properties = new HashMapDictionary();
        properties.put("destination.name", "destination.workflow_timer");
        this._schedulerEventMessageListenerServiceRegistration = this._bundleContext.registerService(MessageListener.class, (Object)schedulerEventMessageListenerWrapper, (Dictionary)properties);
    }

    protected void registerWorkflowDefinitionLinkDestination() {
        DestinationConfiguration destinationConfiguration = new DestinationConfiguration("synchronous", "destination.workflow_definition_link");
        this.registerDestination(destinationConfiguration);
    }

    protected void registerWorkflowMessageListeners() {
        this._defaultWorkflowDestinationEventListener = new DefaultWorkflowDestinationEventListener();
        this._defaultWorkflowDestinationEventListener.setWorkflowEngineName("Liferay Kaleo Workflow Engine");
        MessageListener workflowComparatorMessageListener = this.registerProxyMessageListener(this._workflowComparatorFactory, "liferay/workflow_comparator");
        this._defaultWorkflowDestinationEventListener.setWorkflowComparatorFactoryListener(workflowComparatorMessageListener);
        MessageListener workflowDefinitionManagerProxyMessageListener = this.registerProxyMessageListener(this._workflowDefinitionManager, "liferay/workflow_definition");
        this._defaultWorkflowDestinationEventListener.setWorkflowDefinitionManagerListener(workflowDefinitionManagerProxyMessageListener);
        MessageListener workflowEngineManagerProxyMessageListener = this.registerProxyMessageListener(this._workflowEngineManager, "liferay/workflow_engine");
        this._defaultWorkflowDestinationEventListener.setWorkflowEngineManagerListener(workflowEngineManagerProxyMessageListener);
        MessageListener workflowInstanceManagerProxyMessageListener = this.registerProxyMessageListener(this._workflowInstanceManager, "liferay/workflow_instance");
        this._defaultWorkflowDestinationEventListener.setWorkflowInstanceManagerListener(workflowInstanceManagerProxyMessageListener);
        MessageListener workflowLogManagerProxyMessageListener = this.registerProxyMessageListener(this._workflowLogManager, "liferay/workflow_log");
        this._defaultWorkflowDestinationEventListener.setWorkflowLogManagerListener(workflowLogManagerProxyMessageListener);
        MessageListener workflowTaskManagerProxyMessageListener = this.registerProxyMessageListener(this._workflowTaskManager, "liferay/workflow_task");
        this._defaultWorkflowDestinationEventListener.setWorkflowTaskManagerListener(workflowTaskManagerProxyMessageListener);
        this._workflowEngineDestination.addDestinationEventListener((DestinationEventListener)this._defaultWorkflowDestinationEventListener);
    }

    protected void registerWorkflowTimerDestination() {
        DestinationConfiguration destinationConfiguration = new DestinationConfiguration("parallel", "destination.workflow_timer");
        destinationConfiguration.setMaximumQueueSize(200);
        ThreadPoolExecutor.CallerRunsPolicy rejectedExecutionHandler = new ThreadPoolExecutor.CallerRunsPolicy(){

            @Override
            public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"The current thread will handle the request because the workflow timer task queue is at its maximum capacity");
                }
                super.rejectedExecution(runnable, threadPoolExecutor);
            }
        };
        destinationConfiguration.setRejectedExecutionHandler((RejectedExecutionHandler)rejectedExecutionHandler);
        this.registerDestination(destinationConfiguration);
    }

    protected void unregisterKaleoWorkflowDestinations() {
        for (ServiceRegistration<Destination> serviceRegistration : this._serviceRegistrations.values()) {
            Destination destination = (Destination)this._bundleContext.getService(serviceRegistration.getReference());
            serviceRegistration.unregister();
            destination.destroy();
        }
        this._serviceRegistrations.clear();
    }

    protected void unregisterSchedulerEventMessageListener() {
        if (this._schedulerEventMessageListenerServiceRegistration == null) {
            return;
        }
        this._schedulerEventMessageListenerServiceRegistration.unregister();
        this._schedulerEventMessageListenerServiceRegistration = null;
    }

    protected void unregisterWorkflowEngineDestinationListener() {
        this._workflowEngineDestination.removeDestinationEventListener((DestinationEventListener)this._defaultWorkflowDestinationEventListener);
    }

    protected void unregisterWorkflowMessageListeners() {
        for (Map.Entry<String, MessageListener> entry : this._proxyMessageListeners.entrySet()) {
            this._messageBus.unregisterMessageListener(entry.getKey(), entry.getValue());
        }
        this._proxyMessageListeners.clear();
    }
}

