/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.assignment;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignment;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.assignment.TaskAssignmentSelector;
import com.liferay.portal.workflow.kaleo.runtime.assignment.TaskAssignmentSelectorRegistry;
import com.liferay.portal.workflow.kaleo.service.KaleoLogLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskInstanceTokenLocalService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={TaskAssignerHelper.class})
public class TaskAssignerHelper {
    @Reference
    private KaleoLogLocalService _kaleoLogLocalService;
    @Reference
    private KaleoTaskInstanceTokenLocalService _kaleoTaskInstanceTokenLocalService;
    @Reference
    private TaskAssignmentSelectorRegistry _taskAssignmentSelectorRegistry;

    public void reassignKaleoTask(List<KaleoTaskAssignment> kaleoTaskAssignments, ExecutionContext executionContext) throws PortalException {
        KaleoTaskInstanceToken kaleoTaskInstanceToken = executionContext.getKaleoTaskInstanceToken();
        List previousTaskAssignmentInstances = kaleoTaskInstanceToken.getKaleoTaskAssignmentInstances();
        ArrayList reassignedKaleoTaskAssignments = new ArrayList();
        for (KaleoTaskAssignment kaleoTaskAssignment : kaleoTaskAssignments) {
            TaskAssignmentSelector taskAssignmentSelector = this._taskAssignmentSelectorRegistry.getTaskAssignmentSelector(kaleoTaskAssignment.getAssigneeClassName());
            Collection calculatedKaleoTaskAssignments = taskAssignmentSelector.calculateTaskAssignments(kaleoTaskAssignment, executionContext);
            reassignedKaleoTaskAssignments.addAll(calculatedKaleoTaskAssignments);
        }
        kaleoTaskInstanceToken = this._kaleoTaskInstanceTokenLocalService.assignKaleoTaskInstanceToken(kaleoTaskInstanceToken.getKaleoTaskInstanceTokenId(), reassignedKaleoTaskAssignments, executionContext.getWorkflowContext(), executionContext.getServiceContext());
        this._kaleoLogLocalService.addTaskAssignmentKaleoLog(previousTaskAssignmentInstances, kaleoTaskInstanceToken, null, executionContext.getWorkflowContext(), executionContext.getServiceContext());
    }
}

