/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.notification.recipient.script;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.workflow.kaleo.definition.ScriptLanguage;
import com.liferay.portal.workflow.kaleo.model.KaleoNotificationRecipient;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.notification.recipient.script.NotificationRecipientEvaluator;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={NotificationRecipientEvaluator.class})
public class MultiLanguageNotificationRecipientEvaluator
implements NotificationRecipientEvaluator {
    private final Map<String, NotificationRecipientEvaluator> _notificationRecipientEvaluators = new HashMap<String, NotificationRecipientEvaluator>();

    public Map<String, ?> evaluate(KaleoNotificationRecipient kaleoNotificationRecipient, ExecutionContext executionContext) throws PortalException {
        String notificationRecipientEvaluatorKey = this.getNotificationRecipientEvaluatorKey(kaleoNotificationRecipient.getRecipientScriptLanguage(), kaleoNotificationRecipient.getRecipientScript());
        NotificationRecipientEvaluator notificationRecipientEvaluator = this._notificationRecipientEvaluators.get(notificationRecipientEvaluatorKey);
        if (notificationRecipientEvaluator == null) {
            throw new IllegalArgumentException("No notification recipient evaluator for script language " + notificationRecipientEvaluatorKey);
        }
        return notificationRecipientEvaluator.evaluate(kaleoNotificationRecipient, executionContext);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(scripting.language=*)")
    protected void addNotificationRecipientEvaluator(NotificationRecipientEvaluator notificationRecipientEvaluator, Map<String, Object> properties) {
        String[] scriptingLanguages;
        for (String scriptingLanguage : scriptingLanguages = this._getScriptingLanguages(notificationRecipientEvaluator, properties)) {
            String notificationRecipientEvaluatorKey = this.getNotificationRecipientEvaluatorKey(scriptingLanguage, ClassUtil.getClassName((Object)notificationRecipientEvaluator));
            this._notificationRecipientEvaluators.put(notificationRecipientEvaluatorKey, notificationRecipientEvaluator);
        }
    }

    protected String getNotificationRecipientEvaluatorKey(String language, String notificationRecipientEvaluatorClassName) {
        ScriptLanguage scriptLanguage = ScriptLanguage.parse((String)language);
        if (scriptLanguage.equals((Object)ScriptLanguage.JAVA)) {
            return language + ":" + notificationRecipientEvaluatorClassName;
        }
        return language;
    }

    protected void removeNotificationRecipientEvaluator(NotificationRecipientEvaluator notificationRecipientEvaluator, Map<String, Object> properties) {
        String[] scriptingLanguages;
        for (String scriptingLanguage : scriptingLanguages = this._getScriptingLanguages(notificationRecipientEvaluator, properties)) {
            String notificationRecipientEvaluatorKey = this.getNotificationRecipientEvaluatorKey(scriptingLanguage, ClassUtil.getClassName((Object)notificationRecipientEvaluator));
            this._notificationRecipientEvaluators.remove(notificationRecipientEvaluatorKey);
        }
    }

    private String[] _getScriptingLanguages(NotificationRecipientEvaluator notificationRecipientEvaluator, Map<String, Object> properties) {
        Object value = properties.get("scripting.language");
        Object[] scriptingLanguages = GetterUtil.getStringValues((Object)value, (String[])new String[]{String.valueOf(value)});
        if (ArrayUtil.isEmpty((Object[])scriptingLanguages)) {
            throw new IllegalArgumentException("Must have a scripting.language property for: " + ClassUtil.getClassName((Object)notificationRecipientEvaluator));
        }
        return scriptingLanguages;
    }
}

