/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.notification.recipient;

import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.workflow.kaleo.definition.NotificationReceptionType;
import com.liferay.portal.workflow.kaleo.model.KaleoNotificationRecipient;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignmentInstance;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.internal.notification.recipient.RoleNotificationRecipientBuilder;
import com.liferay.portal.workflow.kaleo.runtime.notification.NotificationRecipient;
import com.liferay.portal.workflow.kaleo.runtime.notification.recipient.NotificationRecipientBuilder;
import com.liferay.portal.workflow.kaleo.runtime.notification.recipient.script.NotificationRecipientEvaluator;
import com.liferay.portal.workflow.kaleo.runtime.util.WorkflowContextUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"recipient.type=SCRIPT"}, service={NotificationRecipientBuilder.class})
public class ScriptNotificationRecipientBuilder
implements NotificationRecipientBuilder {
    @Reference(target="(!(scripting.language=*))")
    private NotificationRecipientEvaluator _notificationRecipientEvaluator;
    @Reference
    private RoleNotificationRecipientBuilder _roleNotificationRecipientBuilder;

    public void processKaleoNotificationRecipient(Set<NotificationRecipient> notificationRecipients, KaleoNotificationRecipient kaleoNotificationRecipient, NotificationReceptionType notificationReceptionType, ExecutionContext executionContext) throws Exception {
        Map results = this._notificationRecipientEvaluator.evaluate(kaleoNotificationRecipient, executionContext);
        Map resultsWorkflowContext = (Map)results.get("workflowContext");
        WorkflowContextUtil.mergeWorkflowContexts((ExecutionContext)executionContext, (Map)resultsWorkflowContext);
        User user = (User)results.get("user");
        if (user != null) {
            if (user.isActive()) {
                NotificationRecipient notificationRecipient = new NotificationRecipient(user, notificationReceptionType);
                notificationRecipients.add(notificationRecipient);
            }
        } else {
            List roles = (List)results.get("roles");
            for (Role role : roles) {
                this._roleNotificationRecipientBuilder.addRoleRecipientAddresses(notificationRecipients, role, notificationReceptionType, executionContext);
            }
        }
    }

    public void processKaleoTaskAssignmentInstance(Set<NotificationRecipient> notificationRecipients, KaleoTaskAssignmentInstance kaleoTaskAssignmentInstance, NotificationReceptionType notificationReceptionType, ExecutionContext executionContext) throws Exception {
    }
}

