/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.transaction.Isolation;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUID;
import com.liferay.portal.kernel.workflow.WorkflowDefinition;
import com.liferay.portal.kernel.workflow.WorkflowDefinitionFileException;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.kernel.workflow.WorkflowInstance;
import com.liferay.portal.workflow.kaleo.KaleoWorkflowModelConverter;
import com.liferay.portal.workflow.kaleo.definition.Definition;
import com.liferay.portal.workflow.kaleo.definition.deployment.WorkflowDeployer;
import com.liferay.portal.workflow.kaleo.definition.parser.WorkflowModelParser;
import com.liferay.portal.workflow.kaleo.definition.parser.WorkflowValidator;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinition;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinitionVersion;
import com.liferay.portal.workflow.kaleo.model.KaleoInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoTimerInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoTransition;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.KaleoSignaler;
import com.liferay.portal.workflow.kaleo.runtime.WorkflowEngine;
import com.liferay.portal.workflow.kaleo.runtime.internal.BaseKaleoBean;
import com.liferay.portal.workflow.kaleo.runtime.internal.node.NodeExecutorFactory;
import com.liferay.portal.workflow.kaleo.runtime.node.NodeExecutor;
import com.liferay.portal.workflow.kaleo.runtime.util.comparator.KaleoInstanceOrderByComparator;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Transactional(isolation=Isolation.PORTAL, propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
@Component(immediate=true, service={AopService.class})
public class DefaultWorkflowEngineImpl
extends BaseKaleoBean
implements AopService,
WorkflowEngine {
    @Reference
    protected PortalUUID portalUUID;
    private static final Log _log = LogFactoryUtil.getLog(DefaultWorkflowEngineImpl.class);
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private KaleoSignaler _kaleoSignaler;
    @Reference
    private KaleoWorkflowModelConverter _kaleoWorkflowModelConverter;
    @Reference
    private NodeExecutorFactory _nodeExecutorFactory;
    @Reference
    private WorkflowDeployer _workflowDeployer;
    @Reference
    private WorkflowModelParser _workflowModelParser;
    @Reference
    private WorkflowValidator _workflowValidator;

    public void deleteWorkflowDefinition(String name, int version, ServiceContext serviceContext) throws WorkflowException {
        try {
            KaleoDefinition kaleoDefinition = this.kaleoDefinitionLocalService.fetchKaleoDefinition(name, serviceContext);
            if (kaleoDefinition != null) {
                this.kaleoDefinitionLocalService.deleteKaleoDefinition(name, serviceContext);
            } else {
                this.kaleoDefinitionVersionLocalService.deleteKaleoDefinitionVersions(serviceContext.getCompanyId(), name);
            }
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public void deleteWorkflowInstance(long workflowInstanceId, ServiceContext serviceContext) throws WorkflowException {
        try {
            this.kaleoInstanceLocalService.deleteKaleoInstance(workflowInstanceId);
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    @Deprecated
    public WorkflowDefinition deployWorkflowDefinition(String title, InputStream inputStream, ServiceContext serviceContext) throws WorkflowException {
        Definition definition = this._workflowModelParser.parse(inputStream);
        return this.deployWorkflowDefinition(title, definition.getName(), inputStream, serviceContext);
    }

    public WorkflowDefinition deployWorkflowDefinition(String title, String name, InputStream inputStream, ServiceContext serviceContext) throws WorkflowException {
        try {
            Definition definition = this._workflowModelParser.parse(inputStream);
            if (this._workflowValidator != null) {
                this._workflowValidator.validate(definition);
            }
            String definitionName = this.getDefinitionName(definition, name);
            KaleoDefinition kaleoDefinition = this.kaleoDefinitionLocalService.fetchKaleoDefinition(definitionName, serviceContext);
            WorkflowDefinition workflowDefinition = this._workflowDeployer.deploy(title, definitionName, definition, serviceContext);
            if (kaleoDefinition != null) {
                List workflowDefinitionLinks = this.workflowDefinitionLinkLocalService.getWorkflowDefinitionLinks(serviceContext.getCompanyId(), kaleoDefinition.getName(), kaleoDefinition.getVersion());
                for (WorkflowDefinitionLink workflowDefinitionLink : workflowDefinitionLinks) {
                    workflowDefinitionLink.setWorkflowDefinitionVersion(workflowDefinition.getVersion());
                    this.workflowDefinitionLinkLocalService.updateWorkflowDefinitionLink(workflowDefinitionLink);
                }
            }
            return workflowDefinition;
        }
        catch (WorkflowException we) {
            throw we;
        }
        catch (PortalException pe) {
            throw new WorkflowException((Throwable)pe);
        }
    }

    public ExecutionContext executeTimerWorkflowInstance(long kaleoTimerInstanceTokenId, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws WorkflowException {
        try {
            KaleoTimerInstanceToken kaleoTimerInstanceToken = this.kaleoTimerInstanceTokenLocalService.getKaleoTimerInstanceToken(kaleoTimerInstanceTokenId);
            KaleoInstanceToken kaleoInstanceToken = kaleoTimerInstanceToken.getKaleoInstanceToken();
            final ExecutionContext executionContext = new ExecutionContext(kaleoInstanceToken, kaleoTimerInstanceToken, workflowContext, serviceContext);
            KaleoTaskInstanceToken kaleoTaskInstanceToken = kaleoTimerInstanceToken.getKaleoTaskInstanceToken();
            executionContext.setKaleoTaskInstanceToken(kaleoTaskInstanceToken);
            final KaleoNode currentKaleoNode = kaleoInstanceToken.getCurrentKaleoNode();
            NodeExecutor nodeExecutor = this._nodeExecutorFactory.getNodeExecutor(currentKaleoNode.getType());
            nodeExecutor.executeTimer(currentKaleoNode, executionContext);
            TransactionCommitCallbackUtil.registerCallback((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    DefaultWorkflowEngineImpl.this._kaleoSignaler.signalExecute(currentKaleoNode, executionContext);
                    return null;
                }
            });
            return executionContext;
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public List<String> getNextTransitionNames(long workflowInstanceId, ServiceContext serviceContext) throws WorkflowException {
        try {
            KaleoInstance kaleoInstance = this.kaleoInstanceLocalService.getKaleoInstance(workflowInstanceId);
            KaleoInstanceToken rootKaleoInstanceToken = kaleoInstance.getRootKaleoInstanceToken(null, serviceContext);
            ArrayList<String> transitionNames = new ArrayList<String>();
            this.getNextTransitionNames(rootKaleoInstanceToken, transitionNames);
            return transitionNames;
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public WorkflowInstance getWorkflowInstance(long workflowInstanceId, ServiceContext serviceContext) throws WorkflowException {
        try {
            KaleoInstance kaleoInstance = this.kaleoInstanceLocalService.getKaleoInstance(workflowInstanceId);
            KaleoInstanceToken rootKaleoInstanceToken = kaleoInstance.getRootKaleoInstanceToken(serviceContext);
            return this._kaleoWorkflowModelConverter.toWorkflowInstance(kaleoInstance, rootKaleoInstanceToken);
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public int getWorkflowInstanceCount(Long userId, String assetClassName, Long assetClassPK, Boolean completed, ServiceContext serviceContext) throws WorkflowException {
        try {
            return this.kaleoInstanceLocalService.getKaleoInstancesCount(userId, assetClassName, assetClassPK, completed, serviceContext);
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public int getWorkflowInstanceCount(Long userId, String[] assetClassNames, Boolean completed, ServiceContext serviceContext) throws WorkflowException {
        try {
            return this.kaleoInstanceLocalService.getKaleoInstancesCount(userId, assetClassNames, completed, serviceContext);
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public int getWorkflowInstanceCount(String workflowDefinitionName, int workflowDefinitionVersion, boolean completed, ServiceContext serviceContext) throws WorkflowException {
        try {
            return this.kaleoInstanceLocalService.getKaleoInstancesCount(workflowDefinitionName, workflowDefinitionVersion, completed, serviceContext);
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public List<WorkflowInstance> getWorkflowInstances(Long userId, String assetClassName, Long assetClassPK, Boolean completed, int start, int end, OrderByComparator<WorkflowInstance> orderByComparator, ServiceContext serviceContext) throws WorkflowException {
        try {
            List kaleoInstances = this.kaleoInstanceLocalService.getKaleoInstances(userId, assetClassName, assetClassPK, completed, start, end, KaleoInstanceOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter, (ServiceContext)serviceContext), serviceContext);
            return this.toWorkflowInstances(kaleoInstances, serviceContext);
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public List<WorkflowInstance> getWorkflowInstances(Long userId, String[] assetClassNames, Boolean completed, int start, int end, OrderByComparator<WorkflowInstance> orderByComparator, ServiceContext serviceContext) throws WorkflowException {
        try {
            List kaleoInstances = this.kaleoInstanceLocalService.getKaleoInstances(userId, assetClassNames, completed, start, end, KaleoInstanceOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter, (ServiceContext)serviceContext), serviceContext);
            return this.toWorkflowInstances(kaleoInstances, serviceContext);
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public List<WorkflowInstance> getWorkflowInstances(String workflowDefinitionName, int workflowDefinitionVersion, boolean completed, int start, int end, OrderByComparator<WorkflowInstance> orderByComparator, ServiceContext serviceContext) throws WorkflowException {
        try {
            List kaleoInstances = this.kaleoInstanceLocalService.getKaleoInstances(workflowDefinitionName, workflowDefinitionVersion, completed, start, end, KaleoInstanceOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter, (ServiceContext)serviceContext), serviceContext);
            return this.toWorkflowInstances(kaleoInstances, serviceContext);
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public WorkflowDefinition saveWorkflowDefinition(String title, String name, byte[] bytes, ServiceContext serviceContext) throws WorkflowException {
        try {
            Definition definition = this.getDefinition(bytes);
            String definitionName = this._getDefinitionName(definition, name, serviceContext);
            return this._workflowDeployer.save(title, definitionName, definition, serviceContext);
        }
        catch (PortalException pe) {
            throw new WorkflowException((Throwable)pe);
        }
    }

    @Deprecated
    public List<WorkflowInstance> search(Long userId, String assetClassName, String nodeName, String kaleoDefinitionName, Boolean completed, int start, int end, OrderByComparator<WorkflowInstance> orderByComparator, ServiceContext serviceContext) throws WorkflowException {
        return this.search(userId, assetClassName, null, null, nodeName, kaleoDefinitionName, completed, start, end, orderByComparator, serviceContext);
    }

    public List<WorkflowInstance> search(Long userId, String assetClassName, String assetTitle, String assetDescription, String nodeName, String kaleoDefinitionName, Boolean completed, int start, int end, OrderByComparator<WorkflowInstance> orderByComparator, ServiceContext serviceContext) throws WorkflowException {
        try {
            List kaleoInstances = this.kaleoInstanceLocalService.search(userId, assetClassName, assetTitle, assetDescription, nodeName, kaleoDefinitionName, completed, start, end, KaleoInstanceOrderByComparator.getOrderByComparator(orderByComparator, (KaleoWorkflowModelConverter)this._kaleoWorkflowModelConverter, (ServiceContext)serviceContext), serviceContext);
            return this.toWorkflowInstances(kaleoInstances, serviceContext);
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    @Deprecated
    public int searchCount(Long userId, String assetClassName, String nodeName, String kaleoDefinitionName, Boolean completed, ServiceContext serviceContext) throws WorkflowException {
        return this.searchCount(userId, assetClassName, null, null, nodeName, kaleoDefinitionName, completed, serviceContext);
    }

    public int searchCount(Long userId, String assetClassName, String assetTitle, String assetDescription, String nodeName, String kaleoDefinitionName, Boolean completed, ServiceContext serviceContext) throws WorkflowException {
        try {
            return this.kaleoInstanceLocalService.searchCount(userId, assetClassName, assetTitle, assetDescription, nodeName, kaleoDefinitionName, completed, serviceContext);
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public WorkflowInstance signalWorkflowInstance(long workflowInstanceId, final String transitionName, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws WorkflowException {
        try {
            KaleoInstance kaleoInstance = this.doUpdateContext(workflowInstanceId, workflowContext, serviceContext);
            KaleoInstanceToken kaleoInstanceToken = kaleoInstance.getRootKaleoInstanceToken(serviceContext);
            if (Validator.isNotNull((String)transitionName)) {
                KaleoNode currentKaleoNode = kaleoInstanceToken.getCurrentKaleoNode();
                currentKaleoNode.getKaleoTransition(transitionName);
            }
            serviceContext.setScopeGroupId(kaleoInstanceToken.getGroupId());
            final ExecutionContext executionContext = new ExecutionContext(kaleoInstanceToken, workflowContext, serviceContext);
            TransactionCommitCallbackUtil.registerCallback((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        DefaultWorkflowEngineImpl.this._kaleoSignaler.signalExit(transitionName, executionContext);
                    }
                    catch (Exception e) {
                        throw new WorkflowException("Unable to signal next transition", (Throwable)e);
                    }
                    return null;
                }
            });
            return this._kaleoWorkflowModelConverter.toWorkflowInstance(kaleoInstance, kaleoInstanceToken, workflowContext);
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public WorkflowInstance startWorkflowInstance(String workflowDefinitionName, Integer workflowDefinitionVersion, final String transitionName, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws WorkflowException {
        try {
            Group group;
            long scopeGroupId;
            KaleoDefinition kaleoDefinition = this.kaleoDefinitionLocalService.getKaleoDefinition(workflowDefinitionName, serviceContext);
            if (!kaleoDefinition.isActive()) {
                throw new WorkflowException(StringBundler.concat((Object[])new Object[]{"Inactive workflow definition with name ", workflowDefinitionName, " and version ", workflowDefinitionVersion}));
            }
            KaleoDefinitionVersion kaleoDefinitionVersion = this.kaleoDefinitionVersionLocalService.getKaleoDefinitionVersion(serviceContext.getCompanyId(), workflowDefinitionName, this.getVersion(workflowDefinitionVersion));
            KaleoNode kaleoStartNode = kaleoDefinitionVersion.getKaleoStartNode();
            if (Validator.isNotNull((String)transitionName)) {
                kaleoStartNode.getKaleoTransition(transitionName);
            }
            if ((scopeGroupId = serviceContext.getScopeGroupId()) != 0L && (group = this._groupLocalService.getGroup(scopeGroupId)).isLayout()) {
                group = this._groupLocalService.getGroup(group.getParentGroupId());
                serviceContext.setScopeGroupId(group.getGroupId());
            }
            KaleoInstance kaleoInstance = this.kaleoInstanceLocalService.addKaleoInstance(kaleoDefinitionVersion.getKaleoDefinitionVersionId(), kaleoDefinitionVersion.getName(), this.getVersion(kaleoDefinitionVersion.getVersion()), workflowContext, serviceContext);
            KaleoInstanceToken rootKaleoInstanceToken = kaleoInstance.getRootKaleoInstanceToken(workflowContext, serviceContext);
            rootKaleoInstanceToken.setCurrentKaleoNode(kaleoStartNode);
            this.kaleoLogLocalService.addWorkflowInstanceStartKaleoLog(rootKaleoInstanceToken, serviceContext);
            final ExecutionContext executionContext = new ExecutionContext(rootKaleoInstanceToken, workflowContext, serviceContext);
            TransactionCommitCallbackUtil.registerCallback((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        DefaultWorkflowEngineImpl.this._kaleoSignaler.signalEntry(transitionName, executionContext);
                    }
                    catch (Exception e) {
                        throw new WorkflowException("Unable to start workflow", (Throwable)e);
                    }
                    return null;
                }
            });
            return this._kaleoWorkflowModelConverter.toWorkflowInstance(kaleoInstance, rootKaleoInstanceToken, workflowContext);
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public WorkflowInstance updateContext(long workflowInstanceId, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws WorkflowException {
        try {
            KaleoInstance kaleoInstance = this.doUpdateContext(workflowInstanceId, workflowContext, serviceContext);
            KaleoInstanceToken rootKaleoInstanceToken = kaleoInstance.getRootKaleoInstanceToken(serviceContext);
            return this._kaleoWorkflowModelConverter.toWorkflowInstance(kaleoInstance, rootKaleoInstanceToken);
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    public void validateWorkflowDefinition(InputStream inputStream) throws WorkflowException {
        try {
            if (this._workflowValidator != null) {
                Definition definition = this._workflowModelParser.parse(inputStream);
                this._workflowValidator.validate(definition);
            }
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    protected KaleoInstance doUpdateContext(long workflowInstanceId, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws Exception {
        return this.kaleoInstanceLocalService.updateKaleoInstance(workflowInstanceId, workflowContext, serviceContext);
    }

    protected Definition getDefinition(byte[] bytes) throws WorkflowException {
        try {
            this._workflowModelParser.setValidate(false);
            Definition definition = this._workflowModelParser.parse((InputStream)new UnsyncByteArrayInputStream(bytes));
            return definition;
        }
        catch (WorkflowDefinitionFileException wdfe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)wdfe, (Throwable)wdfe);
            }
            try {
                Definition definition = new Definition("", "", new String(bytes, "UTF-8"), 0);
                return definition;
            }
            catch (UnsupportedEncodingException uee) {
                throw new WorkflowException((Throwable)uee);
            }
        }
        catch (WorkflowException we) {
            throw new WorkflowException((Throwable)we);
        }
        finally {
            this._workflowModelParser.setValidate(true);
        }
    }

    protected String getDefinitionName(Definition definition, String name) {
        if (Validator.isNotNull((String)name)) {
            return name;
        }
        if (Validator.isNotNull((String)definition.getName())) {
            return definition.getName();
        }
        return this.portalUUID.generate();
    }

    protected void getNextTransitionNames(KaleoInstanceToken kaleoInstanceToken, List<String> transitionNames) throws Exception {
        if (kaleoInstanceToken.hasIncompleteChildrenKaleoInstanceToken()) {
            List incompleteChildrenKaleoInstanceTokens = kaleoInstanceToken.getIncompleteChildrenKaleoInstanceTokens();
            for (KaleoInstanceToken incompleteChildrenKaleoInstanceToken : incompleteChildrenKaleoInstanceTokens) {
                this.getNextTransitionNames(incompleteChildrenKaleoInstanceToken, transitionNames);
            }
        } else {
            KaleoNode kaleoNode = kaleoInstanceToken.getCurrentKaleoNode();
            List kaleoTransitions = kaleoNode.getKaleoTransitions();
            for (KaleoTransition kaleoTransition : kaleoTransitions) {
                transitionNames.add(kaleoTransition.getName());
            }
        }
    }

    protected String getVersion(int version) {
        return version + "." + 0;
    }

    protected int getVersion(String version) {
        int[] versionParts = StringUtil.split((String)version, (String)".", (int)0);
        return versionParts[0];
    }

    protected List<WorkflowInstance> toWorkflowInstances(List<KaleoInstance> kaleoInstances, ServiceContext serviceContext) throws PortalException {
        ArrayList<WorkflowInstance> workflowInstances = new ArrayList<WorkflowInstance>(kaleoInstances.size());
        for (KaleoInstance kaleoInstance : kaleoInstances) {
            KaleoInstanceToken rootKaleoInstanceToken = kaleoInstance.getRootKaleoInstanceToken(serviceContext);
            workflowInstances.add(this._kaleoWorkflowModelConverter.toWorkflowInstance(kaleoInstance, rootKaleoInstanceToken));
        }
        return workflowInstances;
    }

    private String _getDefinitionName(Definition definition, String name, ServiceContext serviceContext) {
        if (Validator.isNotNull((String)name)) {
            return name;
        }
        if (Validator.isNotNull((String)definition.getName())) {
            KaleoDefinition kaleoDefinition = this.kaleoDefinitionLocalService.fetchKaleoDefinition(definition.getName(), serviceContext);
            if (kaleoDefinition != null && kaleoDefinition.isActive()) {
                return this.portalUUID.generate();
            }
            return definition.getName();
        }
        return this.portalUUID.generate();
    }
}

