/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.internal.manager;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.workflow.WorkflowDefinition;
import com.liferay.portal.kernel.workflow.WorkflowDefinitionManager;
import com.liferay.portal.kernel.workflow.comparator.WorkflowComparatorFactory;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.portal.workflow.kaleo.runtime.internal.BaseKaleoBean;
import com.liferay.portal.workflow.kaleo.runtime.manager.PortalKaleoManager;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DefaultPortalKaleoManager
extends BaseKaleoBean
implements PortalKaleoManager {
    @ServiceReference(type=CompanyLocalService.class)
    protected CompanyLocalService companyLocalService;
    @ServiceReference(type=GroupLocalService.class)
    protected GroupLocalService groupLocalService;
    @ServiceReference(type=RoleLocalService.class)
    protected RoleLocalService roleLocalService;
    @ServiceReference(type=UserLocalService.class)
    protected UserLocalService userLocalService;
    @ServiceReference(filterString="(proxy.bean=false)", type=WorkflowComparatorFactory.class)
    protected WorkflowComparatorFactory workflowComparatorFactory;
    @ServiceReference(type=WorkflowDefinitionLinkLocalService.class)
    protected WorkflowDefinitionLinkLocalService workflowDefinitionLinkLocalService;
    private static final Log _log = LogFactoryUtil.getLog(DefaultPortalKaleoManager.class);
    private String _defaultDefinitionName;
    private final Map<String, String> _defaultRoles = new HashMap<String, String>();
    private final Map<String, String> _definitionAssets = new HashMap<String, String>();
    private final Map<String, String> _definitionFiles = new HashMap<String, String>();
    @ServiceReference(filterString="(proxy.bean=false)", type=WorkflowDefinitionManager.class)
    private WorkflowDefinitionManager _workflowDefinitionManager;

    public void deleteKaleoData(long companyId) throws Exception {
        this.kaleoDefinitionLocalService.deleteCompanyKaleoDefinitions(companyId);
        this.kaleoLogLocalService.deleteCompanyKaleoLogs(companyId);
    }

    public void deployDefaultDefinitionLink(String assetClassName) throws Exception {
        List companies = this.companyLocalService.getCompanies();
        for (Company company : companies) {
            long companyId = company.getCompanyId();
            User defaultUser = this.userLocalService.getDefaultUser(companyId);
            Group companyGroup = this.groupLocalService.getCompanyGroup(companyId);
            String definitionName = this._defaultDefinitionName;
            if (this._definitionAssets.containsKey(assetClassName)) {
                definitionName = this._definitionAssets.get(assetClassName);
            }
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            this.deployDefaultDefinitionLink(defaultUser, companyId, companyGroup, assetClassName, definitionName);
        }
    }

    public void deployDefaultDefinitionLinks() throws Exception {
        List companies = this.companyLocalService.getCompanies(false);
        for (Company company : companies) {
            this.deployDefaultDefinitionLinks(company.getCompanyId());
        }
    }

    public void deployDefaultDefinitionLinks(long companyId) throws Exception {
        User defaultUser = this.userLocalService.getDefaultUser(companyId);
        Group companyGroup = this.groupLocalService.getCompanyGroup(companyId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(companyId);
        for (Map.Entry<String, String> entry : this._definitionAssets.entrySet()) {
            String assetClassName = entry.getKey();
            String definitionName = entry.getValue();
            this.deployDefaultDefinitionLink(defaultUser, companyId, companyGroup, assetClassName, definitionName);
        }
    }

    public void deployDefaultDefinitions() throws Exception {
        List companies = this.companyLocalService.getCompanies();
        for (Company company : companies) {
            this.deployDefaultDefinitions(company.getCompanyId());
        }
    }

    public void deployDefaultDefinitions(long companyId) throws Exception {
        for (Map.Entry<String, String> entry : this._definitionFiles.entrySet()) {
            String fileName;
            String definitionName = entry.getKey();
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCompanyId(companyId);
            int kaleoDefinitionsCount = this.kaleoDefinitionLocalService.getKaleoDefinitionsCount(definitionName, serviceContext);
            if (kaleoDefinitionsCount > 0) {
                return;
            }
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream(fileName = entry.getValue());
            if (inputStream == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to find definition file for ", definitionName, " with file name ", fileName}));
                }
                return;
            }
            User defaultUser = this.userLocalService.getDefaultUser(companyId);
            String localizedTitle = LocalizationUtil.updateLocalization((String)"", (String)"title", (String)definitionName, (String)LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault()));
            this._workflowDefinitionManager.deployWorkflowDefinition(serviceContext.getCompanyId(), defaultUser.getUserId(), localizedTitle, definitionName, FileUtil.getBytes((InputStream)inputStream));
        }
    }

    public void deployDefaultRoles() throws Exception {
        List companies = this.companyLocalService.getCompanies();
        for (Company company : companies) {
            this.deployDefaultRoles(company.getCompanyId());
        }
    }

    public void deployDefaultRoles(long companyId) throws Exception {
        User defaultUser = this.userLocalService.getDefaultUser(companyId);
        for (Map.Entry<String, String> entry : this._defaultRoles.entrySet()) {
            String name = entry.getKey();
            Role role = this.roleLocalService.fetchRole(companyId, name);
            if (role != null) continue;
            HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
            descriptionMap.put(LocaleUtil.getDefault(), entry.getValue());
            this.roleLocalService.addRole(defaultUser.getUserId(), null, 0L, name, null, descriptionMap, 1, null, null);
        }
    }

    public void deployKaleoDefaults() throws Exception {
        this.deployDefaultRoles();
        this.deployDefaultDefinitions();
        this.deployDefaultDefinitionLinks();
    }

    public void deployKaleoDefaults(long companyId) throws Exception {
        this.deployDefaultRoles(companyId);
        this.deployDefaultDefinitions(companyId);
        this.deployDefaultDefinitionLinks(companyId);
    }

    public void setDefaultDefinitionName(String defaultDefinitionName) {
        this._defaultDefinitionName = defaultDefinitionName;
    }

    public void setDefaultRoles(Map<String, String> defaultRoles) {
        this._defaultRoles.putAll(defaultRoles);
    }

    public void setDefinitionAssets(Map<String, String> definitionAssets) {
        this._definitionAssets.putAll(definitionAssets);
    }

    public void setDefinitionFiles(Map<String, String> definitionFiles) {
        this._definitionFiles.putAll(definitionFiles);
    }

    protected void deployDefaultDefinitionLink(User defaultUser, long companyId, Group companyGroup, String assetClassName, String workflowDefinitionName) throws PortalException {
        WorkflowDefinitionLink workflowDefinitionLink = this.workflowDefinitionLinkLocalService.fetchDefaultWorkflowDefinitionLink(companyId, assetClassName, 0L, 0L);
        if (workflowDefinitionLink != null) {
            return;
        }
        List workflowDefinitions = this._workflowDefinitionManager.getActiveWorkflowDefinitions(companyId, workflowDefinitionName, 0, 20, this.workflowComparatorFactory.getDefinitionNameComparator(false));
        if (workflowDefinitions.isEmpty()) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No workflow definitions found for " + workflowDefinitionName));
            }
            return;
        }
        WorkflowDefinition workflowDefinition = (WorkflowDefinition)workflowDefinitions.get(0);
        this.workflowDefinitionLinkLocalService.addWorkflowDefinitionLink(defaultUser.getUserId(), companyId, companyGroup.getGroupId(), assetClassName, 0L, 0L, workflowDefinition.getName(), workflowDefinition.getVersion());
    }
}

