/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition.internal.parser;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.definition.Definition;
import com.liferay.portal.workflow.kaleo.definition.Task;
import com.liferay.portal.workflow.kaleo.definition.TaskForm;
import com.liferay.portal.workflow.kaleo.definition.TaskFormReference;
import com.liferay.portal.workflow.kaleo.definition.Transition;
import com.liferay.portal.workflow.kaleo.definition.exception.KaleoDefinitionValidationException;
import com.liferay.portal.workflow.kaleo.definition.internal.parser.BaseNodeValidator;
import com.liferay.portal.workflow.kaleo.definition.parser.NodeValidator;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;

@Component(property={"node.type=TASK"}, service={NodeValidator.class})
public class TaskNodeValidator
extends BaseNodeValidator<Task> {
    @Override
    protected void doValidate(Definition definition, Task task) throws KaleoDefinitionValidationException {
        List defaultTransitions;
        if (task.getIncomingTransitionsCount() == 0) {
            throw new KaleoDefinitionValidationException.MustSetIncomingTransition(task.getDefaultLabel());
        }
        if (task.getOutgoingTransitionsCount() == 0) {
            throw new KaleoDefinitionValidationException.MustSetOutgoingTransition(task.getDefaultLabel());
        }
        Set assignments = task.getAssignments();
        if (assignments == null || assignments.isEmpty()) {
            throw new KaleoDefinitionValidationException.MustSetAssignments(task.getDefaultLabel());
        }
        Set taskForms = task.getTaskForms();
        for (TaskForm taskForm : taskForms) {
            String formDefinition = taskForm.getFormDefinition();
            TaskFormReference taskFormReference = taskForm.getTaskFormReference();
            if (!Validator.isNull((String)formDefinition) && taskFormReference != null) continue;
            throw new KaleoDefinitionValidationException.MustSetTaskFormDefinitionOrReference(task.getDefaultLabel(), taskForm.getName());
        }
        Map outgoingTransitions = task.getOutgoingTransitions();
        if (outgoingTransitions.size() > 1 && (defaultTransitions = Stream.of(outgoingTransitions.values()).flatMap(Collection::stream).filter(Transition::isDefault).collect(Collectors.toList())).size() > 1) {
            throw new KaleoDefinitionValidationException.MustNotSetMoreThanOneDefaultTransition(task.getDefaultLabel());
        }
    }
}

