/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition.internal.parser;

import com.liferay.portal.workflow.kaleo.definition.Definition;
import com.liferay.portal.workflow.kaleo.definition.Fork;
import com.liferay.portal.workflow.kaleo.definition.Join;
import com.liferay.portal.workflow.kaleo.definition.Node;
import com.liferay.portal.workflow.kaleo.definition.NodeType;
import com.liferay.portal.workflow.kaleo.definition.Transition;
import com.liferay.portal.workflow.kaleo.definition.exception.KaleoDefinitionValidationException;
import com.liferay.portal.workflow.kaleo.definition.internal.parser.BaseNodeValidator;
import com.liferay.portal.workflow.kaleo.definition.parser.NodeValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;

@Component(property={"node.type=FORK"}, service={NodeValidator.class})
public class ForkNodeValidator
extends BaseNodeValidator<Fork> {
    @Override
    protected void doValidate(Definition definition, Fork fork) throws KaleoDefinitionValidationException {
        if (fork.getIncomingTransitionsCount() == 0) {
            throw new KaleoDefinitionValidationException.MustSetIncomingTransition(fork.getDefaultLabel());
        }
        if (fork.getOutgoingTransitionsCount() < 2) {
            throw new KaleoDefinitionValidationException.MustSetMultipleOutgoingTransition(fork.getDefaultLabel());
        }
        this._traverse(fork);
    }

    private List<Node> _getUnvisitedNodes(List<Node> nodes, Collection<Transition> transitions, boolean target) {
        ArrayList<Node> unvisitedNodes = new ArrayList<Node>();
        for (Transition transition : transitions) {
            Node node = transition.getSourceNode();
            if (target) {
                node = transition.getTargetNode();
            }
            if (nodes.contains(node)) continue;
            unvisitedNodes.add(node);
        }
        return unvisitedNodes;
    }

    private void _reverseTraverse(Fork fork, Join join, List<Node> targetNodes, Map<Join, Fork> joinForkMap) throws KaleoDefinitionValidationException {
        ArrayList<Node> sourceNodes = new ArrayList<Node>();
        sourceNodes.add((Node)join);
        for (Transition transition : join.getIncomingTransitions()) {
            sourceNodes.add(transition.getSourceNode());
        }
        for (int i = 1; i < sourceNodes.size(); ++i) {
            Node sourceNode = (Node)sourceNodes.get(i);
            NodeType nodeType = sourceNode.getNodeType();
            if (nodeType.equals((Object)NodeType.FORK) && Objects.equals(fork, sourceNode)) continue;
            if (nodeType.equals((Object)NodeType.JOIN) || nodeType.equals((Object)NodeType.JOIN_XOR)) {
                sourceNode = (Node)joinForkMap.get(sourceNode);
                sourceNodes.set(i, sourceNode);
            }
            List<Node> unvisitedSourceNodes = this._getUnvisitedNodes(sourceNodes, sourceNode.getIncomingTransitions(), false);
            sourceNodes.addAll(unvisitedSourceNodes);
        }
        if (sourceNodes.size() != targetNodes.size() || !sourceNodes.containsAll(targetNodes)) {
            throw new KaleoDefinitionValidationException.UnbalancedForkAndJoinNode(fork.getDefaultLabel(), join.getDefaultLabel());
        }
    }

    private Join _traverse(Fork fork) throws KaleoDefinitionValidationException {
        Join join = null;
        ArrayList<Node> targetNodes = new ArrayList<Node>();
        HashMap<Join, Fork> joinForkMap = new HashMap<Join, Fork>();
        targetNodes.add((Node)fork);
        for (Transition transition : fork.getOutgoingTransitionsList()) {
            targetNodes.add(transition.getTargetNode());
        }
        for (int i = 1; i < targetNodes.size(); ++i) {
            Node targetNode = (Node)targetNodes.get(i);
            NodeType nodeType = targetNode.getNodeType();
            if (nodeType.equals((Object)NodeType.FORK)) {
                Join localJoin = this._traverse((Fork)targetNode);
                joinForkMap.put(localJoin, (Fork)targetNode);
                List<Node> unvisitedTargetNodes = this._getUnvisitedNodes(targetNodes, localJoin.getOutgoingTransitionsList(), true);
                targetNodes.addAll(unvisitedTargetNodes);
                continue;
            }
            if (nodeType.equals((Object)NodeType.JOIN) || nodeType.equals((Object)NodeType.JOIN_XOR)) {
                if (join == null) {
                    join = (Join)targetNode;
                    continue;
                }
                if (Objects.equals(join, targetNode)) continue;
                throw new KaleoDefinitionValidationException.MustPairedForkAndJoinNodes(fork.getDefaultLabel(), targetNode.getDefaultLabel());
            }
            List<Node> unvisitedTargetNodes = this._getUnvisitedNodes(targetNodes, targetNode.getOutgoingTransitionsList(), true);
            targetNodes.addAll(unvisitedTargetNodes);
        }
        if (join == null) {
            throw new KaleoDefinitionValidationException.MustSetJoinNode(fork.getDefaultLabel());
        }
        this._reverseTraverse(fork, join, targetNodes, joinForkMap);
        return join;
    }
}

