/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition.internal.parser;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.definition.Definition;
import com.liferay.portal.workflow.kaleo.definition.Node;
import com.liferay.portal.workflow.kaleo.definition.Transition;
import com.liferay.portal.workflow.kaleo.definition.exception.KaleoDefinitionValidationException;
import com.liferay.portal.workflow.kaleo.definition.parser.NodeValidator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public abstract class BaseNodeValidator<T extends Node>
implements NodeValidator<T> {
    private static final int _NODE_VALUE_MAX_LENGTH = 200;

    public void validate(Definition definition, T node) throws KaleoDefinitionValidationException {
        this.doValidate(definition, node);
        this._validateLabel(node);
        this._validateName(node);
        this._validateNotifications(node);
        this._validateTransitions(node.getOutgoingTransitions());
    }

    protected abstract void doValidate(Definition var1, T var2) throws KaleoDefinitionValidationException;

    private void _validateLabel(T node) throws KaleoDefinitionValidationException {
        Map labelMap = node.getLabelMap();
        if (labelMap == null) {
            return;
        }
        for (Map.Entry entry : labelMap.entrySet()) {
            String value = (String)entry.getValue();
            if (value.length() <= 200) continue;
            throw new KaleoDefinitionValidationException.MustSetValidNodeNameLength(200, value);
        }
    }

    private void _validateName(T node) throws KaleoDefinitionValidationException {
        String name = node.getName();
        if (name.length() > 200) {
            throw new KaleoDefinitionValidationException.MustSetValidNodeNameLength(200, name);
        }
    }

    private void _validateNotifications(T node) throws KaleoDefinitionValidationException {
        Set notifications = node.getNotifications();
        Stream notificationsStream = notifications.stream();
        if (notificationsStream.anyMatch(notification -> Validator.isNull((String)notification.getTemplate()))) {
            throw new KaleoDefinitionValidationException.EmptyNotificationTemplate(node.getDefaultLabel());
        }
    }

    private void _validateTransition(Transition transition) throws KaleoDefinitionValidationException {
        if (transition.getTargetNode() == null) {
            throw new KaleoDefinitionValidationException.MustSetTargetNode(transition.getName());
        }
    }

    private void _validateTransitions(Map<String, Transition> transitions) throws KaleoDefinitionValidationException {
        for (Transition transition : transitions.values()) {
            this._validateTransition(transition);
        }
    }
}

