/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition.internal.export.builder;

import com.liferay.portal.workflow.kaleo.definition.Node;
import com.liferay.portal.workflow.kaleo.definition.NodeTypeDependentObjectRegistry;
import com.liferay.portal.workflow.kaleo.definition.exception.KaleoDefinitionValidationException;
import com.liferay.portal.workflow.kaleo.definition.internal.export.builder.NodeBuilder;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={NodeBuilderRegistry.class})
public class NodeBuilderRegistry {
    private final NodeTypeDependentObjectRegistry<NodeBuilder<Node>> _nodeBuilders = new NodeTypeDependentObjectRegistry();

    public NodeBuilder<Node> getNodeBuilder(String nodeTypeString) throws KaleoDefinitionValidationException {
        return (NodeBuilder)this._nodeBuilders.getNodeTypeDependentObjects(nodeTypeString);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addNodeValidator(NodeBuilder<Node> nodeBuilder, Map<String, Object> properties) {
        String nodeType = (String)properties.get("node.type");
        if (nodeType == null) {
            throw new IllegalArgumentException("The property \"node.type\" is null");
        }
        this._nodeBuilders.addNodeTypeDependentObject(nodeType, nodeBuilder);
    }

    protected void removeNodeValidator(NodeBuilder<Node> nodeBuilder, Map<String, Object> properties) {
        String nodeType = (String)properties.get("node.type");
        if (nodeType == null) {
            throw new IllegalArgumentException("The property \"node.type\" is null");
        }
        this._nodeBuilders.removeNodeTypeDependentObjects(nodeType);
    }
}

