/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition.internal.deployment;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.workflow.WorkflowDefinition;
import com.liferay.portal.workflow.configuration.WorkflowDefinitionConfiguration;
import com.liferay.portal.workflow.kaleo.KaleoWorkflowModelConverter;
import com.liferay.portal.workflow.kaleo.definition.Condition;
import com.liferay.portal.workflow.kaleo.definition.Definition;
import com.liferay.portal.workflow.kaleo.definition.Node;
import com.liferay.portal.workflow.kaleo.definition.NodeType;
import com.liferay.portal.workflow.kaleo.definition.State;
import com.liferay.portal.workflow.kaleo.definition.Task;
import com.liferay.portal.workflow.kaleo.definition.Transition;
import com.liferay.portal.workflow.kaleo.definition.deployment.WorkflowDeployer;
import com.liferay.portal.workflow.kaleo.definition.exception.KaleoDefinitionValidationException;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinition;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinitionVersion;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.service.KaleoConditionLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoDefinitionLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoDefinitionVersionLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoNodeLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTransitionLocalService;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.workflow.configuration.WorkflowDefinitionConfiguration"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, service={WorkflowDeployer.class})
public class DefaultWorkflowDeployer
implements WorkflowDeployer {
    private boolean _companyAdministratorCanPublish;
    @Reference
    private KaleoConditionLocalService _kaleoConditionLocalService;
    @Reference
    private KaleoDefinitionLocalService _kaleoDefinitionLocalService;
    @Reference
    private KaleoDefinitionVersionLocalService _kaleoDefinitionVersionLocalService;
    @Reference
    private KaleoNodeLocalService _kaleoNodeLocalService;
    @Reference
    private KaleoTaskLocalService _kaleoTaskLocalService;
    @Reference
    private KaleoTransitionLocalService _kaleoTransitionLocalService;
    @Reference
    private KaleoWorkflowModelConverter _kaleoWorkflowModelConverter;

    @Deprecated
    public WorkflowDefinition deploy(String title, Definition definition, ServiceContext serviceContext) throws PortalException {
        return this.deploy(title, definition.getName(), definition, serviceContext);
    }

    public WorkflowDefinition deploy(String title, String name, Definition definition, ServiceContext serviceContext) throws PortalException {
        KaleoNode kaleoNode;
        this.checkPermissions();
        KaleoDefinition kaleoDefinition = this._addOrUpdateKaleoDefinition(title, name, definition, serviceContext);
        KaleoDefinitionVersion kaleoDefinitionVersion = this._kaleoDefinitionVersionLocalService.fetchLatestKaleoDefinitionVersion(kaleoDefinition.getCompanyId(), kaleoDefinition.getName());
        long kaleoDefinitionVersionId = kaleoDefinitionVersion.getKaleoDefinitionVersionId();
        Collection nodes = definition.getNodes();
        HashMap<String, KaleoNode> kaleoNodesMap = new HashMap<String, KaleoNode>();
        for (Node node : nodes) {
            kaleoNode = this._kaleoNodeLocalService.addKaleoNode(kaleoDefinitionVersionId, node, serviceContext);
            kaleoNodesMap.put(node.getName(), kaleoNode);
            NodeType nodeType = node.getNodeType();
            if (nodeType.equals((Object)NodeType.TASK)) {
                Task task = (Task)node;
                this._kaleoTaskLocalService.addKaleoTask(kaleoDefinitionVersionId, kaleoNode.getKaleoNodeId(), task, serviceContext);
                continue;
            }
            if (!nodeType.equals((Object)NodeType.CONDITION)) continue;
            Condition condition = (Condition)node;
            this._kaleoConditionLocalService.addKaleoCondition(kaleoDefinitionVersionId, kaleoNode.getKaleoNodeId(), condition, serviceContext);
        }
        for (Node node : nodes) {
            kaleoNode = (KaleoNode)kaleoNodesMap.get(node.getName());
            for (Transition transition : node.getOutgoingTransitionsList()) {
                Node sourceNode = transition.getSourceNode();
                KaleoNode sourceKaleoNode = (KaleoNode)kaleoNodesMap.get(sourceNode.getName());
                if (sourceKaleoNode == null) {
                    throw new KaleoDefinitionValidationException.MustSetSourceNode(sourceNode.getName());
                }
                Node targetNode = transition.getTargetNode();
                KaleoNode targetKaleoNode = (KaleoNode)kaleoNodesMap.get(targetNode.getName());
                if (targetKaleoNode == null) {
                    throw new KaleoDefinitionValidationException.MustSetTargetNode(targetNode.getName());
                }
                this._kaleoTransitionLocalService.addKaleoTransition(kaleoNode.getKaleoDefinitionVersionId(), kaleoNode.getKaleoNodeId(), transition, sourceKaleoNode, targetKaleoNode, serviceContext);
            }
        }
        State initialState = definition.getInitialState();
        if (initialState == null) {
            throw new KaleoDefinitionValidationException.MustSetInitialStateNode();
        }
        String startKaleoNodeName = initialState.getName();
        kaleoNode = (KaleoNode)kaleoNodesMap.get(startKaleoNodeName);
        long kaleoDefinitionId = kaleoDefinition.getKaleoDefinitionId();
        this._kaleoDefinitionLocalService.activateKaleoDefinition(kaleoDefinitionId, kaleoDefinitionVersionId, kaleoNode.getKaleoNodeId(), serviceContext);
        return this._kaleoWorkflowModelConverter.toWorkflowDefinition(kaleoDefinition);
    }

    public WorkflowDefinition save(String title, String name, Definition definition, ServiceContext serviceContext) throws PortalException {
        KaleoDefinition kaleoDefinition = this._addOrUpdateKaleoDefinition(title, name, definition, serviceContext);
        return this._kaleoWorkflowModelConverter.toWorkflowDefinition(kaleoDefinition);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        WorkflowDefinitionConfiguration workflowDefinitionConfiguration = (WorkflowDefinitionConfiguration)ConfigurableUtil.createConfigurable(WorkflowDefinitionConfiguration.class, properties);
        this._companyAdministratorCanPublish = workflowDefinitionConfiguration.companyAdministratorCanPublish();
    }

    protected void checkPermissions() throws PrincipalException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker == null) {
            return;
        }
        if (!permissionChecker.isCompanyAdmin()) {
            throw new PrincipalException.MustBeCompanyAdmin(permissionChecker.getUserId());
        }
        if (this._companyAdministratorCanPublish) {
            return;
        }
        if (!permissionChecker.isOmniadmin()) {
            throw new PrincipalException.MustBeOmniadmin(permissionChecker.getUserId());
        }
    }

    private KaleoDefinition _addOrUpdateKaleoDefinition(String title, String name, Definition definition, ServiceContext serviceContext) throws PortalException {
        KaleoDefinition kaleoDefinition = this._kaleoDefinitionLocalService.fetchKaleoDefinition(name, serviceContext);
        kaleoDefinition = kaleoDefinition == null ? this._kaleoDefinitionLocalService.addKaleoDefinition(name, title, definition.getDescription(), definition.getContent(), 1, serviceContext) : this._kaleoDefinitionLocalService.updatedKaleoDefinition(kaleoDefinition.getKaleoDefinitionId(), title, definition.getDescription(), definition.getContent(), serviceContext);
        return kaleoDefinition;
    }
}

