/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition.internal.parser;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.definition.Definition;
import com.liferay.portal.workflow.kaleo.definition.Node;
import com.liferay.portal.workflow.kaleo.definition.Transition;
import com.liferay.portal.workflow.kaleo.definition.exception.KaleoDefinitionValidationException;
import com.liferay.portal.workflow.kaleo.definition.parser.NodeValidator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public abstract class BaseNodeValidator<T extends Node>
implements NodeValidator<T> {
    public void validate(Definition definition, T node) throws KaleoDefinitionValidationException {
        this.doValidate(definition, node);
        this.validateTransitions(node.getOutgoingTransitions());
        this.validateNotifications(node);
    }

    protected abstract void doValidate(Definition var1, T var2) throws KaleoDefinitionValidationException;

    protected void validateNotifications(T node) throws KaleoDefinitionValidationException {
        Set notifications = node.getNotifications();
        Stream notificationsStream = notifications.stream();
        if (notificationsStream.anyMatch(notification -> Validator.isNull((String)notification.getTemplate()))) {
            throw new KaleoDefinitionValidationException.EmptyNotificationTemplate(node.getName());
        }
    }

    protected void validateTransition(Transition transition) throws KaleoDefinitionValidationException {
        if (transition.getTargetNode() == null) {
            throw new KaleoDefinitionValidationException.MustSetTargetNode(transition.getName());
        }
    }

    protected void validateTransitions(Map<String, Transition> transitions) throws KaleoDefinitionValidationException {
        for (Transition transition : transitions.values()) {
            this.validateTransition(transition);
        }
    }
}

