/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition.internal.parser;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowDefinitionFileException;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.workflow.kaleo.definition.Action;
import com.liferay.portal.workflow.kaleo.definition.ActionAware;
import com.liferay.portal.workflow.kaleo.definition.AddressRecipient;
import com.liferay.portal.workflow.kaleo.definition.AssigneesRecipient;
import com.liferay.portal.workflow.kaleo.definition.Assignment;
import com.liferay.portal.workflow.kaleo.definition.Condition;
import com.liferay.portal.workflow.kaleo.definition.Definition;
import com.liferay.portal.workflow.kaleo.definition.DelayDuration;
import com.liferay.portal.workflow.kaleo.definition.DurationScale;
import com.liferay.portal.workflow.kaleo.definition.Fork;
import com.liferay.portal.workflow.kaleo.definition.Join;
import com.liferay.portal.workflow.kaleo.definition.JoinXor;
import com.liferay.portal.workflow.kaleo.definition.Node;
import com.liferay.portal.workflow.kaleo.definition.Notification;
import com.liferay.portal.workflow.kaleo.definition.NotificationAware;
import com.liferay.portal.workflow.kaleo.definition.NotificationReceptionType;
import com.liferay.portal.workflow.kaleo.definition.Recipient;
import com.liferay.portal.workflow.kaleo.definition.ResourceActionAssignment;
import com.liferay.portal.workflow.kaleo.definition.RoleAssignment;
import com.liferay.portal.workflow.kaleo.definition.RoleRecipient;
import com.liferay.portal.workflow.kaleo.definition.ScriptAssignment;
import com.liferay.portal.workflow.kaleo.definition.ScriptRecipient;
import com.liferay.portal.workflow.kaleo.definition.State;
import com.liferay.portal.workflow.kaleo.definition.Task;
import com.liferay.portal.workflow.kaleo.definition.Timer;
import com.liferay.portal.workflow.kaleo.definition.Transition;
import com.liferay.portal.workflow.kaleo.definition.UserAssignment;
import com.liferay.portal.workflow.kaleo.definition.UserRecipient;
import com.liferay.portal.workflow.kaleo.definition.parser.WorkflowModelParser;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={WorkflowModelParser.class})
public class XMLWorkflowModelParser
implements WorkflowModelParser {
    private boolean _validate;

    public Definition parse(InputStream inputStream) throws WorkflowException {
        try {
            return this.doParse(inputStream);
        }
        catch (Exception e) {
            throw new WorkflowDefinitionFileException("Unable to parse definition", (Throwable)e);
        }
    }

    public void setValidate(boolean validate) {
        this._validate = validate;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._validate = GetterUtil.getBoolean((Object)properties.get("validating"), (boolean)true);
    }

    protected Definition doParse(InputStream inputStream) throws Exception {
        Document document = SAXReaderUtil.read((InputStream)inputStream, (boolean)this._validate);
        Element rootElement = document.getRootElement();
        String name = rootElement.elementTextTrim("name");
        String description = rootElement.elementTextTrim("description");
        int version = GetterUtil.getInteger((String)rootElement.elementTextTrim("version"));
        Definition definition = new Definition(name, description, document.formattedString(), version);
        List conditionElements = rootElement.elements("condition");
        for (Object conditionElement : conditionElements) {
            Condition condition = this.parseCondition((Element)conditionElement);
            definition.addNode((Node)condition);
        }
        List forkElements = rootElement.elements("fork");
        for (Object forkElement : forkElements) {
            Fork fork = this.parseFork((Element)forkElement);
            definition.addNode((Node)fork);
        }
        List joinElements = rootElement.elements("join");
        for (Object joinElement : joinElements) {
            Join join = this.parseJoin((Element)joinElement);
            definition.addNode((Node)join);
        }
        List joinXorElements = rootElement.elements("join-xor");
        for (Object joinXorElement : joinXorElements) {
            JoinXor joinXor = this.parseJoinXor((Element)joinXorElement);
            definition.addNode((Node)joinXor);
        }
        List stateElements = rootElement.elements("state");
        for (Element stateElement : stateElements) {
            State state = this.parseState(stateElement);
            definition.addNode((Node)state);
        }
        List taskElements = rootElement.elements("task");
        for (Element taskElement : taskElements) {
            Task task = this.parseTask(taskElement);
            definition.addNode((Node)task);
        }
        this.parseTransitions(definition, conditionElements, forkElements, joinElements, joinXorElements, stateElements, taskElements);
        return definition;
    }

    protected void parseActionElements(List<Element> actionElements, ActionAware actionAware) {
        if (actionElements.isEmpty()) {
            return;
        }
        HashSet<Action> actions = new HashSet<Action>(actionElements.size());
        for (Element actionElement : actionElements) {
            String name = actionElement.elementTextTrim("name");
            String description = actionElement.elementTextTrim("description");
            String executionType = actionElement.elementTextTrim("execution-type");
            String script = actionElement.elementTextTrim("script");
            String scriptLanguage = actionElement.elementTextTrim("script-language");
            String scriptRequiredContexts = actionElement.elementTextTrim("script-required-contexts");
            int priority = GetterUtil.getInteger((String)actionElement.elementTextTrim("priority"));
            Action action = new Action(name, description, executionType, script, scriptLanguage, scriptRequiredContexts, priority);
            actions.add(action);
        }
        actionAware.setActions(actions);
    }

    protected void parseActionsElement(Element actionsElement, Node node) {
        if (actionsElement == null) {
            return;
        }
        List actionElements = actionsElement.elements("action");
        this.parseActionElements(actionElements, (ActionAware)node);
        List notificationElements = actionsElement.elements("notification");
        this.parseNotificationElements(notificationElements, (NotificationAware)node);
    }

    protected Set<Assignment> parseAssignments(Element assignmentsElement) {
        Element rolesElement;
        if (assignmentsElement == null) {
            return Collections.emptySet();
        }
        HashSet<Assignment> assignments = new HashSet<Assignment>();
        Element resourceActionsElement = assignmentsElement.element("resource-actions");
        if (resourceActionsElement != null) {
            List resourceActionElements = resourceActionsElement.elements("resource-action");
            for (Element resourceActionElement : resourceActionElements) {
                String actionId = resourceActionElement.getTextTrim();
                if (!Validator.isNotNull((String)actionId)) continue;
                ResourceActionAssignment resourceActionAssignment = new ResourceActionAssignment(actionId);
                assignments.add((Assignment)resourceActionAssignment);
            }
        }
        if ((rolesElement = assignmentsElement.element("roles")) != null) {
            List roleAssignmentElements = rolesElement.elements("role");
            for (Element roleAssignmentElement : roleAssignmentElements) {
                long roleId = GetterUtil.getLong((String)roleAssignmentElement.elementTextTrim("role-id"));
                String roleType = GetterUtil.getString((String)roleAssignmentElement.elementTextTrim("role-type"), (String)"regular");
                String name = roleAssignmentElement.elementTextTrim("name");
                RoleAssignment roleAssignment = null;
                if (Validator.isNotNull((String)name)) {
                    roleAssignment = new RoleAssignment(name, roleType);
                    boolean autoCreate = GetterUtil.getBoolean((String)roleAssignmentElement.elementTextTrim("auto-create"), (boolean)true);
                    roleAssignment.setAutoCreate(autoCreate);
                } else {
                    roleAssignment = new RoleAssignment(roleId);
                }
                assignments.add((Assignment)roleAssignment);
            }
        }
        List scriptedAssignmentElements = assignmentsElement.elements("scripted-assignment");
        for (Element scriptedAssignmentElement : scriptedAssignmentElements) {
            String script = scriptedAssignmentElement.elementTextTrim("script");
            String scriptLanguage = scriptedAssignmentElement.elementTextTrim("script-language");
            String scriptRequiredContexts = scriptedAssignmentElement.elementTextTrim("script-required-contexts");
            ScriptAssignment scriptAssignment = new ScriptAssignment(script, scriptLanguage, scriptRequiredContexts);
            assignments.add((Assignment)scriptAssignment);
        }
        List userAssignmentElements = assignmentsElement.elements("user");
        for (Element userAssignmentElement : userAssignmentElements) {
            long userId = GetterUtil.getLong((String)userAssignmentElement.elementTextTrim("user-id"));
            String screenName = userAssignmentElement.elementTextTrim("screen-name");
            String emailAddress = userAssignmentElement.elementTextTrim("email-address");
            UserAssignment userAssignment = new UserAssignment(userId, screenName, emailAddress);
            assignments.add((Assignment)userAssignment);
        }
        return assignments;
    }

    protected Condition parseCondition(Element conditionElement) {
        String name = conditionElement.elementTextTrim("name");
        String description = conditionElement.elementTextTrim("description");
        String script = conditionElement.elementTextTrim("script");
        String scriptLanguage = conditionElement.elementTextTrim("script-language");
        String scriptRequiredContexts = conditionElement.elementTextTrim("script-required-contexts");
        Condition condition = new Condition(name, description, script, scriptLanguage, scriptRequiredContexts);
        String metadata = conditionElement.elementTextTrim("metadata");
        condition.setMetadata(metadata);
        Element actionsElement = conditionElement.element("actions");
        this.parseActionsElement(actionsElement, (Node)condition);
        Element timersElement = conditionElement.element("timers");
        this.parseTimerElements(timersElement, (Node)condition);
        return condition;
    }

    protected DelayDuration parseDelay(Element delayElement) {
        if (delayElement == null) {
            return null;
        }
        double duration = GetterUtil.getDouble((String)delayElement.elementTextTrim("duration"));
        DurationScale durationScale = DurationScale.valueOf((String)StringUtil.toUpperCase((String)delayElement.elementTextTrim("scale")));
        return new DelayDuration(duration, durationScale);
    }

    protected Fork parseFork(Element forkElement) {
        String name = forkElement.elementTextTrim("name");
        String description = forkElement.elementTextTrim("description");
        Fork fork = new Fork(name, description);
        String metadata = forkElement.elementTextTrim("metadata");
        fork.setMetadata(metadata);
        Element actionsElement = forkElement.element("actions");
        this.parseActionsElement(actionsElement, (Node)fork);
        Element timersElement = forkElement.element("timers");
        this.parseTimerElements(timersElement, (Node)fork);
        return fork;
    }

    protected Join parseJoin(Element joinElement) {
        String name = joinElement.elementTextTrim("name");
        String description = joinElement.elementTextTrim("description");
        Join join = new Join(name, description);
        String metadata = joinElement.elementTextTrim("metadata");
        join.setMetadata(metadata);
        Element actionsElement = joinElement.element("actions");
        this.parseActionsElement(actionsElement, (Node)join);
        Element timersElement = joinElement.element("timers");
        this.parseTimerElements(timersElement, (Node)join);
        return join;
    }

    protected JoinXor parseJoinXor(Element joinXorElement) {
        String name = joinXorElement.elementTextTrim("name");
        String description = joinXorElement.elementTextTrim("description");
        JoinXor joinXor = new JoinXor(name, description);
        String metadata = joinXorElement.elementTextTrim("metadata");
        joinXor.setMetadata(metadata);
        Element actionsElement = joinXorElement.element("actions");
        this.parseActionsElement(actionsElement, (Node)joinXor);
        Element timersElement = joinXorElement.element("timers");
        this.parseTimerElements(timersElement, (Node)joinXor);
        return joinXor;
    }

    protected void parseNotificationElements(List<Element> notificationElements, NotificationAware notificationAware) {
        if (notificationElements.isEmpty()) {
            return;
        }
        HashSet<Notification> notifications = new HashSet<Notification>(notificationElements.size());
        for (Element notificationElement : notificationElements) {
            String name = notificationElement.elementTextTrim("name");
            String description = notificationElement.elementTextTrim("description");
            String executionType = notificationElement.elementTextTrim("execution-type");
            String template = notificationElement.elementTextTrim("template");
            String templateLanguage = notificationElement.elementTextTrim("template-language");
            Notification notification = new Notification(name, description, executionType, template, templateLanguage);
            List notificationTypeElements = notificationElement.elements("notification-type");
            for (Element notificationTypeElement : notificationTypeElements) {
                notification.addNotificationType(notificationTypeElement.getTextTrim());
            }
            List recipientsElements = notificationElement.elements("recipients");
            for (Element recipientsElement : recipientsElements) {
                this.parseRecipients(recipientsElement, notification, NotificationReceptionType.parse((String)recipientsElement.attributeValue("receptionType")));
            }
            notifications.add(notification);
        }
        notificationAware.setNotifications(notifications);
    }

    protected void parseRecipients(Element recipientsElement, Notification notification, NotificationReceptionType notificationReceptionType) {
        Element rolesElement;
        if (recipientsElement == null) {
            return;
        }
        List addressRecipientElements = recipientsElement.elements("address");
        for (Element addressRecipientElement : addressRecipientElements) {
            AddressRecipient addressRecipient = new AddressRecipient(addressRecipientElement.getTextTrim());
            addressRecipient.setNotificationReceptionType(notificationReceptionType);
            notification.addRecipients((Recipient)addressRecipient);
        }
        Element assigneesRecipientElement = recipientsElement.element("assignees");
        if (assigneesRecipientElement != null) {
            AssigneesRecipient assigneesRecipient = new AssigneesRecipient();
            assigneesRecipient.setNotificationReceptionType(notificationReceptionType);
            notification.addRecipients((Recipient)assigneesRecipient);
        }
        if ((rolesElement = recipientsElement.element("roles")) != null) {
            List roleReceipientElements = rolesElement.elements("role");
            for (Element roleReceipientElement : roleReceipientElements) {
                long roleId = GetterUtil.getLong((String)roleReceipientElement.elementTextTrim("role-id"));
                String roleType = GetterUtil.getString((String)roleReceipientElement.elementTextTrim("role-type"), (String)"regular");
                String name = roleReceipientElement.elementTextTrim("name");
                RoleRecipient roleRecipient = null;
                if (roleId > 0L) {
                    roleRecipient = new RoleRecipient(roleId, roleType);
                } else {
                    roleRecipient = new RoleRecipient(name, roleType);
                    boolean autoCreate = GetterUtil.getBoolean((String)roleReceipientElement.elementTextTrim("auto-create"), (boolean)true);
                    roleRecipient.setAutoCreate(autoCreate);
                }
                roleRecipient.setNotificationReceptionType(notificationReceptionType);
                notification.addRecipients((Recipient)roleRecipient);
            }
        }
        List scriptedRecipientElements = recipientsElement.elements("scripted-recipient");
        for (Element scriptedRecipientElement : scriptedRecipientElements) {
            String script = scriptedRecipientElement.elementTextTrim("script");
            String scriptLanguage = scriptedRecipientElement.elementTextTrim("script-language");
            String scriptRequiredContexts = scriptedRecipientElement.elementTextTrim("script-required-contexts");
            ScriptRecipient scriptRecipient = new ScriptRecipient(script, scriptLanguage, scriptRequiredContexts);
            scriptRecipient.setNotificationReceptionType(notificationReceptionType);
            notification.addRecipients((Recipient)scriptRecipient);
        }
        List userRecipientElements = recipientsElement.elements("user");
        for (Element userRecipientElement : userRecipientElements) {
            long userId = GetterUtil.getLong((String)userRecipientElement.elementTextTrim("user-id"));
            String screenName = userRecipientElement.elementTextTrim("screen-name");
            String emailAddress = userRecipientElement.elementTextTrim("email-address");
            UserRecipient userRecipient = new UserRecipient(userId, screenName, emailAddress);
            userRecipient.setNotificationReceptionType(notificationReceptionType);
            notification.addRecipients((Recipient)userRecipient);
        }
    }

    protected State parseState(Element stateElement) {
        String name = stateElement.elementTextTrim("name");
        String description = stateElement.elementTextTrim("description");
        boolean initial = GetterUtil.getBoolean((String)stateElement.elementTextTrim("initial"));
        State state = new State(name, description, initial);
        String metadata = stateElement.elementTextTrim("metadata");
        state.setMetadata(metadata);
        Element actionsElement = stateElement.element("actions");
        this.parseActionsElement(actionsElement, (Node)state);
        Element timersElement = stateElement.element("timers");
        this.parseTimerElements(timersElement, (Node)state);
        return state;
    }

    protected Task parseTask(Element taskElement) {
        String name = taskElement.elementTextTrim("name");
        String description = taskElement.elementTextTrim("description");
        Task task = new Task(name, description);
        String metadata = taskElement.elementTextTrim("metadata");
        task.setMetadata(metadata);
        Element actionsElement = taskElement.element("actions");
        this.parseActionsElement(actionsElement, (Node)task);
        Element assignmentsElement = taskElement.element("assignments");
        if (assignmentsElement != null) {
            Set<Assignment> assignments = this.parseAssignments(assignmentsElement);
            task.setAssignments(assignments);
        }
        Element timersElement = taskElement.element("task-timers");
        this.parseTaskTimerElements(timersElement, (Node)task);
        return task;
    }

    protected void parseTaskTimerElements(Element taskTimersElement, Node node) {
        if (taskTimersElement == null) {
            return;
        }
        List taskTimerElements = taskTimersElement.elements("task-timer");
        if (taskTimerElements.isEmpty()) {
            return;
        }
        HashSet<Timer> timers = new HashSet<Timer>(taskTimerElements.size());
        for (Element timerElement : taskTimerElements) {
            Timer timer = this.parseTimerElement(timerElement, true);
            timers.add(timer);
        }
        node.setTimers(timers);
    }

    protected void parseTimerActions(Element timersElement, Timer timer) {
        if (timersElement == null) {
            return;
        }
        List timerActionElements = timersElement.elements("timer-action");
        this.parseActionElements(timerActionElements, (ActionAware)timer);
        List timerNotificationElements = timersElement.elements("timer-notification");
        this.parseNotificationElements(timerNotificationElements, (NotificationAware)timer);
        Element reassignmentsElement = timersElement.element("reassignments");
        if (reassignmentsElement != null) {
            Set<Assignment> assignments = this.parseAssignments(reassignmentsElement);
            timer.setReassignments(assignments);
        }
    }

    protected Timer parseTimerElement(Element timerElement, boolean taskTimer) {
        String name = timerElement.elementTextTrim("name");
        String description = timerElement.elementTextTrim("description");
        boolean blocking = GetterUtil.getBoolean((String)timerElement.elementTextTrim("blocking"), (!taskTimer ? 1 : 0) != 0);
        Timer timer = new Timer(name, description, blocking);
        Element delayElement = timerElement.element("delay");
        DelayDuration delayDuration = this.parseDelay(delayElement);
        timer.setDelayDuration(delayDuration);
        if (!blocking) {
            Element recurrenceElement = timerElement.element("recurrence");
            DelayDuration recurrence = this.parseDelay(recurrenceElement);
            timer.setRecurrence(recurrence);
        }
        Element timerActions = timerElement.element("timer-actions");
        this.parseTimerActions(timerActions, timer);
        return timer;
    }

    protected void parseTimerElements(Element timersElement, Node node) {
        if (timersElement == null) {
            return;
        }
        List timerElements = timersElement.elements("timer");
        if (timerElements.isEmpty()) {
            return;
        }
        HashSet<Timer> timers = new HashSet<Timer>(timerElements.size());
        for (Element timerElement : timerElements) {
            Timer timer = this.parseTimerElement(timerElement, false);
            timers.add(timer);
        }
        node.setTimers(timers);
    }

    protected void parseTransition(Definition definition, Element nodeElement) {
        String sourceName = nodeElement.elementTextTrim("name");
        Node sourceNode = definition.getNode(sourceName);
        Element transitionsElement = nodeElement.element("transitions");
        if (transitionsElement == null) {
            return;
        }
        List transitionElements = transitionsElement.elements("transition");
        for (Element transitionElement : transitionElements) {
            String transitionName = transitionElement.elementTextTrim("name");
            String targetName = transitionElement.elementTextTrim("target");
            Node targetNode = definition.getNode(targetName);
            boolean defaultValue = GetterUtil.getBoolean((String)transitionElement.elementTextTrim("default"), (boolean)true);
            Transition transition = new Transition(transitionName, sourceNode, targetNode, defaultValue);
            Element timerElement = transitionElement.element("timer");
            if (timerElement != null) {
                Timer timer = this.parseTimerElement(timerElement, false);
                transition.setTimers(timer);
            }
            sourceNode.addOutgoingTransition(transition);
            if (!Validator.isNotNull((Object)targetNode)) continue;
            targetNode.addIncomingTransition(transition);
        }
    }

    protected void parseTransitions(Definition definition, List<Element> conditionElements, List<Element> forkElements, List<Element> joinElements, List<Element> joinXorElements, List<Element> stateElements, List<Element> taskElements) {
        for (Element conditionElement : conditionElements) {
            this.parseTransition(definition, conditionElement);
        }
        for (Element forkElement : forkElements) {
            this.parseTransition(definition, forkElement);
        }
        for (Element joinElement : joinElements) {
            this.parseTransition(definition, joinElement);
        }
        for (Element joinXorElement : joinXorElements) {
            this.parseTransition(definition, joinXorElement);
        }
        for (Element stateElement : stateElements) {
            this.parseTransition(definition, stateElement);
        }
        for (Element taskElement : taskElements) {
            this.parseTransition(definition, taskElement);
        }
    }
}

