/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition.internal.parser;

import com.liferay.portal.workflow.kaleo.definition.Node;
import com.liferay.portal.workflow.kaleo.definition.NodeType;
import com.liferay.portal.workflow.kaleo.definition.NodeTypeDependentObjectRegistry;
import com.liferay.portal.workflow.kaleo.definition.parser.NodeValidator;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={NodeValidatorRegistry.class})
public class NodeValidatorRegistry {
    private final NodeTypeDependentObjectRegistry<NodeValidator<Node>> _nodeValidators = new NodeTypeDependentObjectRegistry();

    public NodeValidator<Node> getNodeValidator(NodeType nodeType) {
        return (NodeValidator)this._nodeValidators.getNodeTypeDependentObjects(nodeType);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, unbind="removeNodeValidator")
    protected void addNodeValidator(NodeValidator<Node> nodeValidator, Map<String, Object> properties) {
        String nodeType = (String)properties.get("node.type");
        if (nodeType == null) {
            throw new IllegalArgumentException("The property \"node.type\" is null");
        }
        this._nodeValidators.addNodeTypeDependentObject(nodeType, nodeValidator);
    }

    protected void removeNodeValidator(NodeValidator<Node> nodeValidator, Map<String, Object> properties) {
        String nodeType = (String)properties.get("node.type");
        if (nodeType == null) {
            throw new IllegalArgumentException("The property \"node.type\" is null");
        }
        this._nodeValidators.removeNodeTypeDependentObjects(nodeType);
    }
}

