/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition.internal.export;

import com.liferay.portal.workflow.kaleo.definition.NodeType;
import com.liferay.portal.workflow.kaleo.definition.NodeTypeDependentObjectRegistry;
import com.liferay.portal.workflow.kaleo.definition.export.NodeExporter;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={NodeExporterRegistry.class})
public class NodeExporterRegistry {
    private final NodeTypeDependentObjectRegistry<NodeExporter> _nodeExporters = new NodeTypeDependentObjectRegistry();

    public NodeExporter getNodeExporter(NodeType nodeType) {
        return (NodeExporter)this._nodeExporters.getNodeTypeDependentObjects(nodeType);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, unbind="removeNodeExporter")
    protected void addNodeExporter(NodeExporter nodeExporter, Map<String, Object> properties) {
        String nodeType = (String)properties.get("node.type");
        if (nodeType == null) {
            throw new IllegalArgumentException("The property \"node.type\" is null");
        }
        this._nodeExporters.addNodeTypeDependentObject(nodeType, (Object)nodeExporter);
    }

    protected void removeNodeExporter(NodeExporter nodeExporter, Map<String, Object> properties) {
        String nodeType = (String)properties.get("node.type");
        if (nodeType == null) {
            throw new IllegalArgumentException("The property \"node.type\" is null");
        }
        this._nodeExporters.removeNodeTypeDependentObjects(nodeType);
    }
}

