/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition.internal.parser;

import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.workflow.kaleo.definition.Definition;
import com.liferay.portal.workflow.kaleo.definition.Node;
import com.liferay.portal.workflow.kaleo.definition.Transition;
import com.liferay.portal.workflow.kaleo.definition.parser.NodeValidator;
import java.util.Map;

public abstract class BaseNodeValidator<T extends Node>
implements NodeValidator<T> {
    public void validate(Definition definition, T node) throws WorkflowException {
        this.doValidate(definition, node);
        this.validateTransitions(node.getOutgoingTransitions());
    }

    protected abstract void doValidate(Definition var1, T var2) throws WorkflowException;

    protected void validateTransition(Transition transition) throws WorkflowException {
        if (transition.getTargetNode() == null) {
            throw new WorkflowException("Unable to find target node for transition " + transition.getName());
        }
    }

    protected void validateTransitions(Map<String, Transition> transitions) throws WorkflowException {
        for (Transition transition : transitions.values()) {
            this.validateTransition(transition);
        }
    }
}

