/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition.internal.deployment;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.workflow.WorkflowDefinition;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.workflow.kaleo.KaleoWorkflowModelConverter;
import com.liferay.portal.workflow.kaleo.definition.Condition;
import com.liferay.portal.workflow.kaleo.definition.Definition;
import com.liferay.portal.workflow.kaleo.definition.Node;
import com.liferay.portal.workflow.kaleo.definition.NodeType;
import com.liferay.portal.workflow.kaleo.definition.State;
import com.liferay.portal.workflow.kaleo.definition.Task;
import com.liferay.portal.workflow.kaleo.definition.Transition;
import com.liferay.portal.workflow.kaleo.definition.deployment.WorkflowDeployer;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinition;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.service.KaleoConditionLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoDefinitionLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoNodeLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTransitionLocalService;
import java.util.Collection;
import java.util.HashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={WorkflowDeployer.class})
public class DefaultWorkflowDeployer
implements WorkflowDeployer {
    @Reference
    private KaleoConditionLocalService _kaleoConditionLocalService;
    @Reference
    private KaleoDefinitionLocalService _kaleoDefinitionLocalService;
    @Reference
    private KaleoNodeLocalService _kaleoNodeLocalService;
    @Reference
    private KaleoTaskLocalService _kaleoTaskLocalService;
    @Reference
    private KaleoTransitionLocalService _kaleoTransitionLocalService;
    @Reference
    private KaleoWorkflowModelConverter _kaleoWorkflowModelConverter;

    public WorkflowDefinition deploy(String title, Definition definition, ServiceContext serviceContext) throws PortalException {
        KaleoNode kaleoNode;
        KaleoDefinition kaleoDefinition = this._kaleoDefinitionLocalService.fetchLatestKaleoDefinition(definition.getName(), serviceContext);
        kaleoDefinition = kaleoDefinition == null ? this._kaleoDefinitionLocalService.addKaleoDefinition(definition.getName(), title, definition.getDescription(), definition.getContent(), definition.getVersion(), serviceContext) : this._kaleoDefinitionLocalService.incrementKaleoDefinition(definition, title, serviceContext);
        long kaleoDefinitionId = kaleoDefinition.getKaleoDefinitionId();
        Collection nodes = definition.getNodes();
        HashMap<String, KaleoNode> kaleoNodesMap = new HashMap<String, KaleoNode>();
        for (Node node : nodes) {
            kaleoNode = this._kaleoNodeLocalService.addKaleoNode(kaleoDefinitionId, node, serviceContext);
            kaleoNodesMap.put(node.getName(), kaleoNode);
            NodeType nodeType = node.getNodeType();
            if (nodeType.equals((Object)NodeType.TASK)) {
                Task task = (Task)node;
                this._kaleoTaskLocalService.addKaleoTask(kaleoDefinitionId, kaleoNode.getKaleoNodeId(), task, serviceContext);
                continue;
            }
            if (!nodeType.equals((Object)NodeType.CONDITION)) continue;
            Condition condition = (Condition)node;
            this._kaleoConditionLocalService.addKaleoCondition(kaleoDefinitionId, kaleoNode.getKaleoNodeId(), condition, serviceContext);
        }
        for (Node node : nodes) {
            kaleoNode = (KaleoNode)kaleoNodesMap.get(node.getName());
            for (Transition transition : node.getOutgoingTransitionsList()) {
                KaleoNode sourceKaleoNode = (KaleoNode)kaleoNodesMap.get(transition.getSourceNode().getName());
                if (sourceKaleoNode == null) {
                    throw new WorkflowException("Unable to find source node " + transition.getSourceNode());
                }
                KaleoNode targetKaleoNode = (KaleoNode)kaleoNodesMap.get(transition.getTargetNode().getName());
                if (targetKaleoNode == null) {
                    throw new WorkflowException("Unable to find target node " + transition.getTargetNode());
                }
                this._kaleoTransitionLocalService.addKaleoTransition(kaleoNode.getKaleoDefinitionId(), kaleoNode.getKaleoNodeId(), transition, sourceKaleoNode, targetKaleoNode, serviceContext);
            }
        }
        State initialState = definition.getInitialState();
        if (initialState == null) {
            throw new WorkflowException("No initial state found in definition");
        }
        String startKaleoNodeName = initialState.getName();
        kaleoNode = (KaleoNode)kaleoNodesMap.get(startKaleoNodeName);
        this._kaleoDefinitionLocalService.activateKaleoDefinition(kaleoDefinitionId, kaleoNode.getKaleoNodeId(), serviceContext);
        return this._kaleoWorkflowModelConverter.toWorkflowDefinition(kaleoDefinition);
    }
}

