/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition.exception;

import com.liferay.portal.kernel.workflow.WorkflowException;

public class KaleoDefinitionValidationException
extends WorkflowException {
    public KaleoDefinitionValidationException() {
    }

    public KaleoDefinitionValidationException(String msg) {
        super(msg);
    }

    public KaleoDefinitionValidationException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public KaleoDefinitionValidationException(Throwable cause) {
        super(cause);
    }

    public static class UnbalancedForkAndJoinNodes
    extends KaleoDefinitionValidationException {
        public UnbalancedForkAndJoinNodes() {
            super("Each fork node requires a join node. Make sure all forks and joins are properly paired");
        }
    }

    public static class UnbalancedForkAndJoinNode
    extends KaleoDefinitionValidationException {
        private final String _fork;
        private final String _join;

        public UnbalancedForkAndJoinNode(String fork, String join) {
            super(String.format("Fix the errors between the fork node %s and join node %s", fork, join));
            this._fork = fork;
            this._join = join;
        }

        public String getFork() {
            return this._fork;
        }

        public String getJoin() {
            return this._join;
        }
    }

    public static class MustSetTerminalStateNode
    extends KaleoDefinitionValidationException {
        public MustSetTerminalStateNode() {
            super("You must define an end node");
        }
    }

    public static class MustSetTaskFormDefinitionOrReference
    extends KaleoDefinitionValidationException {
        private final String _task;
        private final String _taskForm;

        public MustSetTaskFormDefinitionOrReference(String task, String taskForm) {
            super(String.format("The task form %s for task %s must specify a form reference or form definition", taskForm, task));
            this._task = task;
            this._taskForm = taskForm;
        }

        public String getTask() {
            return this._task;
        }

        public String getTaskForm() {
            return this._taskForm;
        }
    }

    public static class MustSetTargetNode
    extends KaleoDefinitionValidationException {
        private final String _node;

        public MustSetTargetNode(String node) {
            super(String.format("The %s transition must end at a node", node));
            this._node = node;
        }

        public String getNode() {
            return this._node;
        }
    }

    public static class MustSetSourceNode
    extends KaleoDefinitionValidationException {
        private final String _node;

        public MustSetSourceNode(String node) {
            super(String.format("The %s transition must have a source node", node));
            this._node = node;
        }

        public String getNode() {
            return this._node;
        }
    }

    public static class MustSetOutgoingTransition
    extends KaleoDefinitionValidationException {
        private final String _node;

        public MustSetOutgoingTransition(String node) {
            super(String.format("The %s node must have an outgoing transition", node));
            this._node = node;
        }

        public String getNode() {
            return this._node;
        }
    }

    public static class MustSetMultipleOutgoingTransition
    extends KaleoDefinitionValidationException {
        private final String _node;

        public MustSetMultipleOutgoingTransition(String node) {
            super(String.format("The %s node must have at least 2 outgoing transitions", node));
            this._node = node;
        }

        public String getNode() {
            return this._node;
        }
    }

    public static class MustSetJoinNode
    extends KaleoDefinitionValidationException {
        private final String _fork;

        public MustSetJoinNode(String fork) {
            super(String.format("The %s fork node must have a matching join node", fork));
            this._fork = fork;
        }

        public String getFork() {
            return this._fork;
        }
    }

    public static class MustSetInitialStateNode
    extends KaleoDefinitionValidationException {
        public MustSetInitialStateNode() {
            super("You must define a start node");
        }
    }

    public static class MustSetIncomingTransition
    extends KaleoDefinitionValidationException {
        private final String _node;

        public MustSetIncomingTransition(String node) {
            super(String.format("The %s node must have an incoming transition", node));
            this._node = node;
        }

        public String getNode() {
            return this._node;
        }
    }

    public static class MustSetAssignments
    extends KaleoDefinitionValidationException {
        private final String _task;

        public MustSetAssignments(String task) {
            super(String.format("Specify at least one assignment for the %s task node", task));
            this._task = task;
        }

        public String getTask() {
            return this._task;
        }
    }

    public static class MustPairedForkAndJoinNodes
    extends KaleoDefinitionValidationException {
        private final String _fork;
        private final String _node;

        public MustPairedForkAndJoinNodes(String fork, String node) {
            super(String.format("Fork %s and join %s nodes must be paired", fork, node));
            this._fork = fork;
            this._node = node;
        }

        public String getFork() {
            return this._fork;
        }

        public String getNode() {
            return this._node;
        }
    }

    public static class MustNotSetIncomingTransition
    extends KaleoDefinitionValidationException {
        private final String _node;

        public MustNotSetIncomingTransition(String node) {
            super(String.format("The %s node cannot have an incoming transition", node));
            this._node = node;
        }

        public String getNode() {
            return this._node;
        }
    }

    public static class MultipleInitialStateNodes
    extends KaleoDefinitionValidationException {
        private final String _state1;
        private final String _state2;

        public MultipleInitialStateNodes(String state1, String state2) {
            super(String.format("The workflow has too many start nodes (state nodes %s and %s)", state1, state2));
            this._state1 = state1;
            this._state2 = state2;
        }

        public String getState1() {
            return this._state1;
        }

        public String getState2() {
            return this._state2;
        }
    }

    public static class EmptyNotificationTemplate
    extends KaleoDefinitionValidationException {
        private final String _node;

        public EmptyNotificationTemplate(String node) {
            super(String.format("The %s node has a empty notification template", node));
            this._node = node;
        }

        public String getNode() {
            return this._node;
        }
    }
}

