/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.definition.ExecutionType;
import com.liferay.portal.workflow.kaleo.definition.ScriptLanguage;
import java.util.Objects;

public class Action {
    private final String _description;
    private final ExecutionType _executionType;
    private final String _name;
    private final int _priority;
    private final String _script;
    private final ScriptLanguage _scriptLanguage;
    private final String _scriptRequiredContexts;

    public Action(String name, String description, String executionType, String script, String scriptLanguage, String scriptRequiredContexts, int priority) {
        this._name = name;
        this._description = description;
        this._executionType = Validator.isNotNull((String)executionType) ? ExecutionType.parse(executionType) : ExecutionType.ON_TIMER;
        this._script = script;
        this._scriptLanguage = ScriptLanguage.parse(scriptLanguage);
        this._scriptRequiredContexts = scriptRequiredContexts;
        this._priority = priority;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action action = (Action)obj;
        if (Objects.equals(this._name, action._name)) {
            return true;
        }
        return true;
    }

    public String getDescription() {
        return this._description;
    }

    public ExecutionType getExecutionType() {
        return this._executionType;
    }

    public String getName() {
        return this._name;
    }

    public int getPriority() {
        return this._priority;
    }

    public String getScript() {
        return this._script;
    }

    public ScriptLanguage getScriptLanguage() {
        return this._scriptLanguage;
    }

    public String getScriptRequiredContexts() {
        return this._scriptRequiredContexts;
    }

    public int hashCode() {
        return this._name.hashCode();
    }
}

