/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.security.xml.SecureXMLFactoryProviderUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class WorkflowDefinitionContentUtil {
    public static String toJSON(String content) throws WorkflowException {
        if (Validator.isNull((String)content) || content.startsWith("{")) {
            return content;
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = SecureXMLFactoryProviderUtil.newDocumentBuilderFactory();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(new StringReader(content)));
            JSONObject jsonObject = WorkflowDefinitionContentUtil._toJSONObject(document.getDocumentElement());
            return jsonObject.toString();
        }
        catch (Exception exception) {
            throw new WorkflowException("Unable to convert XML to JSON", (Throwable)exception);
        }
    }

    public static String toXML(String content) throws WorkflowException {
        if (Validator.isNull((String)content) || content.startsWith("<")) {
            return content;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\"?>");
        try {
            WorkflowDefinitionContentUtil._toNode(JSONFactoryUtil.createJSONObject((String)content), sb);
        }
        catch (JSONException jsonException) {
            throw new WorkflowException("Unable to convert JSON to XML", (Throwable)jsonException);
        }
        return sb.toString();
    }

    private static void _appendAttributes(Element element, JSONObject jsonObject) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            jsonObject.put(node.getNodeName(), node.getNodeValue());
        }
    }

    private static void _appendAttributes(JSONObject jsonObject, StringBuilder sb) {
        for (String key : jsonObject.keySet()) {
            if (key.equals("#cdata-value") || key.equals("#child-nodes") || key.equals("#tag-name") || key.equals("#value")) continue;
            sb.append(" ");
            sb.append(key);
            sb.append("=");
            sb.append("\"");
            sb.append(jsonObject.get(key));
            sb.append("\"");
        }
    }

    private static void _appendValue(Element element, JSONObject jsonObject) {
        if (!element.hasChildNodes()) {
            return;
        }
        Node valueNode = null;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Text) || !WorkflowDefinitionContentUtil._hasContent(node.getNodeValue())) continue;
            valueNode = node;
            break;
        }
        if (valueNode == null) {
            return;
        }
        String content = valueNode.getNodeValue();
        if (valueNode instanceof CDATASection) {
            JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
            for (String line : content.split("\n")) {
                jsonArray.put(line.replaceAll("\t", "    "));
            }
            jsonObject.put("#cdata-value", jsonArray);
        } else {
            jsonObject.put("#value", content.replaceAll("[\n\t]", ""));
        }
    }

    private static void _appendValue(JSONObject jsonObject, StringBuilder sb) {
        if (jsonObject.has("#cdata-value")) {
            JSONArray jsonArray = jsonObject.getJSONArray("#cdata-value");
            StringBundler cdataSB = new StringBundler(jsonArray.length() * 2 + 2);
            cdataSB.append("<![CDATA[");
            for (int i = 0; i < jsonArray.length(); ++i) {
                String line = jsonArray.getString(i);
                cdataSB.append(line.replaceAll("\\s\\s\\s\\s", "\t"));
                cdataSB.append("\n");
            }
            cdataSB.append("]]>");
            sb.append(cdataSB);
        } else if (jsonObject.has("#value")) {
            sb.append(jsonObject.getString("#value"));
        }
    }

    private static boolean _hasContent(String value) {
        if (Validator.isNull((String)value)) {
            return false;
        }
        return Validator.isNotNull((String)value.replaceAll("[\n\t]", ""));
    }

    private static JSONObject _toJSONObject(Element element) {
        JSONObject jsonObject = JSONUtil.put((String)"#tag-name", (Object)element.getTagName());
        WorkflowDefinitionContentUtil._appendAttributes(element, jsonObject);
        WorkflowDefinitionContentUtil._appendValue(element, jsonObject);
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            jsonArray.put(WorkflowDefinitionContentUtil._toJSONObject((Element)node));
        }
        if (jsonArray.length() > 0) {
            jsonObject.put("#child-nodes", jsonArray);
        }
        return jsonObject;
    }

    private static void _toNode(JSONObject jsonObject, StringBuilder sb) {
        sb.append("<");
        sb.append(jsonObject.getString("#tag-name"));
        WorkflowDefinitionContentUtil._appendAttributes(jsonObject, sb);
        sb.append(">");
        WorkflowDefinitionContentUtil._appendValue(jsonObject, sb);
        JSONArray childNodesJSONArray = jsonObject.getJSONArray("#child-nodes");
        if (childNodesJSONArray != null) {
            childNodesJSONArray.forEach(object -> WorkflowDefinitionContentUtil._toNode((JSONObject)object, sb));
        }
        sb.append("<");
        sb.append("/");
        sb.append(jsonObject.getString("#tag-name"));
        sb.append(">");
    }
}

