/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.definition.ExecutionType;
import com.liferay.portal.workflow.kaleo.definition.NotificationReceptionType;
import com.liferay.portal.workflow.kaleo.definition.NotificationType;
import com.liferay.portal.workflow.kaleo.definition.Recipient;
import com.liferay.portal.workflow.kaleo.definition.TemplateLanguage;
import com.liferay.portal.workflow.kaleo.definition.exception.KaleoDefinitionValidationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Notification {
    private final String _description;
    private final ExecutionType _executionType;
    private final String _name;
    private final Set<NotificationType> _notificationTypes = new HashSet<NotificationType>();
    private final Map<NotificationReceptionType, Set<Recipient>> _recipientsMap = new HashMap<NotificationReceptionType, Set<Recipient>>();
    private final String _template;
    private final TemplateLanguage _templateLanguage;

    public Notification(String name, String description, String executionType, String template, String templateLanguage) throws KaleoDefinitionValidationException {
        this._name = name;
        this._description = description;
        this._executionType = Validator.isNotNull((String)executionType) ? ExecutionType.parse(executionType) : ExecutionType.ON_TIMER;
        this._template = template;
        this._templateLanguage = TemplateLanguage.parse(templateLanguage);
    }

    public void addNotificationType(String notificationType) throws KaleoDefinitionValidationException {
        this._notificationTypes.add(NotificationType.parse(notificationType));
    }

    public void addRecipients(Recipient recipient) {
        Set<Recipient> recipients = this._recipientsMap.get((Object)recipient.getNotificationReceptionType());
        if (recipients == null) {
            recipients = new HashSet<Recipient>();
        }
        recipients.add(recipient);
        this._recipientsMap.put(recipient.getNotificationReceptionType(), recipients);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Notification)) {
            return false;
        }
        Notification notification = (Notification)object;
        if (Objects.equals(this._name, notification._name)) {
            return true;
        }
        return true;
    }

    public String getDescription() {
        return this._description;
    }

    public ExecutionType getExecutionType() {
        return this._executionType;
    }

    public String getName() {
        return this._name;
    }

    public Set<NotificationType> getNotificationTypes() {
        return this._notificationTypes;
    }

    public Map<NotificationReceptionType, Set<Recipient>> getRecipientsMap() {
        return this._recipientsMap;
    }

    public String getTemplate() {
        return this._template;
    }

    public TemplateLanguage getTemplateLanguage() {
        return this._templateLanguage;
    }

    public int hashCode() {
        return this._name.hashCode();
    }
}

