/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition;

import com.liferay.portal.workflow.kaleo.definition.exception.KaleoDefinitionValidationException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface ScriptLanguage {
    public static final ScriptLanguage BEANSHELL = new ScriptingLanguageImpl("beanshell");
    public static final ScriptLanguage DRL = new ScriptingLanguageImpl("drl");
    public static final ScriptLanguage GROOVY = new ScriptingLanguageImpl("groovy");
    public static final ScriptLanguage JAVA = new ScriptingLanguageImpl("java");
    public static final ScriptLanguage JAVASCRIPT = new ScriptingLanguageImpl("javascript");
    public static final ScriptLanguage PYTHON = new ScriptingLanguageImpl("python");
    public static final ScriptLanguage RUBY = new ScriptingLanguageImpl("ruby");
    public static final Pattern functionPattern = Pattern.compile("^function#[a-z][a-zA-Z0-9]*(-[a-zA-Z0-9]+)*$");

    public static ScriptLanguage parse(String value) throws KaleoDefinitionValidationException {
        if (Objects.equals(BEANSHELL.getValue(), value)) {
            return BEANSHELL;
        }
        if (Objects.equals(DRL.getValue(), value)) {
            return DRL;
        }
        if (Objects.equals(GROOVY.getValue(), value)) {
            return GROOVY;
        }
        if (Objects.equals(JAVA.getValue(), value)) {
            return JAVA;
        }
        if (Objects.equals(JAVASCRIPT.getValue(), value)) {
            return JAVASCRIPT;
        }
        if (Objects.equals(PYTHON.getValue(), value)) {
            return PYTHON;
        }
        if (Objects.equals(RUBY.getValue(), value)) {
            return RUBY;
        }
        Matcher matcher = functionPattern.matcher(value);
        if (matcher.matches()) {
            return new ScriptingLanguageImpl(value);
        }
        throw new KaleoDefinitionValidationException.InvalidScriptLanguage(value);
    }

    public String getValue();

    public static final class ScriptingLanguageImpl
    implements ScriptLanguage {
        private final String _value;

        public ScriptingLanguageImpl(String value) {
            this._value = value;
        }

        @Override
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }
    }
}

