/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.resource.locator;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.vulcan.resource.locator.ResourceLocator;
import com.liferay.portal.vulcan.resource.locator.ResourceLocatorFactory;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={ResourceLocatorFactory.class})
public class ResourceLocatorFactoryImpl
implements ResourceLocatorFactory {
    private static final Log _log = LogFactoryUtil.getLog(ResourceLocatorFactoryImpl.class);
    private BundleContext _bundleContext;
    private volatile ServiceTrackerMap<String, Builder> _serviceTrackerMap;

    public ResourceLocator create(final HttpServletRequest httpServletRequest, final User user) {
        return new ResourceLocator(){

            public Object locate(String restContextPath, String resourceName) {
                ServiceTrackerMap serviceTrackerMap = ResourceLocatorFactoryImpl.this._getServiceTrackerMap();
                Builder builder = (Builder)serviceTrackerMap.getService((Object)(restContextPath + "/" + resourceName));
                if (builder == null) {
                    return null;
                }
                return builder.build(httpServletRequest, user);
            }
        };
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    @Deactivate
    protected synchronized void deactivate() {
        ServiceTrackerMap<String, Builder> serviceTrackerMap = this._serviceTrackerMap;
        if (serviceTrackerMap != null) {
            serviceTrackerMap.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceTrackerMap<String, Builder> _getServiceTrackerMap() {
        ServiceTrackerMap serviceTrackerMap = this._serviceTrackerMap;
        if (serviceTrackerMap != null) {
            return this._serviceTrackerMap;
        }
        ResourceLocatorFactoryImpl resourceLocatorFactoryImpl = this;
        synchronized (resourceLocatorFactoryImpl) {
            if (this._serviceTrackerMap != null) {
                return this._serviceTrackerMap;
            }
            this._serviceTrackerMap = serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)this._bundleContext, null, (String)"resource.locator.key", (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<Object, Builder>(){

                public Builder addingService(ServiceReference<Object> serviceReference) {
                    Object resourceFactoryImpl = ResourceLocatorFactoryImpl.this._bundleContext.getService(serviceReference);
                    Class<?> resourceFactoryImplClass = resourceFactoryImpl.getClass();
                    try {
                        Method createMethod = resourceFactoryImplClass.getMethod("create", new Class[0]);
                        Class<?> builderClass = createMethod.getReturnType();
                        return new Builder(createMethod, builderClass.getMethod("build", new Class[0]), builderClass.getMethod("httpServletRequest", HttpServletRequest.class), resourceFactoryImpl, builderClass.getMethod("user", User.class));
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        _log.error((Throwable)noSuchMethodException);
                        return null;
                    }
                }

                public void modifiedService(ServiceReference<Object> serviceReference, Builder builder) {
                }

                public void removedService(ServiceReference<Object> serviceReference, Builder builder) {
                    ResourceLocatorFactoryImpl.this._bundleContext.ungetService(serviceReference);
                }
            });
        }
        return serviceTrackerMap;
    }

    private static class Builder {
        private final Method _buildMethod;
        private final Method _createMethod;
        private final Method _httpServletRequestMethod;
        private final Object _resourceFactoryImpl;
        private final Method _userMethod;

        public Object build(HttpServletRequest httpServletRequest, User user) {
            try {
                Object builder = this._createMethod.invoke(this._resourceFactoryImpl, new Object[0]);
                if (httpServletRequest != null) {
                    this._httpServletRequestMethod.invoke(builder, httpServletRequest);
                }
                if (user != null) {
                    this._userMethod.invoke(builder, user);
                }
                return this._buildMethod.invoke(builder, new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                _log.error((Throwable)reflectiveOperationException);
                return null;
            }
        }

        private Builder(Method createMethod, Method buildMethod, Method httpServletRequestMethod, Object resourceFactoryImpl, Method userMethod) {
            this._createMethod = createMethod;
            this._buildMethod = buildMethod;
            this._httpServletRequestMethod = httpServletRequestMethod;
            this._resourceFactoryImpl = resourceFactoryImpl;
            this._userMethod = userMethod;
            createMethod.setAccessible(true);
            buildMethod.setAccessible(true);
            httpServletRequestMethod.setAccessible(true);
            userMethod.setAccessible(true);
        }
    }
}

