/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.resource;

import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.vulcan.extension.ExtensionProviderRegistry;
import com.liferay.portal.vulcan.extension.PropertyDefinition;
import com.liferay.portal.vulcan.internal.configuration.util.ConfigurationUtil;
import com.liferay.portal.vulcan.internal.extension.EntityExtensionHandler;
import com.liferay.portal.vulcan.internal.extension.util.ExtensionUtil;
import com.liferay.portal.vulcan.jaxrs.JaxRsResourceRegistry;
import com.liferay.portal.vulcan.openapi.DTOProperty;
import com.liferay.portal.vulcan.openapi.OpenAPISchemaFilter;
import com.liferay.portal.vulcan.openapi.contributor.OpenAPIContributor;
import com.liferay.portal.vulcan.resource.OpenAPIResource;
import com.liferay.portal.vulcan.util.UriInfoUtil;
import io.swagger.v3.core.filter.AbstractSpecFilter;
import io.swagger.v3.core.filter.OpenAPISpecFilter;
import io.swagger.v3.core.filter.SpecFilter;
import io.swagger.v3.core.model.ApiDescription;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.jaxrs2.integration.JaxrsOpenApiContextBuilder;
import io.swagger.v3.oas.integration.GenericOpenApiContext;
import io.swagger.v3.oas.integration.api.OpenAPIConfiguration;
import io.swagger.v3.oas.integration.api.OpenApiContext;
import io.swagger.v3.oas.integration.api.OpenApiScanner;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.servers.Server;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={OpenAPIResource.class})
public class OpenAPIResourceImpl
implements OpenAPIResource {
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private ExtensionProviderRegistry _extensionProviderRegistry;
    @Reference
    private JaxRsResourceRegistry _jaxRsResourceRegistry;
    @Reference
    private Portal _portal;
    private ServiceTrackerList<OpenAPIContributor> _trackedOpenAPIContributors;

    public Response getOpenAPI(HttpServletRequest httpServletRequest, Set<Class<?>> resourceClasses, String type, UriInfo uriInfo) throws Exception {
        return this._getOpenAPI(httpServletRequest, null, null, resourceClasses, type, uriInfo);
    }

    public Response getOpenAPI(OpenAPIContributor openAPIContributor, OpenAPISchemaFilter openAPISchemaFilter, Set<Class<?>> resourceClasses, String type, UriInfo uriInfo) throws Exception {
        return this._getOpenAPI(null, openAPIContributor, openAPISchemaFilter, resourceClasses, type, uriInfo);
    }

    public Response getOpenAPI(Set<Class<?>> resourceClasses, String type) throws Exception {
        return this.getOpenAPI(resourceClasses, type, null);
    }

    public Response getOpenAPI(Set<Class<?>> resourceClasses, String type, UriInfo uriInfo) throws Exception {
        return this.getOpenAPI(null, null, resourceClasses, type, uriInfo);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._trackedOpenAPIContributors = ServiceTrackerListFactory.open((BundleContext)bundleContext, OpenAPIContributor.class);
    }

    @Deactivate
    protected void deactivate() {
        this._trackedOpenAPIContributors.close();
    }

    private String _getBasePath(HttpServletRequest httpServletRequest, UriInfo uriInfo) {
        if (uriInfo == null) {
            return null;
        }
        if (httpServletRequest == null) {
            return UriInfoUtil.getBasePath((UriInfo)uriInfo);
        }
        String scheme = "http";
        if (this._portal.isSecure(httpServletRequest)) {
            scheme = "https";
        }
        UriBuilder uriBuilder = UriInfoUtil.getBaseUriBuilder((UriInfo)uriInfo);
        uriBuilder.host(this._portal.getForwardedHost(httpServletRequest)).scheme(scheme);
        return String.valueOf(uriBuilder.build(new Object[0]));
    }

    private Set<String> _getDTOClassNames(Set<Class<?>> resourceClasses) {
        HashSet<String> classNames = new HashSet<String>();
        for (Class<?> resourceClass : resourceClasses) {
            String className = resourceClass.getName();
            Object propertyValue = this._jaxRsResourceRegistry.getPropertyValue(className, "entity.class.name");
            if (propertyValue == null) continue;
            classNames.add((String)propertyValue);
        }
        return classNames;
    }

    private DTOProperty _getDTOProperty(PropertyDefinition propertyDefinition) {
        DTOProperty dtoProperty;
        PropertyDefinition.PropertyType propertyType = propertyDefinition.getPropertyType();
        String type = null;
        if (propertyType == PropertyDefinition.PropertyType.MULTIPLE_ELEMENT || propertyType == PropertyDefinition.PropertyType.SINGLE_ELEMENT) {
            type = propertyType == PropertyDefinition.PropertyType.MULTIPLE_ELEMENT ? "Array" : "Object";
            dtoProperty = new DTOProperty(null, propertyDefinition.getPropertyName(), type);
            DTOProperty objectDTOProperty = new DTOProperty(null, propertyDefinition.getPropertyClassName(), "Object");
            dtoProperty.setDTOProperties(Arrays.asList(objectDTOProperty));
            if (ListUtil.isNotEmpty((List)propertyDefinition.getPropertyDefinitions())) {
                ArrayList<DTOProperty> dtoProperties = new ArrayList<DTOProperty>();
                for (PropertyDefinition definition : propertyDefinition.getPropertyDefinitions()) {
                    dtoProperties.add(this._getDTOProperty(definition));
                }
                objectDTOProperty.setDTOProperties(dtoProperties);
            }
        } else {
            type = propertyType == PropertyDefinition.PropertyType.BIG_DECIMAL ? "Double" : (propertyType == PropertyDefinition.PropertyType.BOOLEAN ? "Boolean" : (propertyType == PropertyDefinition.PropertyType.DATE_TIME ? "Date" : (propertyType == PropertyDefinition.PropertyType.DECIMAL ? "Float" : (propertyType == PropertyDefinition.PropertyType.DOUBLE ? "Double" : (propertyType == PropertyDefinition.PropertyType.INTEGER ? "Integer" : (propertyType == PropertyDefinition.PropertyType.LONG ? "Long" : (propertyType == PropertyDefinition.PropertyType.TEXT ? "String" : "Object")))))));
            dtoProperty = new DTOProperty(null, propertyDefinition.getPropertyName(), type);
        }
        dtoProperty.setDescription(propertyDefinition.getPropertyDescription());
        return dtoProperty;
    }

    private List<PropertyDefinition> _getExtendedPropertyDefinitions(String className, long companyId, ExtensionProviderRegistry extensionProviderRegistry) throws Exception {
        ArrayList<PropertyDefinition> propertyDefinitions = null;
        EntityExtensionHandler entityExtensionHandler = ExtensionUtil.getEntityExtensionHandler(className, companyId, extensionProviderRegistry);
        if (entityExtensionHandler != null) {
            Map<String, PropertyDefinition> extendedPropertyDefinitions = entityExtensionHandler.getExtendedPropertyDefinitions(companyId, className);
            propertyDefinitions = new ArrayList<PropertyDefinition>(extendedPropertyDefinitions.values());
        }
        return propertyDefinitions;
    }

    private Response _getOpenAPI(HttpServletRequest httpServletRequest, OpenAPIContributor openAPIContributor, OpenAPISchemaFilter openAPISchemaFilter, final Set<Class<?>> resourceClasses, String type, UriInfo uriInfo) throws Exception {
        JaxrsOpenApiContextBuilder jaxrsOpenApiContextBuilder = new JaxrsOpenApiContextBuilder();
        OpenApiContext openApiContext = jaxrsOpenApiContextBuilder.buildContext(true);
        GenericOpenApiContext genericOpenApiContext = (GenericOpenApiContext)openApiContext;
        genericOpenApiContext.setCacheTTL(0L);
        genericOpenApiContext.setOpenApiScanner(new OpenApiScanner(){

            public Set<Class<?>> classes() {
                return resourceClasses;
            }

            public Map<String, Object> resources() {
                return new HashMap<String, Object>();
            }

            public void setConfiguration(OpenAPIConfiguration openAPIConfiguration) {
            }
        });
        OpenAPI openAPI = openApiContext.read();
        OpenAPISchemaFilter mergedOpenAPISchemaFilter = this._mergeOpenAPISchemaFilters(openAPISchemaFilter, this._getOpenAPISchemaFilter(this._getBasePath(null, uriInfo), this._extensionProviderRegistry, resourceClasses));
        if (mergedOpenAPISchemaFilter != null) {
            SpecFilter specFilter = new SpecFilter();
            MultivaluedMap queryParameters = null;
            if (uriInfo != null) {
                queryParameters = uriInfo.getQueryParameters();
            }
            openAPI = specFilter.filter(openAPI, this._toOpenAPISpecFilter(mergedOpenAPISchemaFilter), (Map)queryParameters, null, null);
        }
        if (openAPI == null) {
            return Response.status((int)404).build();
        }
        if (uriInfo != null) {
            Server server = new Server();
            server.setUrl(this._getBasePath(httpServletRequest, uriInfo));
            openAPI.setServers(Collections.singletonList(server));
        }
        if (openAPIContributor != null) {
            openAPIContributor.contribute(openAPI, uriInfo);
        }
        for (OpenAPIContributor trackedOpenAPIContributor : this._trackedOpenAPIContributors) {
            trackedOpenAPIContributor.contribute(openAPI, uriInfo);
        }
        if (StringUtil.equalsIgnoreCase((String)"yaml", (String)type)) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)Yaml.pretty((Object)openAPI)).type("application/yaml").build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)openAPI).type(javax.ws.rs.core.MediaType.APPLICATION_JSON_TYPE).build();
    }

    private OpenAPISchemaFilter _getOpenAPISchemaFilter(String basePath, ExtensionProviderRegistry extensionProviderRegistry, Set<Class<?>> resourceClasses) throws Exception {
        Set<String> classNames = this._getDTOClassNames(resourceClasses);
        if (SetUtil.isEmpty(classNames)) {
            return null;
        }
        long companyId = CompanyThreadLocal.getCompanyId();
        HashMap<String, List<PropertyDefinition>> propertyDefinitionsMap = new HashMap<String, List<PropertyDefinition>>();
        for (String className : classNames) {
            List<PropertyDefinition> propertyDefinitions = this._getExtendedPropertyDefinitions(className, companyId, extensionProviderRegistry);
            if (!ListUtil.isNotEmpty(propertyDefinitions)) continue;
            propertyDefinitionsMap.put(className, propertyDefinitions);
        }
        if (MapUtil.isNotEmpty(propertyDefinitionsMap)) {
            return this._getOpenAPISchemaFilter(basePath, propertyDefinitionsMap);
        }
        return null;
    }

    private OpenAPISchemaFilter _getOpenAPISchemaFilter(final String applicationPath, Map<String, List<PropertyDefinition>> propertyDefinitions) {
        final ArrayList<DTOProperty> dtoProperties = new ArrayList<DTOProperty>();
        for (Map.Entry<String, List<PropertyDefinition>> entry : propertyDefinitions.entrySet()) {
            String name = entry.getKey();
            DTOProperty dtoProperty = new DTOProperty(null, StringUtil.extractLast((String)name, (String)"."), "object");
            dtoProperty.setDTOProperties(TransformUtil.transform((Collection)entry.getValue(), this::_getDTOProperty));
            dtoProperties.add(dtoProperty);
        }
        return new OpenAPISchemaFilter(){
            {
                this.setApplicationPath(applicationPath);
                this.setDTOProperties(dtoProperties);
            }
        };
    }

    private OpenAPISchemaFilter _mergeOpenAPISchemaFilters(OpenAPISchemaFilter openAPISchemaFilter1, OpenAPISchemaFilter openAPISchemaFilter2) {
        if (openAPISchemaFilter1 == null) {
            return openAPISchemaFilter2;
        }
        if (openAPISchemaFilter2 == null) {
            return openAPISchemaFilter1;
        }
        OpenAPISchemaFilter mergedOpenAPISchemaFilter = new OpenAPISchemaFilter();
        mergedOpenAPISchemaFilter.setApplicationPath(openAPISchemaFilter1.getApplicationPath());
        List dtoProperties = mergedOpenAPISchemaFilter.getDTOProperties();
        dtoProperties.addAll(openAPISchemaFilter1.getDTOProperties());
        dtoProperties.addAll(openAPISchemaFilter2.getDTOProperties());
        Map schemaMappings = mergedOpenAPISchemaFilter.getSchemaMappings();
        schemaMappings.putAll(openAPISchemaFilter1.getSchemaMappings());
        schemaMappings.putAll(openAPISchemaFilter2.getSchemaMappings());
        return mergedOpenAPISchemaFilter;
    }

    private OpenAPISpecFilter _toOpenAPISpecFilter(final OpenAPISchemaFilter openAPISchemaFilter) {
        final List dtoProperties = openAPISchemaFilter.getDTOProperties();
        final Map schemaMappings = openAPISchemaFilter.getSchemaMappings();
        return new AbstractSpecFilter(){

            public Optional<OpenAPI> filterOpenAPI(OpenAPI openAPI, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
                Components components = openAPI.getComponents();
                Map schemas = components.getSchemas();
                for (Map.Entry entry : schemaMappings.entrySet()) {
                    String key = (String)entry.getKey();
                    Schema schema = (Schema)schemas.get(key);
                    schemas.put(schemaMappings.get(key), schema);
                    schemas.remove(key);
                    this._replaceParameters(key, openAPI.getPaths());
                }
                for (DTOProperty dtoProperty : dtoProperties) {
                    Map<DTOProperty, Schema> newSchemas = this._getNewSchemas(dtoProperty);
                    if (MapUtil.isEmpty(newSchemas)) continue;
                    this._fixNewSchemaNames(newSchemas, schemas);
                    for (Schema schema : newSchemas.values()) {
                        openAPI.schema(schema.getName(), schema);
                    }
                }
                return super.filterOpenAPI(openAPI, params, cookies, headers);
            }

            public Optional<Operation> filterOperation(Operation operation, ApiDescription apiDescription, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
                String operationId = operation.getOperationId();
                Set<String> excludedOperationIds = ConfigurationUtil.getExcludedOperationIds(OpenAPIResourceImpl.this._configurationAdmin, openAPISchemaFilter.getApplicationPath());
                if (excludedOperationIds.contains(operationId)) {
                    return Optional.empty();
                }
                for (Map.Entry entry : schemaMappings.entrySet()) {
                    operationId = StringUtil.replace((String)operationId, (String)TextFormatter.formatPlural((String)((String)entry.getKey())), (String)TextFormatter.formatPlural((String)((String)entry.getValue())));
                    operationId = StringUtil.replace((String)operationId, (String)((String)entry.getKey()), (String)((String)entry.getValue()));
                }
                operation.setOperationId(operationId);
                List tags = operation.getTags();
                if (tags != null) {
                    ArrayList newTags = new ArrayList(tags);
                    for (Map.Entry entry : schemaMappings.entrySet()) {
                        for (int i = 0; i < newTags.size(); ++i) {
                            if (!Objects.equals(entry.getKey(), newTags.get(i))) continue;
                            newTags.set(i, entry.getValue());
                        }
                    }
                    operation.setTags(newTags);
                }
                return super.filterOperation(operation, apiDescription, params, cookies, headers);
            }

            public Optional<Parameter> filterParameter(Parameter parameter, Operation operation, ApiDescription apiDescription, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
                for (Map.Entry entry : schemaMappings.entrySet()) {
                    String schemaName;
                    String parameterName = parameter.getName();
                    if (!parameterName.contains(schemaName = StringUtil.lowerCaseFirstLetter((String)((String)entry.getKey())))) continue;
                    parameter.setName(StringUtil.replace((String)parameterName, (String)schemaName, (String)StringUtil.lowerCaseFirstLetter((String)((String)entry.getValue()))));
                }
                return super.filterParameter(parameter, operation, apiDescription, params, cookies, headers);
            }

            public Optional<RequestBody> filterRequestBody(RequestBody requestBody, Operation operation, ApiDescription apiDescription, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
                this._replaceContentReference(requestBody.getContent());
                return super.filterRequestBody(requestBody, operation, apiDescription, params, cookies, headers);
            }

            public Optional<ApiResponse> filterResponse(ApiResponse response, Operation operation, ApiDescription apiDescription, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
                this._replaceContentReference(response.getContent());
                return super.filterResponse(response, operation, apiDescription, params, cookies, headers);
            }

            public Optional<Schema> filterSchema(Schema schema, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
                if (schemaMappings.containsKey(schema.getName())) {
                    StringSchema stringSchema = new StringSchema();
                    stringSchema.readOnly(Boolean.valueOf(true));
                    stringSchema.setDefault(schemaMappings.get(schema.getName()));
                    schema.addProperties("x-schema-name", (Schema)stringSchema);
                }
                for (DTOProperty dtoProperty : dtoProperties) {
                    if (!StringUtil.equals((String)dtoProperty.getName(), (String)schema.getName())) continue;
                    for (DTOProperty childDTOProperty : dtoProperty.getDTOProperties()) {
                        schema.addProperties(childDTOProperty.getName(), this._addSchema(childDTOProperty));
                        if (!childDTOProperty.isRequired()) continue;
                        schema.addRequiredItem(childDTOProperty.getName());
                    }
                    return Optional.of(schema);
                }
                return super.filterSchema(schema, params, cookies, headers);
            }

            public Optional<Schema> filterSchemaProperty(Schema propertySchema, Schema schema, String propName, Map<String, List<String>> params, Map<String, String> cookies, Map<String, List<String>> headers) {
                for (Map.Entry<String, String> entry : schemaMappings.entrySet()) {
                    this._replaceReference(entry, propertySchema);
                    if (!(propertySchema instanceof ArraySchema)) continue;
                    ArraySchema arraySchema = (ArraySchema)propertySchema;
                    this._replaceReference(entry, arraySchema.getItems());
                }
                return super.filterSchemaProperty(propertySchema, schema, propName, params, cookies, headers);
            }

            private Schema<Object> _addSchema(DTOProperty dtoProperty) {
                String type = dtoProperty.getType();
                if (type.equals("Array")) {
                    ArraySchema arraySchema = new ArraySchema();
                    arraySchema.setDescription(dtoProperty.getDescription());
                    arraySchema.setExtensions(dtoProperty.getExtensions());
                    arraySchema.setName(dtoProperty.getName());
                    arraySchema.setType("array");
                    List dtoProperties2 = dtoProperty.getDTOProperties();
                    if (ListUtil.isNotEmpty((List)dtoProperties2)) {
                        final DTOProperty childDTOProperty = (DTOProperty)dtoProperties2.get(0);
                        String childType = childDTOProperty.getType();
                        if (childType.equals("Object")) {
                            arraySchema.setItems(new Schema(){
                                {
                                    this.set$ref("#/components/schemas/" + childDTOProperty.getName());
                                }
                            });
                        } else {
                            arraySchema.setItems(this._addSchema(childDTOProperty));
                        }
                    }
                    return arraySchema;
                }
                Schema schema = new Schema();
                schema.setDescription(dtoProperty.getDescription());
                schema.setExtensions(dtoProperty.getExtensions());
                schema.setName(dtoProperty.getName());
                if (type.equals("Boolean")) {
                    schema.setType("boolean");
                } else if (type.equals("Date")) {
                    schema.setFormat("date");
                    schema.setType("string");
                } else if (type.equals("Double")) {
                    schema.setFormat("double");
                    schema.setType("number");
                } else if (type.equals("Float")) {
                    schema.setFormat("float");
                    schema.setType("number");
                } else if (type.equals("Integer")) {
                    schema.setFormat("int32");
                    schema.setType("integer");
                } else if (type.equals("Long")) {
                    schema.setFormat("int64");
                    schema.setType("integer");
                } else if (type.equals("Object")) {
                    schema.setType("object");
                    for (DTOProperty childDTOProperty : dtoProperty.getDTOProperties()) {
                        if (StringUtil.equals((String)childDTOProperty.getType(), (String)"Object")) {
                            schema.set$ref("#/components/schemas/" + childDTOProperty.getName());
                            continue;
                        }
                        schema.addProperties(childDTOProperty.getName(), this._addSchema(childDTOProperty));
                        if (!childDTOProperty.isRequired()) continue;
                        schema.addRequiredItem(childDTOProperty.getName());
                    }
                } else if (type.equals("String")) {
                    schema.setType("string");
                } else {
                    schema.setType("object");
                }
                return schema;
            }

            private void _fixNewSchemaNames(Map<DTOProperty, Schema> newSchemas, Map<String, Schema> schemas) {
                for (Map.Entry<DTOProperty, Schema> entry : newSchemas.entrySet()) {
                    Schema schema = entry.getValue();
                    if (!schemas.containsKey(schema.getName())) continue;
                    String newName = "C." + schema.getName();
                    schema.setName(newName);
                    DTOProperty dtoProperty = entry.getKey();
                    dtoProperty.setName(newName);
                }
            }

            private Map<DTOProperty, Schema> _getNewSchemas(DTOProperty dtoProperty) {
                HashMap<DTOProperty, Schema> schemas = new HashMap<DTOProperty, Schema>();
                if (StringUtil.equals((String)dtoProperty.getType(), (String)"Array") || StringUtil.equals((String)dtoProperty.getType(), (String)"Object")) {
                    for (DTOProperty childDTOProperty1 : dtoProperty.getDTOProperties()) {
                        if (!StringUtil.equals((String)childDTOProperty1.getType(), (String)"Object")) continue;
                        Schema schema = new Schema();
                        schema.setDescription(childDTOProperty1.getDescription());
                        schema.setExtensions(childDTOProperty1.getExtensions());
                        schema.setName(childDTOProperty1.getName());
                        schema.setType("object");
                        for (DTOProperty childDTOProperty2 : childDTOProperty1.getDTOProperties()) {
                            schema.addProperties(childDTOProperty2.getName(), this._addSchema(childDTOProperty2));
                            if (childDTOProperty2.isRequired()) {
                                schema.addRequiredItem(childDTOProperty2.getName());
                            }
                            schemas.putAll(this._getNewSchemas(childDTOProperty2));
                        }
                        schemas.put(childDTOProperty1, schema);
                    }
                } else {
                    for (DTOProperty childDTOProperty : dtoProperty.getDTOProperties()) {
                        schemas.putAll(this._getNewSchemas(childDTOProperty));
                    }
                }
                return schemas;
            }

            private void _replaceContentReference(Content content) {
                if (content == null) {
                    return;
                }
                for (MediaType mediaType : content.values()) {
                    for (Map.Entry<String, String> entry : schemaMappings.entrySet()) {
                        if (mediaType.getSchema() == null) continue;
                        this._replaceReference(entry, mediaType.getSchema());
                    }
                }
            }

            private void _replaceParameters(String key, Paths paths) {
                String parameterName = StringUtil.lowerCaseFirstLetter((String)key);
                for (String path : new ArrayList(paths.keySet())) {
                    if (!path.contains(parameterName)) continue;
                    PathItem pathItem = (PathItem)paths.get((Object)path);
                    paths.put((Object)path.replace(parameterName, StringUtil.lowerCaseFirstLetter((String)((String)schemaMappings.get(key)))), (Object)pathItem);
                    paths.remove((Object)path);
                }
            }

            private void _replaceReference(Map.Entry<String, String> entry, Schema schema) {
                String ref = schema.get$ref();
                if (ref == null || !ref.endsWith("/" + entry.getKey())) {
                    return;
                }
                schema.set$ref(StringUtil.replace((String)ref, (String)("/" + entry.getKey()), (String)("/" + entry.getValue())));
            }
        };
    }
}

