/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.writer.interceptor;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.internal.extension.EntityExtensionHandler;
import com.liferay.portal.vulcan.internal.jaxrs.extension.ExtendedEntity;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;

@Provider
public class PageEntityExtensionWriterInterceptor
implements WriterInterceptor {
    private static final Log _log = LogFactoryUtil.getLog(PageEntityExtensionWriterInterceptor.class);
    @Context
    private Company _company;
    @Context
    private Providers _providers;

    public void aroundWriteTo(WriterInterceptorContext writerInterceptorContext) throws IOException {
        ParameterizedType parameterizedType;
        Type entityType;
        EntityExtensionHandler entityExtensionHandler;
        if (Page.class.isAssignableFrom(writerInterceptorContext.getType()) && (entityExtensionHandler = this._getEntityExtensionHandler((Class)(entityType = (parameterizedType = (ParameterizedType)writerInterceptorContext.getGenericType()).getActualTypeArguments()[0]), writerInterceptorContext.getMediaType())) != null) {
            this._extendPageEntities(entityExtensionHandler, writerInterceptorContext);
        }
        writerInterceptorContext.proceed();
    }

    private void _extendPageEntities(EntityExtensionHandler entityExtensionHandler, WriterInterceptorContext writerInterceptorContext) throws IOException {
        Page page = (Page)writerInterceptorContext.getEntity();
        ArrayList<ExtendedEntity> extendedEntities = new ArrayList<ExtendedEntity>();
        try {
            for (Object item : page.getItems()) {
                extendedEntities.add(ExtendedEntity.extend(item, entityExtensionHandler.getExtendedProperties(this._company.getCompanyId(), item), entityExtensionHandler.getFilteredPropertyNames(this._company.getCompanyId(), item)));
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            throw new IOException(exception);
        }
        Pagination pagination = Pagination.of((int)GetterUtil.getInteger((Object)page.getPage()), (int)GetterUtil.getInteger((Object)page.getPageSize()));
        writerInterceptorContext.setEntity((Object)Page.of((Map)page.getActions(), extendedEntities, (Pagination)pagination, (long)page.getTotalCount()));
        writerInterceptorContext.setGenericType(new GenericType<Page<ExtendedEntity>>(){}.getType());
    }

    private EntityExtensionHandler _getEntityExtensionHandler(Class<?> clazz, MediaType mediaType) {
        ContextResolver contextResolver = this._providers.getContextResolver(EntityExtensionHandler.class, mediaType);
        if (contextResolver == null) {
            return null;
        }
        return (EntityExtensionHandler)contextResolver.getContext(clazz);
    }
}

