/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.writer.interceptor;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.vulcan.internal.extension.EntityExtensionHandler;
import com.liferay.portal.vulcan.internal.jaxrs.extension.ExtendedEntity;
import java.io.IOException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;

@Provider
public class EntityExtensionWriterInterceptor
implements WriterInterceptor {
    private static final Log _log = LogFactoryUtil.getLog(EntityExtensionWriterInterceptor.class);
    @Context
    private Company _company;
    @Context
    private Providers _providers;

    public void aroundWriteTo(WriterInterceptorContext writerInterceptorContext) throws IOException {
        EntityExtensionHandler entityExtensionHandler = this._getEntityExtensionHandler(writerInterceptorContext.getType(), writerInterceptorContext.getMediaType());
        if (entityExtensionHandler != null) {
            this._extendEntity(entityExtensionHandler, writerInterceptorContext);
        }
        writerInterceptorContext.proceed();
    }

    private void _extendEntity(EntityExtensionHandler entityExtensionHandler, WriterInterceptorContext writerInterceptorContext) throws IOException {
        try {
            writerInterceptorContext.setEntity((Object)ExtendedEntity.extend(writerInterceptorContext.getEntity(), entityExtensionHandler.getExtendedProperties(this._company.getCompanyId(), writerInterceptorContext.getEntity()), entityExtensionHandler.getFilteredPropertyNames(this._company.getCompanyId(), writerInterceptorContext.getEntity())));
            writerInterceptorContext.setGenericType(ExtendedEntity.class);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            throw new IOException(exception);
        }
    }

    private EntityExtensionHandler _getEntityExtensionHandler(Class<?> clazz, MediaType mediaType) {
        ContextResolver contextResolver = this._providers.getContextResolver(EntityExtensionHandler.class, mediaType);
        if (contextResolver == null) {
            return null;
        }
        return (EntityExtensionHandler)contextResolver.getContext(clazz);
    }
}

