/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.container.response.filter;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.vulcan.extension.EntityExtensionThreadLocal;
import com.liferay.portal.vulcan.internal.extension.EntityExtensionHandler;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;

@Priority(value=5010)
@Provider
public class EntityExtensionContainerResponseFilter
implements ContainerResponseFilter {
    private static final Log _log = LogFactoryUtil.getLog(EntityExtensionContainerResponseFilter.class);
    @Context
    private Company _company;
    @Context
    private Providers _providers;
    @Context
    private User _user;

    public void filter(ContainerRequestContext containerRequestContext, ContainerResponseContext containerResponseContext) throws IOException {
        ContextResolver contextResolver;
        Map extendedProperties = EntityExtensionThreadLocal.getExtendedProperties();
        if (extendedProperties == null) {
            return;
        }
        MediaType mediaType = containerResponseContext.getMediaType();
        if (mediaType == null) {
            mediaType = MediaType.WILDCARD_TYPE;
        }
        if ((contextResolver = this._providers.getContextResolver(EntityExtensionHandler.class, mediaType)) == null) {
            return;
        }
        EntityExtensionHandler entityExtensionHandler = this._getEntityExtensionHandler(containerResponseContext.getEntityClass(), (ContextResolver<EntityExtensionHandler>)contextResolver, mediaType);
        if (entityExtensionHandler == null) {
            return;
        }
        try {
            entityExtensionHandler.setExtendedProperties(this._company.getCompanyId(), this._user.getUserId(), containerResponseContext.getEntity(), extendedProperties);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            throw new WebApplicationException((Throwable)exception);
        }
    }

    private EntityExtensionHandler _getEntityExtensionHandler(Class<?> clazz, ContextResolver<EntityExtensionHandler> contextResolver, MediaType mediaType) {
        if (clazz == null) {
            return null;
        }
        EntityExtensionHandler entityExtensionHandler = (EntityExtensionHandler)contextResolver.getContext(clazz);
        if (entityExtensionHandler == null) {
            entityExtensionHandler = this._getEntityExtensionHandler(clazz.getSuperclass(), contextResolver, mediaType);
        }
        return entityExtensionHandler;
    }
}

