/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.container.request.filter;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.spring.transaction.TransactionAttributeAdapter;
import com.liferay.portal.spring.transaction.TransactionAttributeBuilder;
import com.liferay.portal.spring.transaction.TransactionHandler;
import com.liferay.portal.spring.transaction.TransactionStatusAdapter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;

@Priority(value=4990)
@Provider
@Transactional(rollbackFor={Exception.class})
public class TransactionContainerRequestFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final String _TRANSACTION_STATUS_ADAPTER = TransactionContainerRequestFilter.class.getName() + "#TRANSACTION_STATUS_ADAPTER";
    private static final Log _log = LogFactoryUtil.getLog(TransactionContainerRequestFilter.class);
    private static final TransactionAttributeAdapter _transactionAttributeAdapter = new TransactionAttributeAdapter(TransactionAttributeBuilder.build((Transactional)TransactionContainerRequestFilter.class.getAnnotation(Transactional.class)));
    private static final TransactionHandler _transactionHandler = (TransactionHandler)PortalBeanLocatorUtil.locate((String)"transactionExecutor");
    private static final Set<String> _transactionRequiredMethodNames = new HashSet<String>(Arrays.asList("DELETE", "PATCH", "POST", "PUT"));

    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        if (GetterUtil.getBoolean((String)containerRequestContext.getHeaderString("X-Liferay-Transaction-Disabled"))) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Transaction management is disabled");
            }
            return;
        }
        if (_transactionRequiredMethodNames.contains(containerRequestContext.getMethod())) {
            containerRequestContext.setProperty(_TRANSACTION_STATUS_ADAPTER, (Object)_transactionHandler.start(_transactionAttributeAdapter));
        }
    }

    public void filter(ContainerRequestContext containerRequestContext, ContainerResponseContext containerResponseContext) throws IOException {
        block5: {
            TransactionStatusAdapter transactionStatusAdapter = (TransactionStatusAdapter)containerRequestContext.getProperty(_TRANSACTION_STATUS_ADAPTER);
            if (transactionStatusAdapter == null) {
                return;
            }
            Response.Status.Family family = Response.Status.Family.familyOf((int)containerResponseContext.getStatus());
            if (family == Response.Status.Family.SUCCESSFUL) {
                _transactionHandler.commit(_transactionAttributeAdapter, transactionStatusAdapter);
            } else {
                try {
                    _transactionHandler.rollback((Throwable)new Exception(StringBundler.concat((Object[])new Object[]{"Rollback due to ", family, ": ", containerResponseContext.getStatus()})), _transactionAttributeAdapter, transactionStatusAdapter);
                }
                catch (Throwable throwable) {
                    if (!_log.isDebugEnabled()) break block5;
                    _log.debug((Object)"Unable to rollback the transaction", throwable);
                }
            }
        }
    }
}

