/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs;

import com.liferay.portal.vulcan.jaxrs.JaxRsResourceRegistry;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={JaxRsResourceRegistry.class})
public class JaxRsResourceRegistryImpl
implements JaxRsResourceRegistry {
    private final Map<String, Map<String, Object>> _jaxRsResourceProperties = new HashMap<String, Map<String, Object>>();
    private ServiceTracker<?, ?> _serviceTracker;

    public Object getPropertyValue(String className, String propertyName) {
        Object object = null;
        Map<String, Object> properties = this._jaxRsResourceProperties.get(className);
        if (properties != null) {
            object = properties.get(propertyName);
        }
        return object;
    }

    @Activate
    protected void activate(BundleContext bundleContext) throws InvalidSyntaxException {
        Filter filter = bundleContext.createFilter("(osgi.jaxrs.resource=true)");
        this._serviceTracker = new ServiceTracker(bundleContext, filter, (ServiceTrackerCustomizer)new JaxRsResourceTrackerCustomizer(bundleContext));
        this._serviceTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
    }

    private class JaxRsResourceTrackerCustomizer
    implements ServiceTrackerCustomizer<Object, Object> {
        private final BundleContext _bundleContext;

        public Object addingService(ServiceReference<Object> serviceReference) {
            Object object = this._bundleContext.getService(serviceReference);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            for (String propertyKey : serviceReference.getPropertyKeys()) {
                properties.put(propertyKey, serviceReference.getProperty(propertyKey));
            }
            JaxRsResourceRegistryImpl.this._jaxRsResourceProperties.put(this._getClassName(object), properties);
            return object;
        }

        public void modifiedService(ServiceReference<Object> serviceReference, Object object) {
        }

        public void removedService(ServiceReference<Object> serviceReference, Object object) {
            JaxRsResourceRegistryImpl.this._jaxRsResourceProperties.remove(this._getClassName(object));
        }

        private JaxRsResourceTrackerCustomizer(BundleContext bundleContext) {
            this._bundleContext = bundleContext;
        }

        private String _getClassName(Object object) {
            Class<?> clazz = object.getClass();
            return clazz.getName();
        }
    }
}

