/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.graphql.servlet;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapListener;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLTypeExtension;
import com.liferay.portal.vulcan.graphql.dto.GraphQLDTOContributor;
import com.liferay.portal.vulcan.graphql.dto.GraphQLDTOProperty;
import com.liferay.portal.vulcan.graphql.dto.v1_0.Creator;
import com.liferay.portal.vulcan.graphql.servlet.ServletData;
import com.liferay.portal.vulcan.internal.configuration.VulcanConfiguration;
import com.liferay.portal.vulcan.internal.configuration.util.ConfigurationUtil;
import com.liferay.portal.vulcan.internal.graphql.data.fetcher.GraphQLDTOContributorDataFetcher;
import com.liferay.portal.vulcan.internal.graphql.data.fetcher.LiferayMethodDataFetcher;
import com.liferay.portal.vulcan.internal.graphql.data.processor.GraphQLDTOContributorDataFetchingProcessor;
import com.liferay.portal.vulcan.internal.graphql.data.processor.LiferayMethodDataFetchingProcessor;
import com.liferay.portal.vulcan.internal.graphql.util.GraphQLUtil;
import com.liferay.portal.vulcan.internal.multipart.MultipartUtil;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import graphql.ExceptionWhileDataFetching;
import graphql.GraphQLError;
import graphql.GraphqlErrorBuilder;
import graphql.Scalars;
import graphql.TypeResolutionEnvironment;
import graphql.annotations.annotationTypes.GraphQLTypeResolver;
import graphql.annotations.annotationTypes.GraphQLUnion;
import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.annotations.processor.exceptions.CannotCastMemberException;
import graphql.annotations.processor.exceptions.GraphQLAnnotationsException;
import graphql.annotations.processor.graphQLProcessors.GraphQLInputProcessor;
import graphql.annotations.processor.graphQLProcessors.GraphQLOutputProcessor;
import graphql.annotations.processor.retrievers.GraphQLExtensionsHandler;
import graphql.annotations.processor.retrievers.GraphQLFieldRetriever;
import graphql.annotations.processor.retrievers.GraphQLInterfaceRetriever;
import graphql.annotations.processor.retrievers.GraphQLObjectInfoRetriever;
import graphql.annotations.processor.retrievers.GraphQLTypeRetriever;
import graphql.annotations.processor.retrievers.fieldBuilders.ArgumentBuilder;
import graphql.annotations.processor.retrievers.fieldBuilders.DeprecateBuilder;
import graphql.annotations.processor.retrievers.fieldBuilders.DirectivesBuilder;
import graphql.annotations.processor.retrievers.fieldBuilders.field.FieldNameBuilder;
import graphql.annotations.processor.retrievers.fieldBuilders.method.MethodNameBuilder;
import graphql.annotations.processor.retrievers.fieldBuilders.method.MethodTypeBuilder;
import graphql.annotations.processor.searchAlgorithms.BreadthFirstSearch;
import graphql.annotations.processor.searchAlgorithms.ParentalSearch;
import graphql.annotations.processor.searchAlgorithms.SearchAlgorithm;
import graphql.annotations.processor.typeBuilders.EnumBuilder;
import graphql.annotations.processor.typeBuilders.InputObjectBuilder;
import graphql.annotations.processor.typeBuilders.InterfaceBuilder;
import graphql.annotations.processor.typeBuilders.OutputObjectBuilder;
import graphql.annotations.processor.typeBuilders.UnionBuilder;
import graphql.annotations.processor.typeFunctions.DefaultTypeFunction;
import graphql.annotations.processor.typeFunctions.TypeFunction;
import graphql.annotations.processor.util.NamingKit;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherExceptionHandlerResult;
import graphql.execution.ExecutionStrategy;
import graphql.kickstart.execution.GraphQLObjectMapper;
import graphql.kickstart.execution.GraphQLQueryInvoker;
import graphql.kickstart.execution.config.DefaultExecutionStrategyProvider;
import graphql.kickstart.execution.config.ExecutionStrategyProvider;
import graphql.kickstart.execution.error.GraphQLErrorHandler;
import graphql.kickstart.servlet.GraphQLConfiguration;
import graphql.kickstart.servlet.GraphQLHttpServlet;
import graphql.kickstart.servlet.apollo.ApolloScalars;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.scalars.ExtendedScalars;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingEnvironmentImpl;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLTypeVisitorStub;
import graphql.schema.PropertyDataFetcher;
import graphql.schema.SchemaTransformer;
import graphql.schema.TypeResolver;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import javax.xml.bind.DatatypeConverter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={})
public class GraphQLServletExtender {
    private static final Log _log = LogFactoryUtil.getLog(GraphQLServletExtender.class);
    private static final GraphQLScalarType _dateGraphQLScalarType;
    private static final GraphQLScalarType _mapGraphQLScalarType;
    private static final GraphQLScalarType _objectGraphQLScalarType;
    private BundleContext _bundleContext;
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    private DefaultTypeFunction _defaultTypeFunction;
    @Reference
    private GraphQLDTOContributorDataFetchingProcessor _graphQLDTOContributorDataFetchingProcessor;
    private ServiceTrackerMap<String, GraphQLDTOContributor> _graphQLDTOContributorServiceTrackerMap;
    private GraphQLFieldRetriever _graphQLFieldRetriever;
    @Reference
    private LiferayMethodDataFetchingProcessor _liferayMethodDataFetchingProcessor;
    @Reference
    private Portal _portal;
    private final Map<String, String> _registeredClassNames = new HashMap<String, String>();
    private ServiceRegistration<ServletContextHelper> _servletContextHelperServiceRegistration;
    private final List<ServletData> _servletDataList = new ArrayList<ServletData>();
    private ServiceTracker<ServletData, ServletData> _servletDataServiceTracker;
    private final Map<Long, Servlet> _servlets = new ConcurrentHashMap<Long, Servlet>();
    private ServiceRegistration<Servlet> _servletServiceRegistration;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._graphQLFieldRetriever = new LiferayGraphQLFieldRetriever();
        final GraphQLInterfaceRetriever graphQLInterfaceRetriever = new GraphQLInterfaceRetriever();
        final GraphQLObjectInfoRetriever graphQLObjectInfoRetriever = new GraphQLObjectInfoRetriever(){

            public String getTypeName(Class<?> objectClass) {
                String graphQLName = GraphQLUtil.getGraphQLNameValue(objectClass);
                if (graphQLName == null) {
                    return NamingKit.toGraphqlName((String)objectClass.getName());
                }
                return NamingKit.toGraphqlName((String)graphQLName);
            }

            public Boolean isGraphQLField(AnnotatedElement element) {
                GraphQLField graphQLField = element.getAnnotation(GraphQLField.class);
                if (graphQLField == null) {
                    return false;
                }
                return graphQLField.value();
            }
        };
        final BreadthFirstSearch breadthFirstSearch = new BreadthFirstSearch(graphQLObjectInfoRetriever);
        final ParentalSearch parentalSearch = new ParentalSearch(graphQLObjectInfoRetriever);
        final GraphQLExtensionsHandler graphQLExtensionsHandler = new GraphQLExtensionsHandler(){
            {
                this.setFieldRetriever(GraphQLServletExtender.this._graphQLFieldRetriever);
                this.setFieldSearchAlgorithm((SearchAlgorithm)parentalSearch);
                this.setGraphQLObjectInfoRetriever(graphQLObjectInfoRetriever);
                this.setMethodSearchAlgorithm((SearchAlgorithm)breadthFirstSearch);
            }
        };
        final GraphQLTypeRetriever graphQLTypeRetriever = new GraphQLTypeRetriever(){
            {
                this.setExtensionsHandler(graphQLExtensionsHandler);
                this.setFieldSearchAlgorithm((SearchAlgorithm)parentalSearch);
                this.setGraphQLFieldRetriever(GraphQLServletExtender.this._graphQLFieldRetriever);
                this.setGraphQLInterfaceRetriever(graphQLInterfaceRetriever);
                this.setGraphQLObjectInfoRetriever(graphQLObjectInfoRetriever);
                this.setMethodSearchAlgorithm((SearchAlgorithm)breadthFirstSearch);
            }

            public GraphQLType getGraphQLType(Class<?> clazz, ProcessingElementsContainer processingElementsContainer, boolean input) throws CannotCastMemberException, GraphQLAnnotationsException {
                Map graphQLTypes = processingElementsContainer.getTypeRegistry();
                String typeName = this._getTypeName(input, processingElementsContainer, graphQLObjectInfoRetriever.getTypeName(clazz));
                GraphQLType graphQLType = (GraphQLType)graphQLTypes.get(typeName);
                String registeredClassNamesKey = clazz.getName() + "_" + input;
                if (GraphQLServletExtender.this._registeredClassNames.containsKey(registeredClassNamesKey)) {
                    typeName = (String)GraphQLServletExtender.this._registeredClassNames.get(registeredClassNamesKey);
                } else if (graphQLType != null) {
                    String name = clazz.getName();
                    name = name.replaceAll("\\.", "_");
                    typeName = this._getTypeName(input, processingElementsContainer, StringUtil.replace((String)name, (char)'$', (char)'_'));
                }
                Stack processingStack = processingElementsContainer.getProcessing();
                if (processingStack.contains(typeName)) {
                    return new GraphQLTypeReference(typeName);
                }
                graphQLType = (GraphQLType)graphQLTypes.get(typeName);
                if (graphQLType != null) {
                    return graphQLType;
                }
                processingStack.push(typeName);
                GraphQLServletExtender.this._registeredClassNames.put(registeredClassNamesKey, typeName);
                if (clazz.getAnnotation(GraphQLUnion.class) != null) {
                    graphQLType = new UnionBuilder(graphQLObjectInfoRetriever).getUnionBuilder(clazz, processingElementsContainer).build();
                } else if (clazz.isAnnotationPresent(GraphQLTypeResolver.class)) {
                    graphQLType = new InterfaceBuilder(graphQLObjectInfoRetriever, GraphQLServletExtender.this._graphQLFieldRetriever, graphQLExtensionsHandler).getInterfaceBuilder(clazz, processingElementsContainer).build();
                } else if (Enum.class.isAssignableFrom(clazz)) {
                    graphQLType = new EnumBuilder(graphQLObjectInfoRetriever).getEnumBuilder(clazz).build();
                } else if (input) {
                    graphQLType = new InputObjectBuilder(graphQLObjectInfoRetriever, (SearchAlgorithm)parentalSearch, (SearchAlgorithm)breadthFirstSearch, GraphQLServletExtender.this._graphQLFieldRetriever).getInputObjectBuilder(clazz, processingElementsContainer).build();
                } else {
                    GraphQLObjectType.Builder outputObjectBuilder = new OutputObjectBuilder(graphQLObjectInfoRetriever, (SearchAlgorithm)parentalSearch, (SearchAlgorithm)breadthFirstSearch, GraphQLServletExtender.this._graphQLFieldRetriever, graphQLInterfaceRetriever, graphQLExtensionsHandler).getOutputObjectBuilder(clazz, processingElementsContainer);
                    GraphQLName graphQLName = clazz.getAnnotation(GraphQLName.class);
                    if (graphQLName != null) {
                        outputObjectBuilder.description(graphQLName.description());
                    }
                    graphQLType = outputObjectBuilder.build();
                }
                if (!StringUtil.equals((String)GraphQLTypeUtil.simplePrint((GraphQLType)graphQLType), (String)typeName)) {
                    if (!this._equals((GraphQLSchemaElement)graphQLTypes.get(GraphQLTypeUtil.simplePrint((GraphQLType)graphQLType)), (GraphQLSchemaElement)graphQLType)) {
                        try {
                            Class<?> graphQLTypeClass = graphQLType.getClass();
                            Field field = graphQLTypeClass.getDeclaredField("name");
                            field.setAccessible(true);
                            field.set(graphQLType, typeName);
                        }
                        catch (Exception exception) {
                            if (_log.isDebugEnabled()) {
                                _log.debug((Throwable)exception);
                            }
                        }
                    } else {
                        graphQLType = (GraphQLType)graphQLTypes.get(GraphQLTypeUtil.simplePrint((GraphQLType)graphQLType));
                    }
                }
                graphQLTypes.put(GraphQLTypeUtil.simplePrint((GraphQLType)graphQLType), graphQLType);
                processingStack.pop();
                return graphQLType;
            }

            private boolean _equals(GraphQLSchemaElement graphQLSchemaElement1, GraphQLSchemaElement graphQLSchemaElement2) {
                List childrenGraphQLSchemaElement1 = graphQLSchemaElement1.getChildren();
                List childrenGraphQLSchemaElement2 = graphQLSchemaElement2.getChildren();
                for (GraphQLSchemaElement childGraphQLSchemaElement1 : childrenGraphQLSchemaElement1) {
                    boolean found = false;
                    for (GraphQLSchemaElement childGraphQLSchemaElement2 : childrenGraphQLSchemaElement2) {
                        if (!StringUtil.equals((String)GraphQLTypeUtil.simplePrint((GraphQLSchemaElement)childGraphQLSchemaElement1), (String)GraphQLTypeUtil.simplePrint((GraphQLSchemaElement)childGraphQLSchemaElement2)) || !this._equals(childGraphQLSchemaElement1, childGraphQLSchemaElement2)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return false;
                }
                return childrenGraphQLSchemaElement1.size() == childrenGraphQLSchemaElement2.size();
            }

            private String _getTypeName(boolean input, ProcessingElementsContainer processingElementsContainer, String typeName) {
                if (input) {
                    typeName = processingElementsContainer.getInputPrefix() + typeName + processingElementsContainer.getInputSuffix();
                }
                return typeName;
            }
        };
        graphQLInterfaceRetriever.setGraphQLTypeRetriever(graphQLTypeRetriever);
        this._defaultTypeFunction = new DefaultTypeFunction(new GraphQLInputProcessor(){
            {
                this.setGraphQLTypeRetriever(graphQLTypeRetriever);
            }
        }, new GraphQLOutputProcessor(){
            {
                this.setGraphQLTypeRetriever(graphQLTypeRetriever);
            }
        }){

            public GraphQLType buildType(boolean input, Class<?> clazz, AnnotatedType annotatedType, ProcessingElementsContainer processingElementsContainer) {
                GraphQLType graphQLType = super.buildType(input, clazz, annotatedType, processingElementsContainer);
                if (annotatedType != null && (annotatedType.isAnnotationPresent(NotEmpty.class) || annotatedType.isAnnotationPresent(NotNull.class))) {
                    graphQLType = new GraphQLNonNull(graphQLType);
                }
                return graphQLType;
            }
        };
        this._defaultTypeFunction.register((TypeFunction)new DateTypeFunction());
        this._defaultTypeFunction.register((TypeFunction)new MapTypeFunction());
        this._defaultTypeFunction.register((TypeFunction)new ObjectTypeFunction());
        this._graphQLDTOContributorServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, GraphQLDTOContributor.class, (String)"dto.name", (ServiceTrackerMapListener)new ServiceTrackerMapListener<String, GraphQLDTOContributor, GraphQLDTOContributor>(){

            public void keyEmitted(ServiceTrackerMap<String, GraphQLDTOContributor> serviceTrackerMap, String key, GraphQLDTOContributor serviceGraphQLDTOContributor, GraphQLDTOContributor contentGraphQLDTOContributor) {
                GraphQLServletExtender.this._servlets.clear();
            }

            public void keyRemoved(ServiceTrackerMap<String, GraphQLDTOContributor> serviceTrackerMap, String key, GraphQLDTOContributor serviceGraphQLDTOContributor, GraphQLDTOContributor contentGraphQLDTOContributor) {
                GraphQLServletExtender.this._servlets.clear();
            }
        });
        this._servletContextHelperServiceRegistration = bundleContext.registerService(ServletContextHelper.class, (Object)new ServletContextHelper(bundleContext.getBundle()){}, (Dictionary)HashMapDictionaryBuilder.put((Object)"osgi.http.whiteboard.context.name", (Object)"GraphQL").put((Object)"osgi.http.whiteboard.context.path", (Object)"/graphql").put((Object)"osgi.http.whiteboard.filter.servlet", (Object)"GraphQL").build());
        this._servletDataServiceTracker = new ServiceTracker(bundleContext, ServletData.class, (ServiceTrackerCustomizer)new ServletDataServiceTrackerCustomizer());
        this._servletDataServiceTracker.open();
        this._servletServiceRegistration = this._bundleContext.registerService(Servlet.class, (Object)((Servlet)ProxyUtil.newProxyInstance((ClassLoader)GraphQLServletExtender.class.getClassLoader(), (Class[])new Class[]{Servlet.class}, (InvocationHandler)new InvocationHandler(){
            private ServletConfig _servletConfig;

            @Override
            public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
                String methodName = method.getName();
                if (methodName.equals("destroy")) {
                    return null;
                }
                if (methodName.equals("getServletConfig")) {
                    return this._servletConfig;
                }
                if (methodName.equals("getServletInfo")) {
                    return "";
                }
                if (methodName.equals("hashCode")) {
                    return this.hashCode();
                }
                if (methodName.equals("init") && arguments.length > 0) {
                    this._servletConfig = (ServletConfig)arguments[0];
                    return null;
                }
                HttpServletRequest httpServletRequest = (HttpServletRequest)arguments[0];
                arguments[0] = new HttpServletRequestWrapper(httpServletRequest){

                    public boolean isAsyncSupported() {
                        return false;
                    }
                };
                Servlet servlet = GraphQLServletExtender.this._createServlet(GraphQLServletExtender.this._portal.getCompanyId((HttpServletRequest)arguments[0]));
                servlet.init(this._servletConfig);
                try {
                    return method.invoke((Object)servlet, arguments);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getCause();
                }
            }
        })), (Dictionary)HashMapDictionaryBuilder.put((Object)"osgi.http.whiteboard.context.select", (Object)"GraphQL").put((Object)"osgi.http.whiteboard.servlet.name", (Object)"GraphQL").put((Object)"osgi.http.whiteboard.servlet.pattern", (Object)"/*").build());
    }

    @Deactivate
    protected void deactivate() {
        this._servletDataServiceTracker.close();
        this._servletServiceRegistration.unregister();
        this._servletContextHelperServiceRegistration.unregister();
    }

    private static GraphQLFieldDefinition _addField(GraphQLOutputType graphQLOutputType, String name, GraphQLArgument ... graphQLArguments) {
        GraphQLFieldDefinition.Builder graphQLFieldDefinitionBuilder = GraphQLFieldDefinition.newFieldDefinition();
        if (graphQLArguments != null) {
            for (GraphQLArgument graphQLArgument : graphQLArguments) {
                graphQLFieldDefinitionBuilder.argument(graphQLArgument);
            }
        }
        return graphQLFieldDefinitionBuilder.name(name).type(graphQLOutputType).build();
    }

    private GraphQLArgument _addGraphQLArgument(GraphQLInputType graphQLInputType, String name) {
        return this._addGraphQLArgument(null, graphQLInputType, name);
    }

    private GraphQLArgument _addGraphQLArgument(Object defaultValue, GraphQLInputType graphQLInputType, String name) {
        GraphQLArgument.Builder graphQLArgumentBuilder = GraphQLArgument.newArgument();
        if (defaultValue != null) {
            graphQLArgumentBuilder.defaultValue(defaultValue);
        }
        graphQLArgumentBuilder.name(name).type(graphQLInputType);
        return graphQLArgumentBuilder.build();
    }

    private GraphQLInputObjectField _addInputField(GraphQLInputType type, String name) {
        GraphQLInputObjectField.Builder graphQLInputObjectFieldBuilder = GraphQLInputObjectField.newInputObjectField();
        return graphQLInputObjectFieldBuilder.name(name).type(type).build();
    }

    private void _collectObjectFields(Function<ServletData, Object> function, GraphQLObjectType.Builder graphQLObjectTypeBuilder, ProcessingElementsContainer processingElementsContainer, List<ServletData> servletDatas) {
        Stream stream = servletDatas.stream();
        Map<String, Optional<Method>> methods = stream.filter(servletData -> servletData.getGraphQLNamespace() == null).flatMap(servletData -> Stream.of(function.apply((ServletData)servletData)).filter(Objects::nonNull).map(Object::getClass).map(Class::getMethods).flatMap(Arrays::stream).filter(method -> this._isMethodEnabled((Method)method, servletData.getPath()))).collect(Collectors.groupingBy(Method::getName, Collectors.maxBy(Comparator.comparingInt(this::_getVersion))));
        for (Optional<Method> methodOptional : methods.values()) {
            if (!methodOptional.isPresent()) continue;
            Method method = methodOptional.get();
            Class<?> clazz = method.getDeclaringClass();
            graphQLObjectTypeBuilder.field(this._graphQLFieldRetriever.getField(clazz.getSimpleName(), method, processingElementsContainer));
        }
    }

    private GraphQLFieldDefinition _createNodeGraphQLFieldDefinition(GraphQLOutputType graphQLOutputType) {
        return GraphQLServletExtender._addField(graphQLOutputType, "graphQLNode", this._addGraphQLArgument((GraphQLInputType)Scalars.GraphQLString, "dataType"), this._addGraphQLArgument((GraphQLInputType)ExtendedScalars.GraphQLLong, "id"));
    }

    private GraphQLInterfaceType _createNodeGraphQLInterfaceType() {
        GraphQLInterfaceType.Builder interfaceBuilder = GraphQLInterfaceType.newInterface();
        interfaceBuilder.field(GraphQLServletExtender._addField((GraphQLOutputType)ExtendedScalars.GraphQLLong, "id", new GraphQLArgument[0]));
        interfaceBuilder.name("GraphQLNode");
        return interfaceBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Servlet _createServlet(long companyId) throws Exception {
        Servlet servlet = this._servlets.get(companyId);
        if (servlet != null) {
            return servlet;
        }
        List<ServletData> list = this._servletDataList;
        synchronized (list) {
            if (this._servlets.containsKey(companyId)) {
                return this._servlets.get(companyId);
            }
            PropertyDataFetcher.clearReflectionCache();
            this._registeredClassNames.clear();
            GraphQLObjectType.Builder mutationGraphQLObjectTypeBuilder = GraphQLObjectType.newObject();
            mutationGraphQLObjectTypeBuilder.name("mutation");
            ProcessingElementsContainer processingElementsContainer = new ProcessingElementsContainer((TypeFunction)this._defaultTypeFunction);
            Map classesMap = processingElementsContainer.getExtensionsTypeRegistry();
            ArrayList<ServletData> servletDatas = new ArrayList<ServletData>();
            for (ServletData servletData : this._servletDataList) {
                if (this._isGraphQLEnabled(servletData.getPath())) {
                    servletDatas.add(servletData);
                }
                Object query = servletData.getQuery();
                Class<?> queryClass = query.getClass();
                for (Class<?> innerClasses : queryClass.getClasses()) {
                    if (!innerClasses.isAnnotationPresent(GraphQLTypeExtension.class)) continue;
                    GraphQLTypeExtension graphQLTypeExtension = innerClasses.getAnnotation(GraphQLTypeExtension.class);
                    Class clazz = graphQLTypeExtension.value();
                    if (!classesMap.containsKey(clazz)) {
                        classesMap.put(clazz, new HashSet());
                    }
                    Set classes = (Set)classesMap.get(clazz);
                    classes.add(innerClasses);
                }
            }
            this._collectObjectFields(ServletData::getMutation, mutationGraphQLObjectTypeBuilder, processingElementsContainer, servletDatas);
            GraphQLObjectType.Builder queryGraphQLObjectTypeBuilder = GraphQLObjectType.newObject();
            queryGraphQLObjectTypeBuilder.name("query");
            this._collectObjectFields(ServletData::getQuery, queryGraphQLObjectTypeBuilder, processingElementsContainer, servletDatas);
            GraphQLSchema.Builder graphQLSchemaBuilder = GraphQLSchema.newSchema();
            this._registerCustomTypes(processingElementsContainer);
            this._registerGraphQLDTOContributors(companyId, graphQLSchemaBuilder, processingElementsContainer, mutationGraphQLObjectTypeBuilder, queryGraphQLObjectTypeBuilder);
            GraphQLInterfaceType graphQLInterfaceType = this._registerInterfaces(graphQLSchemaBuilder, processingElementsContainer, queryGraphQLObjectTypeBuilder);
            this._registerNamespace(ServletData::getMutation, mutationGraphQLObjectTypeBuilder, graphQLSchemaBuilder, true, processingElementsContainer, servletDatas);
            this._registerNamespace(ServletData::getQuery, queryGraphQLObjectTypeBuilder, graphQLSchemaBuilder, false, processingElementsContainer, servletDatas);
            graphQLSchemaBuilder.mutation(mutationGraphQLObjectTypeBuilder.build());
            graphQLSchemaBuilder.query(queryGraphQLObjectTypeBuilder.build());
            GraphQLConfiguration.Builder graphQLConfigurationBuilder = GraphQLConfiguration.with((GraphQLSchema)SchemaTransformer.transformSchema((GraphQLSchema)graphQLSchemaBuilder.build(), (GraphQLTypeVisitor)new LiferayGraphQLTypeVisitor(graphQLInterfaceType)));
            AsyncExecutionStrategy executionStrategy = new AsyncExecutionStrategy((DataFetcherExceptionHandler)new SanitizedDataFetcherExceptionHandler());
            DefaultExecutionStrategyProvider executionStrategyProvider = new DefaultExecutionStrategyProvider((ExecutionStrategy)executionStrategy);
            GraphQLQueryInvoker graphQLQueryInvoker = GraphQLQueryInvoker.newBuilder().withExecutionStrategyProvider((ExecutionStrategyProvider)executionStrategyProvider).build();
            graphQLConfigurationBuilder.with(graphQLQueryInvoker);
            GraphQLObjectMapper.Builder objectMapperBuilder = GraphQLObjectMapper.newBuilder();
            objectMapperBuilder.withGraphQLErrorHandler((GraphQLErrorHandler)new LiferayGraphQLErrorHandler());
            objectMapperBuilder.withObjectMapperProvider(() -> {
                ObjectMapper objectMapper = new ObjectMapper();
                objectMapper.setFilterProvider((FilterProvider)new SimpleFilterProvider(){
                    {
                        this.addFilter("Liferay.Vulcan", SimpleBeanPropertyFilter.serializeAll());
                    }
                });
                return objectMapper;
            });
            graphQLConfigurationBuilder.with(objectMapperBuilder.build());
            servlet = GraphQLHttpServlet.with((GraphQLConfiguration)graphQLConfigurationBuilder.build());
            this._servlets.put(companyId, servlet);
            return servlet;
        }
    }

    private GraphQLInputObjectType _getGraphQLInputObjectType(GraphQLDTOContributor<?, ?> graphQLDTOContributor, Map<String, GraphQLType> graphQLTypes) {
        GraphQLInputObjectType.Builder graphQLInputObjectTypeBuilder = new GraphQLInputObjectType.Builder();
        graphQLInputObjectTypeBuilder.name("Input" + graphQLDTOContributor.getTypeName());
        for (GraphQLDTOProperty graphQLDTOProperty : graphQLDTOContributor.getGraphQLDTOProperties()) {
            if (graphQLDTOProperty.isReadOnly()) continue;
            GraphQLInputType graphQLInputType = (GraphQLInputType)this._toGraphQLType(graphQLDTOProperty.getTypeClass(), graphQLTypes, true);
            graphQLInputObjectTypeBuilder.field(this._addInputField(graphQLInputType, graphQLDTOProperty.getName()));
        }
        return graphQLInputObjectTypeBuilder.build();
    }

    private GraphQLObjectType _getGraphQLObjectType(GraphQLCodeRegistry.Builder graphQLCodeRegistryBuilder, GraphQLDTOContributor<?, ?> graphQLDTOContributor, GraphQLSchema.Builder graphQLSchemaBuilder, Map<String, GraphQLType> graphQLTypes) {
        GraphQLObjectType.Builder graphQLObjectTypeBuilder = new GraphQLObjectType.Builder();
        graphQLObjectTypeBuilder.field(GraphQLServletExtender._addField((GraphQLOutputType)ExtendedScalars.GraphQLLong, graphQLDTOContributor.getIdName(), new GraphQLArgument[0]));
        graphQLObjectTypeBuilder.name(graphQLDTOContributor.getTypeName());
        for (GraphQLDTOProperty graphQLDTOProperty : graphQLDTOContributor.getGraphQLDTOProperties()) {
            GraphQLOutputType graphQLOutputType = (GraphQLOutputType)this._toGraphQLType(graphQLDTOProperty.getTypeClass(), graphQLTypes, false);
            graphQLObjectTypeBuilder.field(GraphQLServletExtender._addField(graphQLOutputType, graphQLDTOProperty.getName(), new GraphQLArgument[0]));
        }
        for (GraphQLDTOProperty relationshipGraphQLDTOProperty : graphQLDTOContributor.getRelationshipGraphQLDTOProperties()) {
            graphQLObjectTypeBuilder.field(GraphQLServletExtender._addField((GraphQLOutputType)this._toGraphQLType(relationshipGraphQLDTOProperty.getTypeClass(), graphQLTypes, false), relationshipGraphQLDTOProperty.getName(), new GraphQLArgument[0]));
            graphQLSchemaBuilder.codeRegistry(graphQLCodeRegistryBuilder.dataFetcher(FieldCoordinates.coordinates((String)graphQLDTOContributor.getTypeName(), (String)relationshipGraphQLDTOProperty.getName()), (DataFetcher)new GraphQLDTOContributorDataFetcher(graphQLDTOContributor, this._graphQLDTOContributorDataFetchingProcessor, relationshipGraphQLDTOProperty, GraphQLDTOContributorDataFetcher.Operation.GET_RELATIONSHIP)).build());
        }
        return graphQLObjectTypeBuilder.build();
    }

    private GraphQLObjectType _getPageGraphQLObjectType(GraphQLType facetGraphQLType, GraphQLType objectGraphQLType, String name) {
        GraphQLObjectType.Builder graphQLObjectTypeBuilder = new GraphQLObjectType.Builder();
        graphQLObjectTypeBuilder.field(GraphQLServletExtender._addField((GraphQLOutputType)_mapGraphQLScalarType, "actions", new GraphQLArgument[0]));
        graphQLObjectTypeBuilder.field(GraphQLServletExtender._addField((GraphQLOutputType)GraphQLList.list((GraphQLType)facetGraphQLType), "facets", new GraphQLArgument[0]));
        graphQLObjectTypeBuilder.field(GraphQLServletExtender._addField((GraphQLOutputType)GraphQLList.list((GraphQLType)objectGraphQLType), "items", new GraphQLArgument[0]));
        graphQLObjectTypeBuilder.field(GraphQLServletExtender._addField((GraphQLOutputType)ExtendedScalars.GraphQLLong, "lastPage", new GraphQLArgument[0]));
        graphQLObjectTypeBuilder.field(GraphQLServletExtender._addField((GraphQLOutputType)ExtendedScalars.GraphQLLong, "page", new GraphQLArgument[0]));
        graphQLObjectTypeBuilder.field(GraphQLServletExtender._addField((GraphQLOutputType)ExtendedScalars.GraphQLLong, "pageSize", new GraphQLArgument[0]));
        graphQLObjectTypeBuilder.field(GraphQLServletExtender._addField((GraphQLOutputType)ExtendedScalars.GraphQLLong, "totalCount", new GraphQLArgument[0]));
        graphQLObjectTypeBuilder.name(name + "Page");
        return graphQLObjectTypeBuilder.build();
    }

    private Integer _getVersion(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        String packageString = String.valueOf(clazz.getPackage());
        String[] packageNames = packageString.split("\\.");
        String version = packageNames[packageNames.length - 1];
        return Integer.valueOf(version.replaceAll("\\D", ""));
    }

    private boolean _isGraphQLEnabled(String path) throws Exception {
        String filterString = String.format("(&(path=%s)(service.factoryPid=%s))", path.substring(0, path.indexOf("-graphql")), VulcanConfiguration.class.getName());
        Object[] configurations = this._configurationAdmin.listConfigurations(filterString);
        if (!ArrayUtil.isEmpty((Object[])configurations)) {
            Dictionary dictionary = configurations[0].getProperties();
            return (Boolean)dictionary.get("graphQLEnabled");
        }
        return true;
    }

    private boolean _isMethodEnabled(Method method, String path) {
        Set<String> excludedOperationIds = ConfigurationUtil.getExcludedOperationIds(this._configurationAdmin, path.substring(0, path.indexOf("-graphql")));
        if (excludedOperationIds.contains(method.getName())) {
            return false;
        }
        return GraphQLUtil.isGraphQLFieldValue(method);
    }

    private void _registerCustomTypes(ProcessingElementsContainer processingElementsContainer) {
        Map graphQLTypes = processingElementsContainer.getTypeRegistry();
        GraphQLObjectType.Builder graphQLObjectTypeBuilder = new GraphQLObjectType.Builder();
        String graphQLTypeName = StringUtil.replace((String)Creator.class.getName(), (char)'.', (char)'_');
        graphQLTypes.put(graphQLTypeName, graphQLObjectTypeBuilder.name(graphQLTypeName).field(GraphQLServletExtender._addField((GraphQLOutputType)Scalars.GraphQLString, "additionalName", new GraphQLArgument[0])).field(GraphQLServletExtender._addField((GraphQLOutputType)Scalars.GraphQLString, "contentType", new GraphQLArgument[0])).field(GraphQLServletExtender._addField((GraphQLOutputType)Scalars.GraphQLString, "familyName", new GraphQLArgument[0])).field(GraphQLServletExtender._addField((GraphQLOutputType)ExtendedScalars.GraphQLLong, "id", new GraphQLArgument[0])).field(GraphQLServletExtender._addField((GraphQLOutputType)Scalars.GraphQLString, "image", new GraphQLArgument[0])).field(GraphQLServletExtender._addField((GraphQLOutputType)Scalars.GraphQLString, "name", new GraphQLArgument[0])).field(GraphQLServletExtender._addField((GraphQLOutputType)Scalars.GraphQLString, "profileURL", new GraphQLArgument[0])).build());
        graphQLObjectTypeBuilder = new GraphQLObjectType.Builder();
        graphQLTypes.put("FileEntry", graphQLObjectTypeBuilder.name("FileEntry").field(GraphQLServletExtender._addField((GraphQLOutputType)ExtendedScalars.GraphQLLong, "id", new GraphQLArgument[0])).field(GraphQLServletExtender._addField((GraphQLOutputType)Scalars.GraphQLString, "name", new GraphQLArgument[0])).build());
        GraphQLInputObjectType.Builder graphQLInputObjectTypeBuilder = new GraphQLInputObjectType.Builder();
        graphQLTypes.put("InputListEntry", graphQLInputObjectTypeBuilder.name("InputListEntry").field(this._addInputField((GraphQLInputType)Scalars.GraphQLString, "key")).field(this._addInputField((GraphQLInputType)Scalars.GraphQLString, "name")).field(this._addInputField((GraphQLInputType)_mapGraphQLScalarType, "name_i18n")).build());
        graphQLObjectTypeBuilder = new GraphQLObjectType.Builder();
        graphQLTypes.put("ListEntry", graphQLObjectTypeBuilder.name("ListEntry").field(GraphQLServletExtender._addField((GraphQLOutputType)Scalars.GraphQLString, "key", new GraphQLArgument[0])).field(GraphQLServletExtender._addField((GraphQLOutputType)Scalars.GraphQLString, "name", new GraphQLArgument[0])).field(GraphQLServletExtender._addField((GraphQLOutputType)_mapGraphQLScalarType, "name_i18n", new GraphQLArgument[0])).build());
    }

    private void _registerGraphQLDTOContributor(GraphQLDTOContributor graphQLDTOContributor, GraphQLSchema.Builder graphQLSchemaBuilder, GraphQLObjectType.Builder mutationGraphQLObjectTypeBuilder, String mutationNamespace, String namespace, ProcessingElementsContainer processingElementsContainer, GraphQLObjectType.Builder queryGraphQLObjectTypeBuilder) {
        GraphQLCodeRegistry.Builder graphQLCodeRegistryBuilder = processingElementsContainer.getCodeRegistryBuilder();
        Map graphQLTypes = processingElementsContainer.getTypeRegistry();
        GraphQLObjectType graphQLObjectType = this._getGraphQLObjectType(graphQLCodeRegistryBuilder, graphQLDTOContributor, graphQLSchemaBuilder, graphQLTypes);
        String resourceName = graphQLDTOContributor.getResourceName();
        String createName = "create" + resourceName;
        List<GraphQLArgument> graphQLArguments = new ArrayList<GraphQLArgument>();
        GraphQLInputObjectType graphQLInputType = this._getGraphQLInputObjectType(graphQLDTOContributor, graphQLTypes);
        graphQLArguments.add(this._addGraphQLArgument((GraphQLInputType)graphQLInputType, resourceName));
        if (graphQLDTOContributor.hasScope()) {
            graphQLArguments.add(this._addGraphQLArgument((GraphQLInputType)Scalars.GraphQLString, "scopeKey"));
        }
        mutationGraphQLObjectTypeBuilder.field(GraphQLServletExtender._addField((GraphQLOutputType)graphQLObjectType, createName, graphQLArguments.toArray(new GraphQLArgument[0])));
        graphQLSchemaBuilder.codeRegistry(graphQLCodeRegistryBuilder.dataFetcher(FieldCoordinates.coordinates((String)mutationNamespace, (String)createName), (DataFetcher)new GraphQLDTOContributorDataFetcher(graphQLDTOContributor, this._graphQLDTOContributorDataFetchingProcessor, GraphQLDTOContributorDataFetcher.Operation.CREATE)).build());
        String deleteName = "delete" + resourceName;
        String idName = graphQLDTOContributor.getIdName();
        mutationGraphQLObjectTypeBuilder.field(GraphQLServletExtender._addField((GraphQLOutputType)Scalars.GraphQLBoolean, deleteName, this._addGraphQLArgument((GraphQLInputType)ExtendedScalars.GraphQLLong, idName)));
        graphQLSchemaBuilder.codeRegistry(graphQLCodeRegistryBuilder.dataFetcher(FieldCoordinates.coordinates((String)mutationNamespace, (String)deleteName), (DataFetcher)new GraphQLDTOContributorDataFetcher(graphQLDTOContributor, this._graphQLDTOContributorDataFetchingProcessor, GraphQLDTOContributorDataFetcher.Operation.DELETE)).build());
        String getName = StringUtil.lowerCaseFirstLetter((String)resourceName);
        queryGraphQLObjectTypeBuilder.field(GraphQLServletExtender._addField((GraphQLOutputType)graphQLObjectType, getName, this._addGraphQLArgument((GraphQLInputType)ExtendedScalars.GraphQLLong, idName)));
        graphQLSchemaBuilder.codeRegistry(graphQLCodeRegistryBuilder.dataFetcher(FieldCoordinates.coordinates((String)namespace, (String)getName), (DataFetcher)new GraphQLDTOContributorDataFetcher(graphQLDTOContributor, this._graphQLDTOContributorDataFetchingProcessor, GraphQLDTOContributorDataFetcher.Operation.GET)).build());
        String listName = StringUtil.lowerCaseFirstLetter((String)TextFormatter.formatPlural((String)resourceName));
        graphQLArguments = ListUtil.fromArray((Object[])new GraphQLArgument[]{this._addGraphQLArgument((GraphQLInputType)GraphQLList.list((GraphQLType)Scalars.GraphQLString), "aggregation"), this._addGraphQLArgument((GraphQLInputType)Scalars.GraphQLString, "filter"), this._addGraphQLArgument(1, (GraphQLInputType)Scalars.GraphQLInt, "page"), this._addGraphQLArgument(20, (GraphQLInputType)Scalars.GraphQLInt, "pageSize"), this._addGraphQLArgument((GraphQLInputType)Scalars.GraphQLString, "search"), this._addGraphQLArgument((GraphQLInputType)Scalars.GraphQLString, "sort")});
        if (graphQLDTOContributor.hasScope()) {
            graphQLArguments.add(this._addGraphQLArgument((GraphQLInputType)Scalars.GraphQLString, "scopeKey"));
        }
        queryGraphQLObjectTypeBuilder.field(GraphQLServletExtender._addField((GraphQLOutputType)this._getPageGraphQLObjectType((GraphQLType)graphQLTypes.get("Facet"), (GraphQLType)graphQLObjectType, graphQLDTOContributor.getTypeName()), listName, graphQLArguments.toArray(new GraphQLArgument[0])));
        graphQLSchemaBuilder.codeRegistry(graphQLCodeRegistryBuilder.dataFetcher(FieldCoordinates.coordinates((String)namespace, (String)listName), (DataFetcher)new GraphQLDTOContributorDataFetcher(graphQLDTOContributor, this._graphQLDTOContributorDataFetchingProcessor, GraphQLDTOContributorDataFetcher.Operation.LIST)).build());
        String updateName = "update" + resourceName;
        mutationGraphQLObjectTypeBuilder.field(GraphQLServletExtender._addField((GraphQLOutputType)graphQLObjectType, updateName, this._addGraphQLArgument((GraphQLInputType)graphQLInputType, resourceName), this._addGraphQLArgument((GraphQLInputType)ExtendedScalars.GraphQLLong, idName)));
        graphQLSchemaBuilder.codeRegistry(graphQLCodeRegistryBuilder.dataFetcher(FieldCoordinates.coordinates((String)mutationNamespace, (String)updateName), (DataFetcher)new GraphQLDTOContributorDataFetcher(graphQLDTOContributor, this._graphQLDTOContributorDataFetchingProcessor, GraphQLDTOContributorDataFetcher.Operation.UPDATE)).build());
    }

    private void _registerGraphQLDTOContributors(long companyId, GraphQLSchema.Builder graphQLSchemaBuilder, ProcessingElementsContainer processingElementsContainer, GraphQLObjectType.Builder rootMutationGraphQLObjectTypeBuilder, GraphQLObjectType.Builder rootQueryGraphQLObjectTypeBuilder) {
        Collection graphQLDTOContributors = this._graphQLDTOContributorServiceTrackerMap.values();
        if (graphQLDTOContributors.isEmpty()) {
            return;
        }
        String namespace = "c";
        GraphQLObjectType.Builder queryGraphQLObjectTypeBuilder = new GraphQLObjectType.Builder();
        queryGraphQLObjectTypeBuilder.name(namespace);
        GraphQLObjectType.Builder mutationGraphQLObjectTypeBuilder = new GraphQLObjectType.Builder();
        mutationGraphQLObjectTypeBuilder.name("Mutation" + namespace);
        for (GraphQLDTOContributor graphQLDTOContributor : graphQLDTOContributors) {
            if (companyId != graphQLDTOContributor.getCompanyId()) continue;
            this._registerGraphQLDTOContributor(graphQLDTOContributor, graphQLSchemaBuilder, mutationGraphQLObjectTypeBuilder, "Mutation" + namespace, namespace, processingElementsContainer, queryGraphQLObjectTypeBuilder);
        }
        rootQueryGraphQLObjectTypeBuilder.field(GraphQLServletExtender._addField((GraphQLOutputType)queryGraphQLObjectTypeBuilder.build(), namespace, new GraphQLArgument[0]));
        rootMutationGraphQLObjectTypeBuilder.field(GraphQLServletExtender._addField((GraphQLOutputType)mutationGraphQLObjectTypeBuilder.build(), namespace, new GraphQLArgument[0]));
        GraphQLCodeRegistry.Builder graphQLCodeRegistryBuilder = processingElementsContainer.getCodeRegistryBuilder();
        graphQLSchemaBuilder.codeRegistry(graphQLCodeRegistryBuilder.dataFetcher(FieldCoordinates.coordinates((String)"query", (String)namespace), dataFetchingEnvironment -> new Object()).build());
        graphQLSchemaBuilder.codeRegistry(graphQLCodeRegistryBuilder.dataFetcher(FieldCoordinates.coordinates((String)"mutation", (String)namespace), dataFetchingEnvironment -> new Object()).build());
    }

    private GraphQLInterfaceType _registerInterfaces(GraphQLSchema.Builder graphQLSchemaBuilder, ProcessingElementsContainer processingElementsContainer, GraphQLObjectType.Builder queryGraphQLObjectTypeBuilder) {
        try {
            Map graphQLTypes = processingElementsContainer.getTypeRegistry();
            GraphQLInterfaceType graphQLInterfaceType = this._createNodeGraphQLInterfaceType();
            graphQLTypes.put("GraphQLNode", graphQLInterfaceType);
            queryGraphQLObjectTypeBuilder.field(this._createNodeGraphQLFieldDefinition((GraphQLOutputType)graphQLInterfaceType));
            GraphQLCodeRegistry.Builder graphQLCodeRegistryBuilder = processingElementsContainer.getCodeRegistryBuilder();
            graphQLSchemaBuilder.codeRegistry(graphQLCodeRegistryBuilder.dataFetcher(FieldCoordinates.coordinates((String)"query", (String)"graphQLNode"), (DataFetcher)new NodeDataFetcher()).typeResolver("GraphQLNode", (TypeResolver)new GraphQLNodeTypeResolver()).build());
            return graphQLInterfaceType;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void _registerNamespace(Function<ServletData, Object> function, GraphQLObjectType.Builder graphQLObjectTypeBuilder, GraphQLSchema.Builder graphQLSchemaBuilder, boolean mutation, ProcessingElementsContainer processingElementsContainer, List<ServletData> servletDatas) {
        for (ServletData servletData : servletDatas) {
            Object query;
            Class<?> clazz;
            List methods;
            String graphQLNamespace = servletData.getGraphQLNamespace();
            if (graphQLNamespace == null || ListUtil.isEmpty((List)(methods = TransformUtil.transformToList((Object[])(clazz = (query = function.apply(servletData)).getClass()).getMethods(), method -> {
                if (this._isMethodEnabled((Method)method, servletData.getPath())) {
                    return method;
                }
                return null;
            })))) continue;
            GraphQLObjectType.Builder builder = new GraphQLObjectType.Builder();
            String prefix = "";
            if (mutation) {
                prefix = "Mutation";
            }
            builder.name(prefix + StringUtil.upperCaseFirstLetter((String)graphQLNamespace));
            GraphQLCodeRegistry.Builder graphQLCodeRegistryBuilder = processingElementsContainer.getCodeRegistryBuilder();
            for (Method method2 : methods) {
                builder.field(this._graphQLFieldRetriever.getField(clazz.getSimpleName(), method2, processingElementsContainer));
                graphQLSchemaBuilder.codeRegistry(graphQLCodeRegistryBuilder.dataFetcher(FieldCoordinates.coordinates((String)graphQLNamespace, (String)method2.getName()), (DataFetcher)new LiferayMethodDataFetcher(this._liferayMethodDataFetchingProcessor, method2)).build());
            }
            graphQLObjectTypeBuilder.field(GraphQLServletExtender._addField((GraphQLOutputType)builder.build(), graphQLNamespace, new GraphQLArgument[0]));
            String parentField = "query";
            if (mutation) {
                parentField = "mutation";
            }
            graphQLSchemaBuilder.codeRegistry(graphQLCodeRegistryBuilder.dataFetcher(FieldCoordinates.coordinates((String)parentField, (String)graphQLNamespace), dataFetchingEnvironment -> new Object()).build());
        }
    }

    private void _replaceFieldDefinition(GraphQLInterfaceType graphQLInterfaceType, GraphQLObjectType graphQLObjectType, GraphQLObjectType.Builder graphQLObjectTypeBuilder) {
        for (GraphQLFieldDefinition graphQLFieldDefinition : graphQLObjectType.getFieldDefinitions()) {
            GraphQLOutputType graphQLOutputType = graphQLFieldDefinition.getType();
            String typeName = GraphQLTypeUtil.simplePrint((GraphQLType)graphQLOutputType);
            if (typeName == null || !typeName.equals("Object") || !StringUtil.endsWith((String)graphQLFieldDefinition.getName(), (String)"Id")) continue;
            GraphQLFieldDefinition.Builder newGraphQLFieldDefinitionBuilder = GraphQLFieldDefinition.newFieldDefinition((GraphQLFieldDefinition)graphQLFieldDefinition);
            graphQLObjectTypeBuilder.field(newGraphQLFieldDefinitionBuilder.type((GraphQLOutputType)graphQLInterfaceType).build());
        }
    }

    private void _replaceFieldNodes(GraphQLCodeRegistry.Builder graphQLCodeRegistryBuilder, GraphQLInterfaceType graphQLInterfaceType, GraphQLObjectType graphQLObjectType, GraphQLObjectType.Builder graphQLObjectTypeBuilder) {
        GraphQLFieldDefinition graphQLFieldDefinition = graphQLObjectType.getFieldDefinition("contentType");
        if (graphQLFieldDefinition == null) {
            return;
        }
        GraphQLFieldDefinition.Builder graphQLFieldDefinitionBuilder = GraphQLFieldDefinition.newFieldDefinition().name("graphQLNode").type((GraphQLOutputType)graphQLInterfaceType);
        graphQLObjectTypeBuilder.field(graphQLFieldDefinitionBuilder.build());
        graphQLCodeRegistryBuilder.dataFetcher(FieldCoordinates.coordinates((String)graphQLObjectType.getName(), (String)"graphQLNode"), (DataFetcher)new GraphQLNodePropertyDataFetcher()).typeResolver("GraphQLNode", (TypeResolver)new GraphQLNodeTypeResolver()).build();
    }

    private GraphQLType _toGraphQLType(Class<?> clazz, Map<String, GraphQLType> graphQLTypes, boolean input) {
        if (Boolean.class.equals(clazz)) {
            return Scalars.GraphQLBoolean;
        }
        if (Date.class.equals(clazz)) {
            return _dateGraphQLScalarType;
        }
        if (Integer.class.equals(clazz)) {
            return Scalars.GraphQLInt;
        }
        if (Long.class.equals(clazz)) {
            return ExtendedScalars.GraphQLLong;
        }
        if (Map.class.equals(clazz)) {
            return _mapGraphQLScalarType;
        }
        if (String.class.equals(clazz)) {
            return Scalars.GraphQLString;
        }
        String key = (input ? "Input" : "") + clazz.getSimpleName();
        if (graphQLTypes.containsKey(key)) {
            return graphQLTypes.get(key);
        }
        key = (input ? "Input" : "") + StringUtil.replace((String)clazz.getName(), (char)'.', (char)'_');
        if (graphQLTypes.containsKey(key)) {
            return graphQLTypes.get(key);
        }
        return _mapGraphQLScalarType;
    }

    static {
        GraphQLScalarType.Builder dateBuilder = new GraphQLScalarType.Builder();
        _dateGraphQLScalarType = dateBuilder.name("Date").description("An RFC-3339 compliant date time scalar").coercing((Coercing)new Coercing<Date, String>(){

            public Date parseLiteral(Object value) throws CoercingParseLiteralException {
                return this._toDate(value);
            }

            public Date parseValue(Object value) throws CoercingParseValueException {
                return this._toDate(value);
            }

            public String serialize(Object value) throws CoercingSerializeException {
                if (value instanceof Date) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                    return simpleDateFormat.format((Date)value);
                }
                return value.toString();
            }

            private Date _toDate(Object value) {
                if (value instanceof Date) {
                    return (Date)value;
                }
                if (value instanceof StringValue) {
                    StringValue stringValue = (StringValue)value;
                    Calendar calendar = DatatypeConverter.parseDateTime((String)stringValue.getValue());
                    return calendar.getTime();
                }
                Calendar calendar = DatatypeConverter.parseDateTime((String)value.toString());
                return calendar.getTime();
            }
        }).build();
        GraphQLScalarType.Builder objectBuilder = new GraphQLScalarType.Builder();
        _mapGraphQLScalarType = objectBuilder.name("Map").description("Any kind of object supported by a Map").coercing((Coercing)new Coercing<Object, Object>(){

            public Object parseLiteral(Object value) throws CoercingParseLiteralException {
                return value;
            }

            public Object parseValue(Object value) throws CoercingParseValueException {
                return value;
            }

            public Object serialize(Object value) throws CoercingSerializeException {
                return value;
            }
        }).build();
        _objectGraphQLScalarType = objectBuilder.name("Object").description("Any kind of object supported by basic scalar types").coercing((Coercing)new Coercing<Object, Object>(){

            public Object parseLiteral(Object value) throws CoercingParseLiteralException {
                if (value instanceof ArrayValue) {
                    ArrayValue arrayValue = (ArrayValue)value;
                    List values = arrayValue.getValues();
                    Stream stream = values.stream();
                    return stream.map(this::parseLiteral).collect(Collectors.toList());
                }
                if (value instanceof BooleanValue) {
                    BooleanValue booleanValue = (BooleanValue)value;
                    return booleanValue.isValue();
                }
                if (value instanceof EnumValue) {
                    EnumValue enumValue = (EnumValue)value;
                    return enumValue.getName();
                }
                if (value instanceof FloatValue) {
                    FloatValue floatValue = (FloatValue)value;
                    return floatValue.getValue();
                }
                if (value instanceof IntValue) {
                    IntValue intValue = (IntValue)value;
                    return intValue.getValue();
                }
                if (value instanceof NullValue) {
                    return null;
                }
                if (value instanceof ObjectValue) {
                    ObjectValue objectValue = (ObjectValue)value;
                    List objectFields = objectValue.getObjectFields();
                    Stream stream = objectFields.stream();
                    return stream.collect(Collectors.toMap(ObjectField::getName, objectField -> this.parseLiteral(objectField.getValue())));
                }
                if (value instanceof StringValue) {
                    StringValue stringValue = (StringValue)value;
                    return stringValue.getValue();
                }
                throw new CoercingSerializeException("Unable to parse " + value);
            }

            public Object parseValue(Object value) throws CoercingParseValueException {
                return value;
            }

            public Object serialize(Object value) throws CoercingSerializeException {
                return value;
            }
        }).build();
    }

    private class ServletDataServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<ServletData, ServletData> {
        private ServletDataServiceTrackerCustomizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServletData addingService(ServiceReference<ServletData> serviceReference) {
            ServletData servletData = (ServletData)GraphQLServletExtender.this._bundleContext.getService(serviceReference);
            List list = GraphQLServletExtender.this._servletDataList;
            synchronized (list) {
                GraphQLServletExtender.this._servletDataList.add(servletData);
                GraphQLServletExtender.this._servlets.clear();
            }
            return servletData;
        }

        public void modifiedService(ServiceReference<ServletData> serviceReference, ServletData servletData) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference<ServletData> serviceReference, ServletData servletData) {
            List list = GraphQLServletExtender.this._servletDataList;
            synchronized (list) {
                GraphQLServletExtender.this._servletDataList.remove(servletData);
                GraphQLServletExtender.this._servlets.clear();
            }
            GraphQLServletExtender.this._bundleContext.ungetService(serviceReference);
        }
    }

    private class LiferayGraphQLTypeVisitor
    extends GraphQLTypeVisitorStub {
        private final GraphQLInterfaceType _graphQLInterfaceType;

        public LiferayGraphQLTypeVisitor(GraphQLInterfaceType graphQLInterfaceType) {
            this._graphQLInterfaceType = graphQLInterfaceType;
        }

        public TraversalControl visitGraphQLObjectType(GraphQLObjectType graphQLObjectType, TraverserContext<GraphQLSchemaElement> traverserContext) {
            GraphQLFieldDefinition idGraphQLFieldDefinition = graphQLObjectType.getFieldDefinition("id");
            if (idGraphQLFieldDefinition == null || idGraphQLFieldDefinition.getType() != ExtendedScalars.GraphQLLong) {
                return TraversalControl.CONTINUE;
            }
            return this.changeNode(traverserContext, (GraphQLSchemaElement)graphQLObjectType.transform(graphQLObjectTypeBuilder -> {
                GraphQLServletExtender.this._replaceFieldDefinition(this._graphQLInterfaceType, graphQLObjectType, graphQLObjectTypeBuilder);
                GraphQLServletExtender.this._replaceFieldNodes((GraphQLCodeRegistry.Builder)traverserContext.getVarFromParents(GraphQLCodeRegistry.Builder.class), this._graphQLInterfaceType, graphQLObjectType, graphQLObjectTypeBuilder);
                graphQLObjectTypeBuilder.withInterface(this._graphQLInterfaceType);
            }));
        }
    }

    private class LiferayGraphQLFieldRetriever
    extends GraphQLFieldRetriever {
        private LiferayGraphQLFieldRetriever() {
        }

        public GraphQLFieldDefinition getField(String parentName, Field field, ProcessingElementsContainer processingElementsContainer) throws GraphQLAnnotationsException {
            GraphQLFieldDefinition.Builder graphQLFieldDefinitionBuilder = GraphQLFieldDefinition.newFieldDefinition();
            graphQLFieldDefinitionBuilder.deprecate(new DeprecateBuilder((AccessibleObject)field).build());
            GraphQLField graphQLField = field.getAnnotation(GraphQLField.class);
            if (graphQLField != null) {
                graphQLFieldDefinitionBuilder.description(graphQLField.description());
            }
            graphQLFieldDefinitionBuilder.name(new FieldNameBuilder(field).build());
            graphQLFieldDefinitionBuilder.type((GraphQLOutputType)GraphQLServletExtender.this._defaultTypeFunction.buildType(field.getType(), field.getAnnotatedType(), processingElementsContainer));
            return graphQLFieldDefinitionBuilder.build();
        }

        public GraphQLFieldDefinition getField(String parentName, Method method, ProcessingElementsContainer processingElementsContainer) {
            GraphQLFieldDefinition.Builder graphQLFieldDefinitionBuilder = GraphQLFieldDefinition.newFieldDefinition();
            MethodTypeBuilder methodTypeBuilder = new MethodTypeBuilder(method, processingElementsContainer.getDefaultTypeFunction(), processingElementsContainer, false);
            GraphQLOutputType graphQLOutputType = (GraphQLOutputType)methodTypeBuilder.build();
            LiferayArgumentBuilder argumentBuilder = new LiferayArgumentBuilder(graphQLFieldDefinitionBuilder, graphQLOutputType, method, processingElementsContainer, processingElementsContainer.getDefaultTypeFunction());
            graphQLFieldDefinitionBuilder.arguments(argumentBuilder.build());
            graphQLFieldDefinitionBuilder.dataFetcher((DataFetcher)new LiferayMethodDataFetcher(GraphQLServletExtender.this._liferayMethodDataFetchingProcessor, method));
            LiferayDeprecateBuilder deprecateBuilder = new LiferayDeprecateBuilder(method);
            graphQLFieldDefinitionBuilder.deprecate(deprecateBuilder.build());
            GraphQLField graphQLField = method.getAnnotation(GraphQLField.class);
            if (graphQLField != null) {
                graphQLFieldDefinitionBuilder.description(graphQLField.description());
            }
            MethodNameBuilder methodNameBuilder = new MethodNameBuilder(method);
            graphQLFieldDefinitionBuilder.name(methodNameBuilder.build());
            graphQLFieldDefinitionBuilder.type(graphQLOutputType);
            return graphQLFieldDefinitionBuilder.build();
        }
    }

    private static class SanitizedDataFetcherExceptionHandler
    implements DataFetcherExceptionHandler {
        private SanitizedDataFetcherExceptionHandler() {
        }

        public DataFetcherExceptionHandlerResult onException(DataFetcherExceptionHandlerParameters dataFetcherExceptionHandlerParameters) {
            DataFetcherExceptionHandlerResult.Builder dataFetcherExceptionHandlerResultBuilder = DataFetcherExceptionHandlerResult.newResult();
            return dataFetcherExceptionHandlerResultBuilder.error((GraphQLError)new ExceptionWhileDataFetching(dataFetcherExceptionHandlerParameters.getPath(), dataFetcherExceptionHandlerParameters.getException(), dataFetcherExceptionHandlerParameters.getSourceLocation())).build();
        }
    }

    private static class ObjectTypeFunction
    implements TypeFunction {
        private ObjectTypeFunction() {
        }

        public GraphQLType buildType(boolean input, Class<?> clazz, AnnotatedType annotatedType, ProcessingElementsContainer processingElementsContainer) {
            return _objectGraphQLScalarType;
        }

        public boolean canBuildType(Class<?> clazz, AnnotatedType annotatedType) {
            return clazz == Float.class || clazz == MultipartBody.class || clazz == Number.class || clazz == Object.class || clazz == Response.class;
        }
    }

    private static class NodeDataFetcher
    implements DataFetcher<Object> {
        private NodeDataFetcher() {
        }

        public Object get(DataFetchingEnvironment dataFetchingEnvironment) throws Exception {
            GraphQLSchema graphQLSchema = dataFetchingEnvironment.getGraphQLSchema();
            GraphQLCodeRegistry graphQLCodeRegistry = graphQLSchema.getCodeRegistry();
            GraphQLFieldDefinition graphQLFieldDefinition = dataFetchingEnvironment.getFieldDefinition();
            String fieldName = this._getFieldName(dataFetchingEnvironment, graphQLSchema);
            DataFetcher dataFetcher = graphQLCodeRegistry.getDataFetcher((GraphQLFieldsContainer)dataFetchingEnvironment.getParentType(), GraphQLServletExtender._addField(graphQLFieldDefinition.getType(), fieldName, new GraphQLArgument[]{graphQLFieldDefinition.getArgument("id")}));
            DataFetchingEnvironmentImpl.Builder dataFetchingEnvironmentBuilder = DataFetchingEnvironmentImpl.newDataFetchingEnvironment((DataFetchingEnvironment)dataFetchingEnvironment);
            return dataFetcher.get(dataFetchingEnvironmentBuilder.arguments(Collections.singletonMap(fieldName + "Id", dataFetchingEnvironment.getArgument("id"))).build());
        }

        private String _getFieldName(DataFetchingEnvironment dataFetchingEnvironment, GraphQLSchema graphQLSchema) {
            Map graphQLNamedTypes = graphQLSchema.getTypeMap();
            GraphQLNamedType graphQLNamedType = (GraphQLNamedType)graphQLNamedTypes.get(dataFetchingEnvironment.getArgument("dataType"));
            return StringUtil.lowerCaseFirstLetter((String)graphQLNamedType.getName());
        }
    }

    private static class MapTypeFunction
    implements TypeFunction {
        private MapTypeFunction() {
        }

        public GraphQLType buildType(boolean input, Class<?> clazz, AnnotatedType annotatedType, ProcessingElementsContainer processingElementsContainer) {
            return _mapGraphQLScalarType;
        }

        public boolean canBuildType(Class<?> clazz, AnnotatedType annotatedType) {
            return clazz == Map.class;
        }
    }

    private static class LiferayGraphQLErrorHandler
    implements GraphQLErrorHandler {
        private LiferayGraphQLErrorHandler() {
        }

        public List<GraphQLError> processErrors(List<GraphQLError> graphQLErrors) {
            Stream stream = graphQLErrors.stream();
            return stream.filter(graphQLError -> !this._isNotFoundException((GraphQLError)graphQLError) || this._isRequiredField((GraphQLError)graphQLError)).map(graphQLError -> {
                String message = graphQLError.getMessage();
                if (message.contains("SecurityException")) {
                    return this._getExtendedGraphQLError((GraphQLError)graphQLError, Response.Status.UNAUTHORIZED);
                }
                if (this._isNotFoundException((GraphQLError)graphQLError)) {
                    return this._getExtendedGraphQLError((GraphQLError)graphQLError, Response.Status.NOT_FOUND);
                }
                if (!this._isClientErrorException((GraphQLError)graphQLError)) {
                    return this._getExtendedGraphQLError((GraphQLError)graphQLError, Response.Status.INTERNAL_SERVER_ERROR);
                }
                return this._getExtendedGraphQLError((GraphQLError)graphQLError, Response.Status.BAD_REQUEST);
            }).collect(Collectors.toList());
        }

        private GraphQLError _getExtendedGraphQLError(GraphQLError graphQLError, Response.Status status) {
            GraphqlErrorBuilder graphqlErrorBuilder = GraphqlErrorBuilder.newError();
            return graphqlErrorBuilder.message(StringUtil.removeSubstring((String)graphQLError.getMessage(), (String)"%"), new Object[0]).extensions((Map)HashMapBuilder.put((Object)"code", (Object)status.getReasonPhrase()).put((Object)"exception", (Object)HashMapBuilder.put((Object)"errno", (Object)status.getStatusCode()).build()).build()).build();
        }

        private boolean _isClientErrorException(GraphQLError graphQLError) {
            if (graphQLError instanceof ExceptionWhileDataFetching) {
                ExceptionWhileDataFetching exceptionWhileDataFetching = (ExceptionWhileDataFetching)graphQLError;
                return exceptionWhileDataFetching.getException() instanceof GraphQLError;
            }
            String message = graphQLError.getMessage();
            return !(graphQLError instanceof Throwable) || message.contains("ClientErrorException");
        }

        private boolean _isNotFoundException(GraphQLError graphQLError) {
            if (!(graphQLError instanceof ExceptionWhileDataFetching)) {
                return false;
            }
            ExceptionWhileDataFetching exceptionWhileDataFetching = (ExceptionWhileDataFetching)graphQLError;
            Throwable throwable = exceptionWhileDataFetching.getException();
            return throwable != null && (throwable.getCause() instanceof NotFoundException || throwable.getCause() instanceof NoSuchModelException);
        }

        private boolean _isRequiredField(GraphQLError graphQLError) {
            List path = Optional.ofNullable(graphQLError.getPath()).orElse(Collections.emptyList());
            if (path.size() <= 1) {
                return true;
            }
            return StringUtil.containsIgnoreCase((String)((String)path.get(path.size() - 1)), (String)"parent");
        }
    }

    private static class LiferayDeprecateBuilder
    extends DeprecateBuilder {
        private final AccessibleObject _accessibleObject;

        public LiferayDeprecateBuilder(AccessibleObject accessibleObject) {
            super(accessibleObject);
            this._accessibleObject = accessibleObject;
        }

        public String build() {
            Deprecated deprecated = this._accessibleObject.getAnnotation(Deprecated.class);
            if (deprecated != null) {
                return "Deprecated";
            }
            return null;
        }
    }

    private static class LiferayArgumentBuilder
    extends ArgumentBuilder {
        private final Method _method;
        private final ProcessingElementsContainer _processingElementsContainer;
        private final TypeFunction _typeFunction;

        public LiferayArgumentBuilder(GraphQLFieldDefinition.Builder graphQLFieldDefinitionBuilder, GraphQLOutputType graphQLOutputType, Method method, ProcessingElementsContainer processingElementsContainer, TypeFunction typeFunction) {
            super(method, typeFunction, graphQLFieldDefinitionBuilder, processingElementsContainer, graphQLOutputType);
            this._method = method;
            this._processingElementsContainer = processingElementsContainer;
            this._typeFunction = typeFunction;
        }

        public List<GraphQLArgument> build() {
            Stream<Parameter> stream = Arrays.stream(this._method.getParameters());
            return stream.filter(parameter -> !DataFetchingEnvironment.class.isAssignableFrom(parameter.getType())).map(parameter -> {
                if (MultipartUtil.isMultipartBody(parameter)) {
                    GraphQLArgument.Builder graphQLArgumentBuilder = new GraphQLArgument.Builder();
                    return graphQLArgumentBuilder.type((GraphQLInputType)new GraphQLList((GraphQLType)ApolloScalars.Upload)).name("multipartBody").build();
                }
                return this._createGraphQLArgument((Parameter)parameter, (GraphQLInputType)this._typeFunction.buildType(true, parameter.getType(), parameter.getAnnotatedType(), this._processingElementsContainer));
            }).collect(Collectors.toList());
        }

        private GraphQLArgument _createGraphQLArgument(Parameter parameter, GraphQLInputType graphQLInputType) throws GraphQLAnnotationsException {
            GraphQLArgument.Builder graphQLArgumentBuilder = GraphQLArgument.newArgument();
            String graphQLName = GraphQLUtil.getGraphQLNameValue(parameter);
            if (graphQLName != null) {
                graphQLArgumentBuilder.name(NamingKit.toGraphqlName((String)graphQLName));
            } else {
                graphQLArgumentBuilder.name(NamingKit.toGraphqlName((String)parameter.getName()));
            }
            graphQLArgumentBuilder.type(graphQLInputType);
            DirectivesBuilder directivesBuilder = new DirectivesBuilder((AnnotatedElement)parameter, this._processingElementsContainer);
            graphQLArgumentBuilder.withDirectives(directivesBuilder.build());
            return graphQLArgumentBuilder.build();
        }
    }

    private static class GraphQLNodeTypeResolver
    implements TypeResolver {
        private GraphQLNodeTypeResolver() {
        }

        public GraphQLObjectType getType(TypeResolutionEnvironment typeResolutionEnvironment) {
            GraphQLSchema graphQLSchema = typeResolutionEnvironment.getSchema();
            Map graphQLNamedTypes = graphQLSchema.getTypeMap();
            GraphQLNamedType graphQLNamedType = (GraphQLNamedType)graphQLNamedTypes.get(this._getClassName(typeResolutionEnvironment.getObject()));
            return (GraphQLObjectType)graphQLNamedType;
        }

        private String _getClassName(Object object) {
            Class<?> clazz = object.getClass();
            String name = clazz.getName();
            if (!name.contains("$")) {
                return clazz.getSimpleName();
            }
            Class<?> parentClass = clazz.getSuperclass();
            return parentClass.getSimpleName();
        }
    }

    private static class GraphQLNodePropertyDataFetcher
    implements DataFetcher<Object> {
        private GraphQLNodePropertyDataFetcher() {
        }

        public Object get(DataFetchingEnvironment dataFetchingEnvironment) throws Exception {
            Method[] methods;
            GraphQLSchema graphQLSchema = dataFetchingEnvironment.getGraphQLSchema();
            GraphQLCodeRegistry graphQLCodeRegistry = graphQLSchema.getCodeRegistry();
            Map graphQLNamedTypes = graphQLSchema.getTypeMap();
            Object source = dataFetchingEnvironment.getSource();
            Class<?> clazz = source.getClass();
            Method getContentTypeMethod = clazz.getMethod("getContentType", new Class[0]);
            String fieldName = StringUtil.lowerCaseFirstLetter((String)((String)getContentTypeMethod.invoke(source, new Object[0])));
            GraphQLFieldDefinition graphQLFieldDefinition = dataFetchingEnvironment.getFieldDefinition();
            DataFetcher dataFetcher = graphQLCodeRegistry.getDataFetcher((GraphQLFieldsContainer)graphQLNamedTypes.get("query"), GraphQLServletExtender._addField(graphQLFieldDefinition.getType(), fieldName, new GraphQLArgument[0]));
            DataFetchingEnvironmentImpl.Builder dataFetchingEnvironmentBuilder = DataFetchingEnvironmentImpl.newDataFetchingEnvironment((DataFetchingEnvironment)dataFetchingEnvironment);
            Method method = clazz.getMethod("getId", new Class[0]);
            for (Method existingMethod : methods = clazz.getMethods()) {
                if (!StringUtil.equals((String)existingMethod.getName(), (String)"getContentId")) continue;
                method = existingMethod;
            }
            return dataFetcher.get(dataFetchingEnvironmentBuilder.arguments(Collections.singletonMap(fieldName + "Id", method.invoke(source, new Object[0]))).build());
        }
    }

    private static class DateTypeFunction
    implements TypeFunction {
        private DateTypeFunction() {
        }

        public GraphQLType buildType(boolean input, Class<?> clazz, AnnotatedType annotatedType, ProcessingElementsContainer processingElementsContainer) {
            return _dateGraphQLScalarType;
        }

        public boolean canBuildType(Class<?> clazz, AnnotatedType annotatedType) {
            return clazz == Date.class;
        }
    }
}

