/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.graphql.data.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.depot.service.DepotEntryLocalService;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.graphql.contributor.GraphQLContributor;
import com.liferay.portal.vulcan.graphql.servlet.ServletData;
import com.liferay.portal.vulcan.internal.accept.language.AcceptLanguageImpl;
import com.liferay.portal.vulcan.internal.graphql.servlet.ServletDataAdapter;
import com.liferay.portal.vulcan.internal.graphql.util.GraphQLUtil;
import com.liferay.portal.vulcan.internal.jaxrs.context.provider.AggregationContextProvider;
import com.liferay.portal.vulcan.internal.jaxrs.context.provider.ContextProviderUtil;
import com.liferay.portal.vulcan.internal.jaxrs.context.provider.FilterContextProvider;
import com.liferay.portal.vulcan.internal.jaxrs.context.provider.SortContextProvider;
import com.liferay.portal.vulcan.internal.jaxrs.validation.ValidationUtil;
import com.liferay.portal.vulcan.internal.multipart.MultipartUtil;
import com.liferay.portal.vulcan.multipart.BinaryFile;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.GroupUtil;
import graphql.annotations.processor.util.NamingKit;
import graphql.annotations.processor.util.ReflectionKit;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import javax.validation.ValidationException;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={LiferayMethodDataFetchingProcessor.class})
public class LiferayMethodDataFetchingProcessor {
    private static final Log _log = LogFactoryUtil.getLog(LiferayMethodDataFetchingProcessor.class);
    private static final ObjectMapper _objectMapper = new ObjectMapper();
    private BundleContext _bundleContext;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private DepotEntryLocalService _depotEntryLocalService;
    @Reference(target="(result.class.name=com.liferay.portal.kernel.search.filter.Filter)")
    private ExpressionConvert<Filter> _expressionConvert;
    @Reference
    private FilterParserProvider _filterParserProvider;
    private ServiceTracker<GraphQLContributor, GraphQLContributor> _graphQLContributorServiceTracker;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;
    @Reference
    private ResourceActionLocalService _resourceActionLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private SortParserProvider _sortParserProvider;
    @Reference
    private VulcanBatchEngineImportTaskResource _vulcanBatchEngineImportTaskResource;

    public Object process(Map<String, Object> arguments, String fieldName, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Method method, Object root, Object source) throws Exception {
        Parameter[] parameters = method.getParameters();
        Object[] argumentArray = new Object[parameters.length];
        MultivaluedHashMap instanceArguments = new MultivaluedHashMap();
        for (int i = 0; i < parameters.length; ++i) {
            List parts;
            Parameter parameter = parameters[i];
            String parameterName = null;
            String graphQLName = GraphQLUtil.getGraphQLNameValue(parameter);
            parameterName = graphQLName == null ? NamingKit.toGraphqlName((String)parameter.getName()) : NamingKit.toGraphqlName((String)graphQLName);
            Object argument = arguments.get(parameterName);
            if (argument == null) {
                if (parameter.isAnnotationPresent(NotNull.class)) {
                    throw new ValidationException(parameterName + " is null");
                }
                if (parameterName.equals("page")) {
                    argument = 1;
                } else if (parameterName.equals("pageSize")) {
                    argument = 20;
                }
            }
            if (parameterName.equals("assetLibraryId") && argument != null) {
                try {
                    argument = String.valueOf(GroupUtil.getDepotGroupId((String)((String)argument), (long)CompanyThreadLocal.getCompanyId(), (DepotEntryLocalService)this._depotEntryLocalService, (GroupLocalService)this._groupLocalService));
                    instanceArguments.putSingle((Object)"assetLibraryId", (Object)((String)argument));
                }
                catch (Exception exception) {
                    throw new Exception("Unable to convert asset library \"" + argument + "\" to group ID", exception);
                }
            }
            if (parameterName.equals("siteKey") && argument != null) {
                try {
                    argument = String.valueOf(GroupUtil.getGroupId((long)CompanyThreadLocal.getCompanyId(), (String)((String)argument), (GroupLocalService)this._groupLocalService));
                    instanceArguments.putSingle((Object)"siteId", (Object)((String)argument));
                }
                catch (Exception exception) {
                    throw new Exception("Unable to convert site key \"" + argument + "\" to group ID", exception);
                }
            }
            if (MultipartUtil.isMultipartBody(parameter) && (parts = (List)argument) != null && !parts.isEmpty()) {
                Part metadataPart;
                String metadata;
                int index;
                HashMap binaryFiles = HashMapBuilder.put((Object)"file", () -> {
                    Part part = (Part)parts.get(0);
                    return new BinaryFile(part.getContentType(), MultipartUtil.getFileName(part), part.getInputStream(), part.getSize());
                }).build();
                HashMap<String, String> values = new HashMap<String, String>();
                if (parts.size() > 1 && (index = (metadata = StringUtil.read((InputStream)(metadataPart = (Part)parts.get(1)).getInputStream())).indexOf("=")) != -1) {
                    values.put(metadata.substring(0, index), metadata.substring(index + 1));
                }
                argument = MultipartBody.of((Map)binaryFiles, __ -> _objectMapper, values);
            }
            Class<Map> parameterClass = parameter.getClass();
            if (argument instanceof Map && !parameterClass.isAssignableFrom(Map.class)) {
                argument = _objectMapper.convertValue(argument, parameter.getType());
                ValidationUtil.validate(argument);
            }
            argumentArray[i] = argument;
        }
        Object instance = null;
        Class<?> declaringClass = method.getDeclaringClass();
        Class<?> contributorClass = this._getContributorClass(declaringClass);
        if (contributorClass != null) {
            instance = this._getContributorInstance(arguments, contributorClass, declaringClass, httpServletRequest, httpServletResponse, (MultivaluedMap<String, String>)instanceArguments, source);
        } else {
            Field field = this._getThisField(declaringClass);
            if (root == source || Objects.equals(fieldName, "graphQLNode") || field == null) {
                instance = this._fillQueryInstance(arguments, httpServletRequest, httpServletResponse, declaringClass.newInstance(), (MultivaluedMap<String, String>)instanceArguments);
            } else {
                Constructor<?>[] constructors = declaringClass.getConstructors();
                Class<?> typeClass = field.getType();
                Object queryInstance = this._fillQueryInstance(arguments, httpServletRequest, httpServletResponse, typeClass.newInstance(), (MultivaluedMap<String, String>)instanceArguments);
                instance = ReflectionKit.constructNewInstance(constructors[0], (Object[])new Object[]{queryInstance, source});
            }
        }
        ValidationUtil.validateArguments(instance, method, argumentArray);
        return method.invoke(instance, argumentArray);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._graphQLContributorServiceTracker = new ServiceTracker(bundleContext, GraphQLContributor.class, (ServiceTrackerCustomizer)new GraphQLContributorServiceTrackerCustomizer());
        this._graphQLContributorServiceTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._graphQLContributorServiceTracker.close();
    }

    private Message _createMessage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        MessageImpl message = new MessageImpl();
        String requestURL = String.valueOf(httpServletRequest.getRequestURL());
        message.put((Object)Message.ENDPOINT_ADDRESS, (Object)requestURL);
        String contextPath = GetterUtil.getString((String)httpServletRequest.getContextPath());
        String servletPath = GetterUtil.getString((String)httpServletRequest.getServletPath());
        message.put((Object)Message.PATH_INFO, (Object)(contextPath + servletPath + httpServletRequest.getPathInfo()));
        message.put((Object)Message.QUERY_STRING, (Object)httpServletRequest.getQueryString());
        message.put((Object)"Accept", (Object)httpServletRequest.getHeader("Accept"));
        message.put((Object)"Content-Type", (Object)httpServletRequest.getContentType());
        message.put((Object)"HTTP.REQUEST", (Object)httpServletRequest);
        message.put((Object)"HTTP.RESPONSE", (Object)httpServletResponse);
        message.put((Object)"org.apache.cxf.async.post.response.dispatch", (Object)true);
        message.put((Object)"org.apache.cxf.request.method", (Object)httpServletRequest.getMethod());
        message.put((Object)"org.apache.cxf.request.uri", (Object)httpServletRequest.getRequestURI());
        message.put((Object)"org.apache.cxf.request.url", (Object)requestURL);
        message.put((Object)"http.base.path", (Object)this._getBasePath(contextPath, httpServletRequest.getRequestURI(), requestURL, servletPath));
        message.setExchange((Exchange)new ExchangeImpl());
        return message;
    }

    private Object _fillQueryInstance(Map<String, Object> arguments, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object instance, MultivaluedMap<String, String> instanceArguments) throws Exception {
        Class<?> clazz = instance.getClass();
        AcceptLanguageImpl acceptLanguage = new AcceptLanguageImpl(httpServletRequest, this._language, this._portal);
        for (Field field : clazz.getDeclaredFields()) {
            if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
            Class<Object> fieldClass = field.getType();
            if (fieldClass.equals(Object.class) && Objects.equals(field.getName(), "contextScopeChecker")) {
                field.setAccessible(true);
                field.set(instance, this._getScopeChecker());
                continue;
            }
            if (fieldClass.isAssignableFrom(AcceptLanguage.class)) {
                field.setAccessible(true);
                field.set(instance, acceptLanguage);
                continue;
            }
            if (fieldClass.isAssignableFrom(Company.class)) {
                field.setAccessible(true);
                field.set(instance, this._companyLocalService.getCompany(CompanyThreadLocal.getCompanyId().longValue()));
                continue;
            }
            if (fieldClass.isAssignableFrom(GroupLocalService.class)) {
                field.setAccessible(true);
                field.set(instance, this._groupLocalService);
                continue;
            }
            if (fieldClass.isAssignableFrom(HttpServletRequest.class)) {
                field.setAccessible(true);
                field.set(instance, httpServletRequest);
                continue;
            }
            if (fieldClass.isAssignableFrom(HttpServletResponse.class)) {
                field.setAccessible(true);
                field.set(instance, httpServletResponse);
                continue;
            }
            if (fieldClass.isAssignableFrom(ResourceActionLocalService.class)) {
                field.setAccessible(true);
                field.set(instance, this._resourceActionLocalService);
                continue;
            }
            if (fieldClass.isAssignableFrom(ResourcePermissionLocalService.class)) {
                field.setAccessible(true);
                field.set(instance, this._resourcePermissionLocalService);
                continue;
            }
            if (fieldClass.isAssignableFrom(RoleLocalService.class)) {
                field.setAccessible(true);
                field.set(instance, this._roleLocalService);
                continue;
            }
            if (fieldClass.isAssignableFrom(UriInfo.class)) {
                field.setAccessible(true);
                field.set(instance, new UriInfoImpl(this._createMessage(httpServletRequest, httpServletResponse), instanceArguments));
                continue;
            }
            if (fieldClass.isAssignableFrom(User.class)) {
                field.setAccessible(true);
                field.set(instance, this._portal.getUser(httpServletRequest));
                continue;
            }
            if (fieldClass.isAssignableFrom(VulcanBatchEngineImportTaskResource.class)) {
                field.setAccessible(true);
                field.set(instance, this._vulcanBatchEngineImportTaskResource);
                continue;
            }
            HashMap<String, String[]> parameterMap = new HashMap<String, String[]>(httpServletRequest.getParameterMap());
            for (Map.Entry<String, Object> entry : arguments.entrySet()) {
                parameterMap.put(entry.getKey(), new String[]{String.valueOf(entry.getValue())});
            }
            if (Objects.equals(field.getName(), "_aggregationBiFunction")) {
                field.setAccessible(true);
                BiFunction<Object, List, Aggregation> aggregationBiFunction = (resource, aggregationStrings) -> {
                    try {
                        return this._getAggregation(acceptLanguage, (List<String>)aggregationStrings, this._getEntityModel(resource, parameterMap));
                    }
                    catch (Exception exception) {
                        throw new BadRequestException((Throwable)exception);
                    }
                };
                field.set(instance, aggregationBiFunction);
                continue;
            }
            if (Objects.equals(field.getName(), "_filterBiFunction")) {
                field.setAccessible(true);
                BiFunction<Object, String, Filter> filterBiFunction = (resource, filterString) -> {
                    try {
                        return this._getFilter(acceptLanguage, this._getEntityModel(resource, parameterMap), (String)filterString);
                    }
                    catch (Exception exception) {
                        throw new BadRequestException((Throwable)exception);
                    }
                };
                field.set(instance, filterBiFunction);
                continue;
            }
            if (!Objects.equals(field.getName(), "_sortsBiFunction")) continue;
            field.setAccessible(true);
            BiFunction<Object, String, Sort[]> sortsBiFunction = (resource, sortsString) -> {
                try {
                    return this._getSorts(acceptLanguage, this._getEntityModel(resource, parameterMap), (String)sortsString);
                }
                catch (Exception exception) {
                    throw new BadRequestException((Throwable)exception);
                }
            };
            field.set(instance, sortsBiFunction);
        }
        return instance;
    }

    private Aggregation _getAggregation(AcceptLanguage acceptLanguage, List<String> aggregationStrings, EntityModel entityModel) {
        if (aggregationStrings == null) {
            return null;
        }
        AggregationContextProvider aggregationContextProvider = new AggregationContextProvider(this._language, this._portal);
        return aggregationContextProvider.createContext(acceptLanguage, aggregationStrings.toArray(new String[0]), entityModel);
    }

    private String _getBasePath(String contextPath, String requestURI, String requestURL, String servletPath) {
        int index;
        if (!StringUtils.isEmpty((String)requestURI)) {
            int index2 = requestURL.indexOf(requestURI);
            if (index2 > 0) {
                return requestURL.substring(0, index2) + contextPath;
            }
        } else if (!StringUtils.isEmpty((String)servletPath) && requestURL.endsWith(servletPath) && (index = requestURL.lastIndexOf(servletPath)) > 0) {
            return requestURL.substring(0, index);
        }
        return null;
    }

    private Class<?> _getContributorClass(Class<?> clazz) {
        Class<?> enclosingClass = clazz.getEnclosingClass();
        if (enclosingClass == null) {
            if (GraphQLContributor.class.isAssignableFrom(clazz)) {
                return clazz;
            }
            return null;
        }
        return this._getContributorClass(enclosingClass);
    }

    private Object _getContributorInstance(Map<String, Object> arguments, Class<?> contributorClass, Class<?> declaringClass, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, MultivaluedMap<String, String> instanceArguments, Object source) throws Exception {
        Class<?> queryClass = declaringClass.getEnclosingClass();
        Constructor<?> constructor = queryClass.getConstructors()[0];
        Object[] args = null;
        args = constructor.getParameterCount() == 0 ? new Object[]{} : new Object[]{this._fillQueryInstance(arguments, httpServletRequest, httpServletResponse, this._getService(contributorClass), instanceArguments)};
        Object query = ReflectionKit.constructNewInstance(constructor, (Object[])args);
        constructor = declaringClass.getConstructors()[0];
        args = constructor.getParameterCount() == 1 ? new Object[]{source} : new Object[]{query, source};
        return ReflectionKit.constructNewInstance(constructor, (Object[])args);
    }

    private EntityModel _getEntityModel(Object resource, Map<String, String[]> parameterMap) throws Exception {
        if (resource instanceof EntityModelResource) {
            EntityModelResource entityModelResource = (EntityModelResource)resource;
            return entityModelResource.getEntityModel(ContextProviderUtil.getMultivaluedHashMap(parameterMap));
        }
        return null;
    }

    private Filter _getFilter(AcceptLanguage acceptLanguage, EntityModel entityModel, String filterString) throws Exception {
        FilterContextProvider filterContextProvider = new FilterContextProvider(this._expressionConvert, this._filterParserProvider, this._language, this._portal);
        return filterContextProvider.createContext(acceptLanguage, entityModel, filterString);
    }

    private Object _getScopeChecker() {
        ServiceReference serviceReference = this._bundleContext.getServiceReference("com.liferay.oauth2.provider.scope.ScopeChecker");
        if (serviceReference != null) {
            return this._bundleContext.getService(serviceReference);
        }
        return null;
    }

    private Object _getService(Class<?> clazz) {
        for (Object service : this._graphQLContributorServiceTracker.getServices()) {
            if (!clazz.isAssignableFrom(service.getClass())) continue;
            return service;
        }
        return null;
    }

    private Sort[] _getSorts(AcceptLanguage acceptLanguage, EntityModel entityModel, String sortsString) {
        SortContextProvider sortContextProvider = new SortContextProvider(this._language, this._portal, this._sortParserProvider);
        return sortContextProvider.createContext(acceptLanguage, entityModel, sortsString);
    }

    private Field _getThisField(Class<?> clazz) {
        try {
            return clazz.getDeclaredField("this$0");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchFieldException);
            }
            return null;
        }
    }

    private class GraphQLContributorServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<GraphQLContributor, GraphQLContributor> {
        private final Map<GraphQLContributor, ServiceRegistration<ServletData>> _servletDataServiceRegistrations = new ConcurrentHashMap<GraphQLContributor, ServiceRegistration<ServletData>>();

        private GraphQLContributorServiceTrackerCustomizer() {
        }

        public GraphQLContributor addingService(ServiceReference<GraphQLContributor> serviceReference) {
            GraphQLContributor graphQLContributor = (GraphQLContributor)LiferayMethodDataFetchingProcessor.this._bundleContext.getService(serviceReference);
            ServiceRegistration servletDataServiceRegistration = LiferayMethodDataFetchingProcessor.this._bundleContext.registerService(ServletData.class, (Object)ServletDataAdapter.of(graphQLContributor), null);
            this._servletDataServiceRegistrations.put(graphQLContributor, (ServiceRegistration<ServletData>)servletDataServiceRegistration);
            return graphQLContributor;
        }

        public void modifiedService(ServiceReference<GraphQLContributor> serviceReference, GraphQLContributor graphQLContributor) {
        }

        public void removedService(ServiceReference<GraphQLContributor> serviceReference, GraphQLContributor graphQLContributor) {
            Optional.ofNullable(this._servletDataServiceRegistrations.remove(graphQLContributor)).ifPresent(ServiceRegistration::unregister);
            LiferayMethodDataFetchingProcessor.this._bundleContext.ungetService(serviceReference);
        }
    }
}

