/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.graphql.data.processor;

import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.graphql.dto.GraphQLDTOContributor;
import com.liferay.portal.vulcan.graphql.dto.GraphQLDTOProperty;
import com.liferay.portal.vulcan.internal.accept.language.AcceptLanguageImpl;
import com.liferay.portal.vulcan.internal.jaxrs.context.provider.AggregationContextProvider;
import com.liferay.portal.vulcan.internal.jaxrs.context.provider.FilterContextProvider;
import com.liferay.portal.vulcan.internal.jaxrs.context.provider.SortContextProvider;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={GraphQLDTOContributorDataFetchingProcessor.class})
public class GraphQLDTOContributorDataFetchingProcessor {
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference(target="(result.class.name=com.liferay.portal.kernel.search.filter.Filter)")
    private ExpressionConvert<Filter> _expressionConvert;
    @Reference
    private FilterParserProvider _filterParserProvider;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;
    @Reference
    private SortParserProvider _sortParserProvider;

    public Object create(Object dto, GraphQLDTOContributor graphQLDTOContributor, HttpServletRequest httpServletRequest, String scopeKey) throws Exception {
        return graphQLDTOContributor.createDTO(dto, this._getDTOConverterContext(httpServletRequest, HashMapBuilder.put((Object)"scopeKey", (Object)scopeKey).build()));
    }

    public boolean delete(GraphQLDTOContributor graphQLDTOContributor, long id) throws Exception {
        return graphQLDTOContributor.deleteDTO(id);
    }

    public Object get(GraphQLDTOContributor graphQLDTOContributor, HttpServletRequest httpServletRequest, long id) throws Exception {
        return graphQLDTOContributor.getDTO(this._getDTOConverterContext(httpServletRequest, null), id);
    }

    public Object getRelationship(GraphQLDTOContributor graphQLDTOContributor, GraphQLDTOProperty graphQLDTOProperty, HttpServletRequest httpServletRequest, long id) throws Exception {
        return graphQLDTOContributor.getRelationshipValue(this._getDTOConverterContext(httpServletRequest, null), id, graphQLDTOProperty.getTypeClass(), graphQLDTOProperty.getName());
    }

    public Page<Object> list(List<String> aggregations, String filterString, GraphQLDTOContributor graphQLDTOContributor, HttpServletRequest httpServletRequest, int page, int pageSize, String scopeKey, String search, String sortsString) throws Exception {
        Aggregation aggregation = null;
        AcceptLanguageImpl acceptLanguage = new AcceptLanguageImpl(httpServletRequest, this._language, this._portal);
        if (aggregations != null) {
            aggregation = this._getAggregation(acceptLanguage, aggregations, graphQLDTOContributor.getEntityModel());
        }
        return graphQLDTOContributor.getDTOs(aggregation, this._getDTOConverterContext(httpServletRequest, HashMapBuilder.put((Object)"companyId", (Object)CompanyThreadLocal.getCompanyId()).put((Object)"filter", (Object)filterString).put((Object)"scopeKey", (Object)scopeKey).build()), this._getFilter(acceptLanguage, graphQLDTOContributor.getEntityModel(), filterString), Pagination.of((int)page, (int)pageSize), search, this._getSorts(acceptLanguage, graphQLDTOContributor.getEntityModel(), sortsString));
    }

    public Object update(Object dto, GraphQLDTOContributor graphQLDTOContributor, HttpServletRequest httpServletRequest, long id) throws Exception {
        return graphQLDTOContributor.updateDTO(dto, this._getDTOConverterContext(httpServletRequest, null), id);
    }

    private Aggregation _getAggregation(AcceptLanguage acceptLanguage, List<String> aggregationStrings, EntityModel entityModel) {
        if (aggregationStrings == null) {
            return null;
        }
        AggregationContextProvider aggregationContextProvider = new AggregationContextProvider(this._language, this._portal);
        return aggregationContextProvider.createContext(acceptLanguage, aggregationStrings.toArray(new String[0]), entityModel);
    }

    private DTOConverterContext _getDTOConverterContext(HttpServletRequest httpServletRequest, Map<String, Serializable> attributes) throws Exception {
        AcceptLanguageImpl acceptLanguage = new AcceptLanguageImpl(httpServletRequest, this._language, this._portal);
        DefaultDTOConverterContext defaultDTOConverterContext = new DefaultDTOConverterContext(acceptLanguage.isAcceptAllLanguages(), null, this._dtoConverterRegistry, null, acceptLanguage.getPreferredLocale(), null, this._portal.getUser(httpServletRequest));
        if (attributes != null) {
            defaultDTOConverterContext.setAttributes(attributes);
        }
        return defaultDTOConverterContext;
    }

    private Filter _getFilter(AcceptLanguage acceptLanguage, EntityModel entityModel, String filterString) throws Exception {
        FilterContextProvider filterContextProvider = new FilterContextProvider(this._expressionConvert, this._filterParserProvider, this._language, this._portal);
        return filterContextProvider.createContext(acceptLanguage, entityModel, filterString);
    }

    private Sort[] _getSorts(AcceptLanguage acceptLanguage, EntityModel entityModel, String sortsString) {
        SortContextProvider sortContextProvider = new SortContextProvider(this._language, this._portal, this._sortParserProvider);
        return sortContextProvider.createContext(acceptLanguage, entityModel, sortsString);
    }
}

