/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.extension;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.vulcan.extension.ExtensionProvider;
import com.liferay.portal.vulcan.extension.PropertyDefinition;
import com.liferay.portal.vulcan.extension.validation.PropertyValidator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ValidationException;

public class EntityExtensionHandler {
    private final String _className;
    private final List<ExtensionProvider> _extensionProviders;

    public EntityExtensionHandler(String className, List<ExtensionProvider> extensionProviders) {
        this._className = className;
        this._extensionProviders = extensionProviders;
    }

    public Map<String, Serializable> getExtendedProperties(long companyId, Object entity) throws Exception {
        HashMap<String, Serializable> extendedProperties = new HashMap<String, Serializable>();
        for (ExtensionProvider extensionProvider : this._extensionProviders) {
            extendedProperties.putAll(extensionProvider.getExtendedProperties(companyId, this._className, entity));
        }
        return extendedProperties;
    }

    public Map<String, PropertyDefinition> getExtendedPropertyDefinitions(long companyId, String className) throws Exception {
        HashMap<String, PropertyDefinition> propertyDefinitions = new HashMap<String, PropertyDefinition>();
        for (ExtensionProvider extensionProvider : this._extensionProviders) {
            propertyDefinitions.putAll(extensionProvider.getExtendedPropertyDefinitions(companyId, className));
        }
        return propertyDefinitions;
    }

    public Set<String> getFilteredPropertyNames(long companyId, Object entity) {
        HashSet<String> filteredPropertyNames = new HashSet<String>();
        for (ExtensionProvider extensionProvider : this._extensionProviders) {
            filteredPropertyNames.addAll(extensionProvider.getFilteredPropertyNames(companyId, entity));
        }
        return filteredPropertyNames;
    }

    public void setExtendedProperties(long companyId, long userId, Object entity, Map<String, Serializable> extendedProperties) throws Exception {
        for (ExtensionProvider extensionProvider : this._extensionProviders) {
            HashMap<String, Serializable> extensionProviderExtendedProperties = new HashMap<String, Serializable>();
            Map extendedPropertyDefinitions = extensionProvider.getExtendedPropertyDefinitions(companyId, this._className);
            for (Map.Entry<String, Serializable> entry : extendedProperties.entrySet()) {
                if (!extendedPropertyDefinitions.containsKey(entry.getKey())) continue;
                extensionProviderExtendedProperties.put(entry.getKey(), entry.getValue());
            }
            extensionProvider.setExtendedProperties(companyId, userId, this._className, entity, extensionProviderExtendedProperties);
        }
    }

    public void validate(long companyId, Map<String, Serializable> extendedProperties, boolean partialUpdate) throws Exception {
        HashMap propertyDefinitions = new HashMap();
        for (ExtensionProvider extensionProvider : this._extensionProviders) {
            propertyDefinitions.putAll(extensionProvider.getExtendedPropertyDefinitions(companyId, this._className));
        }
        ArrayList<String> unknownPropertyNames = new ArrayList<String>();
        for (Map.Entry<String, Serializable> entry : extendedProperties.entrySet()) {
            String extendedPropertyName = entry.getKey();
            if (!propertyDefinitions.containsKey(extendedPropertyName)) {
                unknownPropertyNames.add(extendedPropertyName);
                continue;
            }
            PropertyDefinition propertyDefinition = (PropertyDefinition)propertyDefinitions.get(extendedPropertyName);
            PropertyValidator propertyValidator = propertyDefinition.getPropertyValidator();
            propertyValidator.validate(propertyDefinition, (Object)entry.getValue());
            propertyDefinitions.remove(extendedPropertyName);
        }
        if (ListUtil.isNotEmpty(unknownPropertyNames)) {
            throw new ValidationException("The properties [" + ListUtil.toString(unknownPropertyNames, (String)"") + "] are unknown");
        }
        if (partialUpdate) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PropertyDefinition propertyDefinition : propertyDefinitions.values()) {
            if (!propertyDefinition.isRequired()) continue;
            arrayList.add(propertyDefinition.getPropertyName());
        }
        if (ListUtil.isNotEmpty(arrayList)) {
            throw new ValidationException("The properties [" + ListUtil.toString(arrayList, (String)"") + "] are required");
        }
    }
}

