/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.dto.converter;

import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOMapper;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(immediate=true, service={DTOMapper.class})
public class DTOMapperImpl
implements DTOMapper {
    private BundleContext _bundleContext;
    private final Map<String, String> _externalInternalDTOClassNameMap = new HashMap<String, String>();
    private final ServiceListener _serviceListener = new DTOConverterServiceListener();

    public String toInternalDTOClassName(String externalDTOClassName) {
        return this._externalInternalDTOClassNameMap.get(externalDTOClassName);
    }

    @Activate
    protected void activate(BundleContext bundleContext) throws Exception {
        this._bundleContext = bundleContext;
        bundleContext.addServiceListener(this._serviceListener, "(objectClass=" + DTOConverter.class.getName() + ")");
    }

    @Deactivate
    protected void deactivate() {
        this._bundleContext.removeServiceListener(this._serviceListener);
    }

    private class DTOConverterServiceListener
    implements ServiceListener {
        private DTOConverterServiceListener() {
        }

        public void serviceChanged(ServiceEvent serviceEvent) {
            String externalDTOClassName;
            ServiceReference serviceReference = serviceEvent.getServiceReference();
            DTOConverter dtoConverter = (DTOConverter)DTOMapperImpl.this._bundleContext.getService(serviceReference);
            String internalDTOClassName = (String)serviceReference.getProperty("dto.class.name");
            if (internalDTOClassName == null) {
                internalDTOClassName = this._getDTOConverterGenericType(dtoConverter, 0);
            }
            if ((externalDTOClassName = (String)serviceReference.getProperty("external.dto.class.name")) == null) {
                externalDTOClassName = this._getDTOConverterGenericType(dtoConverter, 1);
            }
            if (externalDTOClassName == null && internalDTOClassName == null) {
                DTOMapperImpl.this._bundleContext.ungetService(serviceReference);
                return;
            }
            if (serviceEvent.getType() == 1) {
                DTOMapperImpl.this._externalInternalDTOClassNameMap.put(externalDTOClassName, internalDTOClassName);
            } else if (serviceEvent.getType() == 4) {
                DTOMapperImpl.this._externalInternalDTOClassNameMap.remove(externalDTOClassName);
            }
            DTOMapperImpl.this._bundleContext.ungetService(serviceReference);
        }

        private String _getDTOConverterGenericType(DTOConverter<?, ?> dtoConverter, int genericTypeIndex) {
            Type[] genericInterfaceTypes;
            Class<?> dtoConverterClass = dtoConverter.getClass();
            for (Type genericInterfaceType : genericInterfaceTypes = dtoConverterClass.getGenericInterfaces()) {
                ParameterizedType parameterizedType;
                if (!(genericInterfaceType instanceof ParameterizedType) || (parameterizedType = (ParameterizedType)genericInterfaceType).getRawType() != DTOConverter.class) continue;
                Type[] genericTypes = parameterizedType.getActualTypeArguments();
                Class resourceGenericType = (Class)genericTypes[genericTypeIndex];
                return resourceGenericType.getName();
            }
            return null;
        }
    }
}

