/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.batch.engine;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegateRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true, service={VulcanBatchEngineTaskItemDelegateRegistry.class})
public class VulcanBatchEngineTaskItemDelegateRegistryImpl
implements VulcanBatchEngineTaskItemDelegateRegistry {
    private final Map<String, Boolean> _batchPlannerExportEnabledMap = new HashMap<String, Boolean>();
    private final Map<String, Boolean> _batchPlannerImportEnabledMap = new HashMap<String, Boolean>();
    private ServiceTracker<?, ?> _serviceTracker;
    private final Map<String, VulcanBatchEngineTaskItemDelegate<?>> _vulcanBatchEngineTaskItemDelegateMap = new HashMap();

    public Set<String> getEntityClassNames() {
        return this._vulcanBatchEngineTaskItemDelegateMap.keySet();
    }

    public VulcanBatchEngineTaskItemDelegate<?> getVulcanBatchEngineTaskItemDelegate(String entityClassName) {
        return this._vulcanBatchEngineTaskItemDelegateMap.get(entityClassName);
    }

    public boolean isBatchPlannerExportEnabled(String entityClassName) {
        return this._batchPlannerExportEnabledMap.get(entityClassName);
    }

    public boolean isBatchPlannerImportEnabled(String entityClassName) {
        return this._batchPlannerImportEnabledMap.get(entityClassName);
    }

    @Activate
    protected void activate(BundleContext bundleContext) throws InvalidSyntaxException {
        Filter filter = bundleContext.createFilter("(batch.engine.task.item.delegate=true)");
        this._serviceTracker = new ServiceTracker(bundleContext, filter, (ServiceTrackerCustomizer)new VulcanBatchEngineTaskItemDelegateServiceTrackerCustomizer(bundleContext));
        this._serviceTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
    }

    private class VulcanBatchEngineTaskItemDelegateServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<VulcanBatchEngineTaskItemDelegate<?>, VulcanBatchEngineTaskItemDelegate<?>> {
        private final BundleContext _bundleContext;

        public VulcanBatchEngineTaskItemDelegate<?> addingService(ServiceReference<VulcanBatchEngineTaskItemDelegate<?>> serviceReference) {
            VulcanBatchEngineTaskItemDelegate vulcanBatchEngineTaskItemDelegate = (VulcanBatchEngineTaskItemDelegate)this._bundleContext.getService(serviceReference);
            String entityClassName = (String)serviceReference.getProperty("entity.class.name");
            VulcanBatchEngineTaskItemDelegateRegistryImpl.this._batchPlannerExportEnabledMap.put(entityClassName, GetterUtil.getBoolean((Object)serviceReference.getProperty("batch.planner.export.enabled")));
            VulcanBatchEngineTaskItemDelegateRegistryImpl.this._batchPlannerImportEnabledMap.put(entityClassName, GetterUtil.getBoolean((Object)serviceReference.getProperty("batch.planner.import.enabled")));
            VulcanBatchEngineTaskItemDelegateRegistryImpl.this._vulcanBatchEngineTaskItemDelegateMap.put(entityClassName, vulcanBatchEngineTaskItemDelegate);
            return vulcanBatchEngineTaskItemDelegate;
        }

        public void modifiedService(ServiceReference<VulcanBatchEngineTaskItemDelegate<?>> serviceReference, VulcanBatchEngineTaskItemDelegate<?> vulcanBatchEngineTaskItemDelegate) {
        }

        public void removedService(ServiceReference<VulcanBatchEngineTaskItemDelegate<?>> serviceReference, VulcanBatchEngineTaskItemDelegate<?> vulcanBatchEngineTaskItemDelegate) {
            String entityClassName = (String)serviceReference.getProperty("entity.class.name");
            VulcanBatchEngineTaskItemDelegateRegistryImpl.this._batchPlannerExportEnabledMap.remove(entityClassName);
            VulcanBatchEngineTaskItemDelegateRegistryImpl.this._batchPlannerImportEnabledMap.remove(entityClassName);
            VulcanBatchEngineTaskItemDelegateRegistryImpl.this._vulcanBatchEngineTaskItemDelegateMap.remove(entityClassName);
        }

        private VulcanBatchEngineTaskItemDelegateServiceTrackerCustomizer(BundleContext bundleContext) {
            this._bundleContext = bundleContext;
        }
    }
}

