/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.writer.interceptor;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.internal.jaxrs.extension.ExtendedEntity;
import com.liferay.portal.vulcan.jaxrs.context.ExtensionContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;

@Provider
public class PageEntityExtensionWriterInterceptor
implements WriterInterceptor {
    @Context
    private Providers _providers;

    public void aroundWriteTo(WriterInterceptorContext writerInterceptorContext) throws IOException {
        if (Page.class.isAssignableFrom(writerInterceptorContext.getType())) {
            ParameterizedType parameterizedType = (ParameterizedType)writerInterceptorContext.getGenericType();
            Type entityType = parameterizedType.getActualTypeArguments()[0];
            Optional.ofNullable(this._providers.getContextResolver(ExtensionContext.class, writerInterceptorContext.getMediaType())).map(contextResolver -> (ExtensionContext)contextResolver.getContext((Class)entityType)).ifPresent(extensionContext -> this._extendPageEntities((ExtensionContext)extensionContext, writerInterceptorContext));
        }
        writerInterceptorContext.proceed();
    }

    private void _extendPageEntities(ExtensionContext extensionContext, WriterInterceptorContext writerInterceptorContext) {
        Page page = (Page)writerInterceptorContext.getEntity();
        Collection items = page.getItems();
        Stream stream = items.stream();
        List extendedEntities = stream.map(entity -> ExtendedEntity.extend(entity, extensionContext.getExtendedProperties(entity), extensionContext.getFilteredPropertyKeys(entity))).collect(Collectors.toList());
        Pagination pagination = Pagination.of((int)GetterUtil.getInteger((Object)page.getPage()), (int)GetterUtil.getInteger((Object)page.getPageSize()));
        writerInterceptorContext.setEntity((Object)Page.of((Map)page.getActions(), extendedEntities, (Pagination)pagination, (long)page.getTotalCount()));
        writerInterceptorContext.setGenericType(new GenericType<Page<ExtendedEntity>>(){}.getType());
    }
}

