/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.writer.interceptor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.fields.NestedFieldsContext;
import com.liferay.portal.vulcan.fields.NestedFieldsContextThreadLocal;
import com.liferay.portal.vulcan.internal.fields.servlet.NestedFieldsHttpServletRequestWrapper;
import com.liferay.portal.vulcan.pagination.Page;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.message.Message;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Provider
public class NestedFieldsWriterInterceptor
implements WriterInterceptor {
    private static final Log _log = LogFactoryUtil.getLog(NestedFieldsWriterInterceptor.class);
    private final NestedFieldServiceTrackerCustomizer _nestedFieldServiceTrackerCustomizer;
    private final ServiceTracker<Object, List<FactoryKey>> _serviceTracker;

    public NestedFieldsWriterInterceptor(BundleContext bundleContext) {
        this(bundleContext, null);
    }

    public void aroundWriteTo(WriterInterceptorContext writerInterceptorContext) throws IOException, WebApplicationException {
        NestedFieldsContext nestedFieldsContext = NestedFieldsContextThreadLocal.getNestedFieldsContext();
        if (nestedFieldsContext == null) {
            writerInterceptorContext.proceed();
            return;
        }
        try {
            this._setFieldValues(writerInterceptorContext.getEntity(), nestedFieldsContext.getFieldNames(), nestedFieldsContext);
        }
        catch (Exception exception) {
            _log.error((Object)exception.getMessage(), (Throwable)exception);
            throw new WebApplicationException((Throwable)exception);
        }
        writerInterceptorContext.proceed();
    }

    public void destroy() {
        this._serviceTracker.close();
    }

    protected NestedFieldsWriterInterceptor(BundleContext bundleContext, NestedFieldServiceTrackerCustomizer nestedFieldServiceTrackerCustomizer) {
        if (nestedFieldServiceTrackerCustomizer == null) {
            nestedFieldServiceTrackerCustomizer = new NestedFieldServiceTrackerCustomizer(bundleContext);
        }
        this._nestedFieldServiceTrackerCustomizer = nestedFieldServiceTrackerCustomizer;
        try {
            this._serviceTracker = new ServiceTracker(bundleContext, bundleContext.createFilter("(&(api.version=*)(osgi.jaxrs.resource=true))"), (ServiceTrackerCustomizer)this._nestedFieldServiceTrackerCustomizer);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            throw new RuntimeException(invalidSyntaxException);
        }
        this._serviceTracker.open();
    }

    private static <A extends Annotation> A _getAnnotation(Class<A> annotationClass, Parameter parameter, Parameter[] parentParameters, int i) {
        A annotation = parameter.getAnnotation(annotationClass);
        if (annotation == null && parentParameters != null) {
            return parentParameters[i].getAnnotation(annotationClass);
        }
        return annotation;
    }

    private Object _adaptToFieldType(Class<?> fieldType, Object value) {
        if (value instanceof Page) {
            Page page = (Page)value;
            value = page.getItems();
        }
        if (fieldType.isArray() && value instanceof Collection) {
            Collection collection = (Collection)value;
            value = Array.newInstance(fieldType.getComponentType(), collection.size());
            int i = 0;
            for (Object object : collection) {
                Array.set(value, i++, object);
            }
        }
        return value;
    }

    private Field _getField(Class<?> entityClass, String fieldName) {
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(entityClass.getDeclaredFields()));
        Class<?> superClass = entityClass.getSuperclass();
        if (superClass != null) {
            Collections.addAll(fields, superClass.getDeclaredFields());
        }
        for (Field field : fields) {
            if (!Objects.equals(field.getName(), fieldName) && !Objects.equals(field.getName(), "_" + fieldName)) continue;
            return field;
        }
        return null;
    }

    private List<Object> _getItems(Object entity) {
        ArrayList<Object> items = new ArrayList<Object>();
        if (entity instanceof Collection) {
            items.addAll((Collection)entity);
        } else if (entity instanceof Page) {
            Page page = (Page)entity;
            items.addAll(page.getItems());
        } else if (this._isArray(entity)) {
            Collections.addAll(items, (Object[])entity);
        } else {
            items.add(entity);
        }
        return items;
    }

    private UnsafeTriFunction<String, Object, NestedFieldsContext, Object> _getUnsafeTriFunction(String fieldName, Class<?> itemClass, NestedFieldsContext nestedFieldsContext) {
        Class[] parentClasses;
        for (Class parentClass : parentClasses = new Class[]{Void.class, itemClass, itemClass.getSuperclass()}) {
            FactoryKey factoryKey = new FactoryKey(fieldName, parentClass, nestedFieldsContext.getResourceVersion());
            UnsafeTriFunction unsafeTriFunction = (UnsafeTriFunction)this._nestedFieldServiceTrackerCustomizer._unsafeTriFunctions.get(factoryKey);
            if (unsafeTriFunction == null) continue;
            return unsafeTriFunction;
        }
        return null;
    }

    private boolean _isArray(Object object) {
        Class<?> objectClass = object.getClass();
        return objectClass.isArray();
    }

    private void _setFieldValues(Object entity, List<String> fieldNames, NestedFieldsContext nestedFieldsContext) throws Exception {
        List<Object> items = this._getItems(entity);
        for (String fieldName : fieldNames) {
            String nestedField = null;
            int index = fieldName.indexOf(".");
            if (index != -1) {
                nestedField = fieldName.substring(index + 1);
                fieldName = fieldName.substring(0, index);
            }
            for (Object item : items) {
                Class<?> itemClass = item.getClass();
                Field field = this._getField(itemClass, fieldName);
                if (field == null) continue;
                field.setAccessible(true);
                UnsafeTriFunction<String, Object, NestedFieldsContext, Object> unsafeTriFunction = this._getUnsafeTriFunction(fieldName, itemClass, nestedFieldsContext);
                if (unsafeTriFunction == null) continue;
                Object value = this._adaptToFieldType(field.getType(), unsafeTriFunction.apply(fieldName, item, nestedFieldsContext));
                field.set(item, value);
                if (nestedField == null) continue;
                this._setFieldValues(value, Collections.singletonList(nestedField), nestedFieldsContext);
            }
        }
    }

    private static class FactoryKey {
        private final String _nestedFieldName;
        private final Class<?> _parentClass;
        private final String _resourceVersion;

        public boolean equals(Object object) {
            FactoryKey factoryKey = (FactoryKey)object;
            return Objects.equals(factoryKey._nestedFieldName, this._nestedFieldName) && Objects.equals(factoryKey._parentClass, this._parentClass) && Objects.equals(factoryKey._resourceVersion, this._resourceVersion);
        }

        public int hashCode() {
            int hashCode = HashUtil.hash((int)0, (Object)this._nestedFieldName);
            hashCode = HashUtil.hash((int)hashCode, this._parentClass);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._resourceVersion);
            return hashCode;
        }

        private FactoryKey(String nestedFieldName, Class<?> parentClass, String resourceVersion) {
            this._nestedFieldName = nestedFieldName;
            this._parentClass = parentClass;
            this._resourceVersion = resourceVersion;
        }
    }

    @FunctionalInterface
    protected static interface UnsafeTriFunction<A, B, C, R> {
        public R apply(A var1, B var2, C var3) throws Exception;
    }

    protected static class NestedFieldServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<Object, List<FactoryKey>> {
        private static final ObjectMapper _objectMapper = new ObjectMapper();
        private final BundleContext _bundleContext;
        private final Map<FactoryKey, UnsafeTriFunction<String, Object, NestedFieldsContext, Object>> _unsafeTriFunctions = new ConcurrentHashMap<FactoryKey, UnsafeTriFunction<String, Object, NestedFieldsContext, Object>>();

        public List<FactoryKey> addingService(ServiceReference<Object> serviceReference) {
            Object resource = this._bundleContext.getService(serviceReference);
            Class<?> resourceClass = resource.getClass();
            ArrayList<FactoryKey> factoryKeys = null;
            for (Method resourceMethod : resourceClass.getDeclaredMethods()) {
                NestedField nestedField = resourceMethod.getAnnotation(NestedField.class);
                if (nestedField == null) continue;
                Class parentClass = nestedField.parentClass();
                FactoryKey factoryKey = new FactoryKey(nestedField.value(), parentClass, this._getAPIVersion(resourceClass.getSuperclass()));
                ServiceObjects serviceObjects = this._bundleContext.getServiceObjects(serviceReference);
                this._unsafeTriFunctions.put(factoryKey, (fieldName, item, nestedFieldsContext) -> this._getNestedFieldValue((String)fieldName, item, (NestedFieldsContext)nestedFieldsContext, resourceMethod, this._getResourceMethodArgNameTypeEntries(resourceClass, resourceMethod), (ServiceObjects<Object>)serviceObjects));
                if (factoryKeys == null) {
                    factoryKeys = new ArrayList<FactoryKey>();
                }
                factoryKeys.add(factoryKey);
            }
            return factoryKeys;
        }

        public void modifiedService(ServiceReference<Object> serviceReference, List<FactoryKey> factoryKeys) {
        }

        public void removedService(ServiceReference<Object> serviceReference, List<FactoryKey> factoryKeys) {
            factoryKeys.forEach(this._unsafeTriFunctions::remove);
            this._bundleContext.ungetService(serviceReference);
        }

        protected NestedFieldServiceTrackerCustomizer(BundleContext bundleContext) {
            this._bundleContext = bundleContext;
        }

        protected HttpServletRequest getHttpServletRequest(Message message) {
            return (HttpServletRequest)message.getContextualProperty("HTTP.REQUEST");
        }

        protected ProviderFactory getProviderFactory(Message message) {
            return ProviderFactory.getInstance((Message)message);
        }

        private Object _convert(String value, Class<?> type) {
            if (value == null) {
                return null;
            }
            return _objectMapper.convertValue((Object)value, type);
        }

        private String _getAPIVersion(Class<?> resourceBaseClass) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = resourceBaseClass.getAnnotations()) {
                if (!(annotation instanceof Path)) continue;
                Path path = (Path)annotation;
                String resourceVersion = path.value();
                return resourceVersion.substring(1);
            }
            return null;
        }

        private <T> Object _getContext(Class<T> contextClass, Message message) {
            ContextProvider<T> contextProvider = this._getContextProvider(contextClass, message);
            if (contextProvider != null) {
                return contextProvider.createContext(message);
            }
            return null;
        }

        private <T> ContextProvider<T> _getContextProvider(Class<T> contextClass, Message message) {
            ProviderFactory providerFactory = this.getProviderFactory(message);
            return providerFactory.createContextProvider(contextClass, message);
        }

        private Object[] _getMethodArgs(String fieldName, Object item, NestedFieldsContext nestedFieldsContext, Method resourceMethod, Map.Entry<String, Class<?>>[] resourceMethodArgNameTypeEntries) throws Exception {
            Object[] args = new Object[resourceMethod.getParameterCount()];
            MultivaluedMap pathParameters = nestedFieldsContext.getPathParameters();
            MultivaluedMap queryParameters = nestedFieldsContext.getQueryParameters();
            for (int i = 0; i < resourceMethod.getParameterCount(); ++i) {
                if (resourceMethodArgNameTypeEntries[i] == null) continue;
                args[i] = this._getMethodArgValueFromRequest(fieldName, nestedFieldsContext, (MultivaluedMap<String, String>)pathParameters, (MultivaluedMap<String, String>)queryParameters, resourceMethodArgNameTypeEntries[i]);
                if (args[i] != null) continue;
                args[i] = this._getMethodArgValueFromItem(item, resourceMethodArgNameTypeEntries[i]);
            }
            return args;
        }

        private Object _getMethodArgValueFromItem(Object item, Map.Entry<String, Class<?>> resourceMethodArgNameTypeEntry) throws Exception {
            ArrayList itemClasses = new ArrayList();
            Class<?> itemClass = item.getClass();
            itemClasses.add(itemClass);
            itemClasses.add(itemClass.getSuperclass());
            for (Class clazz : itemClasses) {
                try {
                    Field itemField = clazz.getDeclaredField(resourceMethodArgNameTypeEntry.getKey());
                    if (itemField == null) continue;
                    itemField.setAccessible(true);
                    return itemField.get(item);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)noSuchFieldException.getMessage());
                }
            }
            return null;
        }

        private Object _getMethodArgValueFromRequest(String fieldName, NestedFieldsContext nestedFieldsContext, MultivaluedMap<String, String> pathParameters, MultivaluedMap<String, String> queryParameters, Map.Entry<String, Class<?>> resourceMethodArgNameTypeEntry) {
            Message message;
            Object argValue = null;
            Class<?> resourceMethodArgType = resourceMethodArgNameTypeEntry.getValue();
            Object context = this._getContext(resourceMethodArgType, message = this._getNestedFieldsAwareMessage(fieldName, nestedFieldsContext.getMessage()));
            if (context != null) {
                argValue = context;
                this._resetNestedAwareMessage(message);
            } else {
                argValue = this._convert((String)pathParameters.getFirst((Object)resourceMethodArgNameTypeEntry.getKey()), resourceMethodArgType);
                if (argValue == null) {
                    argValue = this._convert((String)queryParameters.getFirst((Object)(fieldName + "." + resourceMethodArgNameTypeEntry.getKey())), resourceMethodArgType);
                }
            }
            return argValue;
        }

        private Message _getNestedFieldsAwareMessage(String fieldName, Message message) {
            message.put((Object)"HTTP.REQUEST", (Object)new NestedFieldsHttpServletRequestWrapper(fieldName, this.getHttpServletRequest(message)));
            return message;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object _getNestedFieldValue(String fieldName, Object item, NestedFieldsContext nestedFieldsContext, Method resourceMethod, Map.Entry<String, Class<?>>[] resourceMethodArgNameTypeEntries, ServiceObjects<Object> serviceObjects) throws Exception {
            Object resource = serviceObjects.getService();
            try {
                this._setResourceContexts(nestedFieldsContext.getMessage(), resource);
                Object[] args = this._getMethodArgs(fieldName, item, nestedFieldsContext, resourceMethod, resourceMethodArgNameTypeEntries);
                Object object = resourceMethod.invoke(resource, args);
                return object;
            }
            finally {
                serviceObjects.ungetService(resource);
            }
        }

        private Map.Entry<String, Class<?>>[] _getResourceMethodArgNameTypeEntries(Class<?> resourceClass, Method resourceMethod) {
            Parameter[] parentParameters;
            Map.Entry[] resourceMethodArgNameTypeEntries;
            Parameter[] resourceMethodParameters;
            block6: {
                resourceMethodParameters = resourceMethod.getParameters();
                resourceMethodArgNameTypeEntries = new Map.Entry[resourceMethodParameters.length];
                parentParameters = null;
                try {
                    Class<?> parentResourceClass = resourceClass.getSuperclass();
                    Method parentResourceMethod = parentResourceClass.getMethod(resourceMethod.getName(), resourceMethod.getParameterTypes());
                    parentParameters = parentResourceMethod.getParameters();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (!_log.isDebugEnabled()) break block6;
                    _log.debug((Object)noSuchMethodException.getMessage());
                }
            }
            for (int i = 0; i < resourceMethodParameters.length; ++i) {
                Parameter parameter = resourceMethodParameters[i];
                NestedFieldId nestedFieldId = (NestedFieldId)NestedFieldsWriterInterceptor._getAnnotation(NestedFieldId.class, parameter, parentParameters, i);
                Class<?> parameterType = parameter.getType();
                if (nestedFieldId == null) {
                    QueryParam queryParam;
                    PathParam pathParam;
                    Context context = (Context)NestedFieldsWriterInterceptor._getAnnotation(Context.class, parameter, parentParameters, i);
                    if (context != null) {
                        resourceMethodArgNameTypeEntries[i] = new AbstractMap.SimpleImmutableEntry(parameter.getName(), parameterType);
                    }
                    if ((pathParam = (PathParam)NestedFieldsWriterInterceptor._getAnnotation(PathParam.class, parameter, parentParameters, i)) != null) {
                        resourceMethodArgNameTypeEntries[i] = new AbstractMap.SimpleImmutableEntry(pathParam.value(), parameterType);
                    }
                    if ((queryParam = (QueryParam)NestedFieldsWriterInterceptor._getAnnotation(QueryParam.class, parameter, parentParameters, i)) == null) continue;
                    resourceMethodArgNameTypeEntries[i] = new AbstractMap.SimpleImmutableEntry(queryParam.value(), parameterType);
                    continue;
                }
                resourceMethodArgNameTypeEntries[i] = new AbstractMap.SimpleImmutableEntry(nestedFieldId.value(), parameterType);
            }
            return resourceMethodArgNameTypeEntries;
        }

        private void _resetNestedAwareMessage(Message message) {
            NestedFieldsHttpServletRequestWrapper nestedFieldsHttpServletRequestWrapper = (NestedFieldsHttpServletRequestWrapper)((Object)message.getContextualProperty("HTTP.REQUEST"));
            message.put((Object)"HTTP.REQUEST", (Object)nestedFieldsHttpServletRequestWrapper.getRequest());
        }

        private void _setContextFields(Field[] fields, Message message, Object resource) throws Exception {
            for (Field field : fields) {
                String name = field.getName();
                if (!name.startsWith("context") && field.getAnnotation(Context.class) == null) continue;
                field.setAccessible(true);
                field.set(resource, this._getContext(field.getType(), message));
            }
        }

        private void _setResourceContexts(Message message, Object resource) throws Exception {
            Class<?> resourceClass = resource.getClass();
            this._setContextFields(resourceClass.getDeclaredFields(), message, resource);
            Class<?> superClass = resourceClass.getSuperclass();
            this._setContextFields(superClass.getDeclaredFields(), message, resource);
        }
    }
}

