/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.vulcan.internal.jaxrs.context.provider;

import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.CollectionEntityField;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.internal.accept.language.AcceptLanguageImpl;
import com.liferay.portal.vulcan.internal.jaxrs.context.provider.ContextProviderUtil;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.apache.cxf.message.Message;

@Provider
public class AggregationContextProvider
implements ContextProvider<Aggregation> {
    private final Language _language;
    private final Portal _portal;

    public AggregationContextProvider(Language language, Portal portal) {
        this._language = language;
        this._portal = portal;
    }

    public Aggregation createContext(AcceptLanguage acceptLanguage, String[] aggregationTermsArray, EntityModel entityModel) {
        if (aggregationTermsArray == null || entityModel == null) {
            return null;
        }
        Map entityFieldsMap = entityModel.getEntityFieldsMap();
        Aggregation aggregation = new Aggregation();
        Map aggregationTerms = aggregation.getAggregationTerms();
        for (String aggregationTerm : aggregationTermsArray) {
            if (entityFieldsMap.containsKey(aggregationTerm)) {
                EntityField entityField = (EntityField)entityFieldsMap.get(aggregationTerm);
                if (EntityField.Type.COLLECTION.equals((Object)entityField.getType())) {
                    CollectionEntityField collectionEntityField = (CollectionEntityField)entityField;
                    entityField = collectionEntityField.getEntityField();
                }
                aggregationTerms.put(aggregationTerm, entityField.getFilterableName(acceptLanguage.getPreferredLocale()));
                continue;
            }
            aggregationTerms.put(aggregationTerm, aggregationTerm);
        }
        return aggregation;
    }

    public Aggregation createContext(Message message) {
        try {
            HttpServletRequest httpServletRequest = ContextProviderUtil.getHttpServletRequest(message);
            return this.createContext(new AcceptLanguageImpl(httpServletRequest, this._language, this._portal), ParamUtil.getStringValues((HttpServletRequest)httpServletRequest, (String)"aggregationTerms"), ContextProviderUtil.getEntityModel(message));
        }
        catch (Exception exception) {
            throw new ServerErrorException(500, (Throwable)exception);
        }
    }
}

